<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta http-equiv="X-Content-Type-Options" content="nosniff">
    <meta http-equiv="X-Frame-Options" content="DENY">
    <meta http-equiv="X-XSS-Protection" content="1; mode=block">
    <meta name="referrer" content="strict-origin-when-cross-origin">
    <title>@yield('title', 'Sistem Informasi Anggota PKS')</title>
    
    <!-- Favicon -->
    <link rel="icon" type="image/svg+xml" href="{{ asset('favicon.svg') }}">
    <link rel="icon" type="image/x-icon" href="{{ asset('favicon.ico') }}">
    <link rel="shortcut icon" type="image/x-icon" href="{{ asset('favicon.ico') }}">
    <link rel="apple-touch-icon" href="{{ asset('favicon.svg') }}">
    
    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <!-- DataTables CSS -->
    <link href="https://cdn.datatables.net/1.13.4/css/dataTables.bootstrap5.min.css" rel="stylesheet">
    <!-- Select2 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet">
    <!-- Select2 Bootstrap 5 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/[email protected]/dist/css/select2-bootstrap-5-theme.min.css" rel="stylesheet">
    <!-- SweetAlert2 CSS -->
    <link href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css" rel="stylesheet">
    <!-- Mobile Responsive CSS -->
    <link href="{{ asset('css/mobile-responsive.css') }}" rel="stylesheet">
    
    @stack('styles')
    
    <style>
        :root {
            --pks-orange: #F0833A;
            --pks-orange-dark: #E67E22;
            --pks-orange-light: #F39C12;
            --pks-orange-lighter: #FDEBD0;
            --pks-gray: #424242;
            --pks-gray-light: #757575;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        
        body.sidebar-open {
            overflow: hidden;
        }
        
        .sidebar {
            background: linear-gradient(135deg, var(--pks-orange) 0%, var(--pks-orange-dark) 100%);
            min-height: 100vh;
            box-shadow: 2px 0 10px rgba(240, 131, 58, 0.3);
        }
        
        .sidebar .nav-link {
            color: rgba(255, 255, 255, 0.9);
            border-radius: 10px;
            margin: 3px 0;
            padding: 12px 16px;
            transition: all 0.3s ease;
            font-weight: 500;
        }
        
        .sidebar .nav-link:hover {
            background: rgba(255, 255, 255, 0.1);
            color: white;
            transform: translateX(5px);
        }
        
        .sidebar .nav-link.active {
            background: rgba(255, 255, 255, 0.2);
            color: white;
            transform: translateX(5px);
            box-shadow: 0 4px 15px rgba(255, 255, 255, 0.1);
        }
        
        .sidebar .nav-link i {
            width: 20px;
            text-align: center;
        }
        
        /* Dropdown Styling */
        .nav-item.dropdown .dropdown-menu {
            background-color: rgba(240, 131, 58, 0.95);
            border: none;
            border-radius: 8px;
            box-shadow: 0 4px 15px rgba(0, 0, 0, 0.2);
            margin-top: 0 !important;
            position: absolute !important;
            top: 100% !important;
            left: 0 !important;
            right: auto !important;
            z-index: 1000;
            min-width: 200px;
            transform: translateY(0) !important;
        }
        
        .nav-item.dropdown .dropdown-item {
            color: white;
            padding: 0.75rem 1.5rem;
            transition: all 0.3s ease;
        }
        
        .nav-item.dropdown .dropdown-item:hover {
            background-color: rgba(255, 255, 255, 0.1);
            color: white;
            transform: translateX(5px);
        }
        
        .nav-item.dropdown .dropdown-item:not(:hover) {
            background-color: transparent;
            transform: translateX(0);
        }
        
        .nav-item.dropdown .dropdown-item.active {
            background-color: rgba(255, 255, 255, 0.2);
            color: white;
            font-weight: 600;
        }
        
        .nav-item.dropdown .dropdown-toggle::after {
            margin-left: 0.5rem;
            vertical-align: 0.15em;
        }
        
        /* Fix dropdown positioning - no gap */
        .nav-item.dropdown {
            position: relative;
        }
        
        .nav-item.dropdown .dropdown-menu.show {
            margin-top: 0 !important;
            top: 100% !important;
            left: 0 !important;
            transform: translateY(0) !important;
            display: block !important;
        }
        
        /* Override Bootstrap dropdown positioning */
        .sidebar .nav-item.dropdown .dropdown-menu {
            margin-top: 0 !important;
            top: 100% !important;
            left: 0 !important;
            right: auto !important;
            transform: translateY(0) !important;
            position: absolute !important;
        }
        
        .main-content {
            background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
            min-height: 100vh;
            overflow-x: hidden;
            position: relative;
            z-index: 1;
        }
        
        /* Info box styling (not affected by auto-hide) */
        .info-box {
            background-color: #d1ecf1;
            border: 1px solid #bee5eb;
            border-radius: 0.375rem;
            color: #0c5460;
            padding: 1rem;
        }
        
        .container-fluid {
            max-width: 100%;
            overflow-x: hidden;
        }
        
        .row {
            margin-left: 0;
            margin-right: 0;
        }
        
        .card {
            border: none;
            box-shadow: 0 4px 20px rgba(255, 87, 34, 0.1);
            border-radius: 15px;
            transition: transform 0.3s ease;
        }
        
        .card:hover {
            transform: translateY(-2px);
            box-shadow: 0 8px 30px rgba(255, 87, 34, 0.15);
        }
        
        .card-header {
            background: linear-gradient(135deg, var(--pks-orange) 0%, var(--pks-orange-dark) 100%);
            color: white;
            border-radius: 15px 15px 0 0 !important;
            font-weight: 600;
            padding: 1.2rem 1.5rem;
        }
        
        .btn-primary {
            background: linear-gradient(135deg, var(--pks-orange) 0%, var(--pks-orange-dark) 100%);
            border: none;
            border-radius: 8px;
            font-weight: 500;
            padding: 0.6rem 1.5rem;
            transition: all 0.3s ease;
        }
        
        .btn-primary:hover {
            background: linear-gradient(135deg, var(--pks-orange-dark) 0%, #D84315 100%);
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(255, 87, 34, 0.4);
        }
        
        .btn-outline-primary {
            color: var(--pks-orange);
            border-color: var(--pks-orange);
            border-radius: 8px;
            font-weight: 500;
        }
        
        .btn-outline-primary:hover {
            background-color: var(--pks-orange);
            border-color: var(--pks-orange);
        }
        
        .navbar-brand {
            font-weight: 700;
            color: var(--pks-orange) !important;
        }
        
        .stats-card {
            border-left: 4px solid var(--pks-orange);
            background: white;
            border-radius: 10px;
            padding: 1.5rem;
            margin-bottom: 1.5rem;
            box-shadow: 0 2px 15px rgba(255, 87, 34, 0.1);
            transition: all 0.3s ease;
        }
        
        .stats-card:hover {
            transform: translateY(-3px);
            box-shadow: 0 8px 25px rgba(255, 87, 34, 0.2);
        }
        
        .stats-card.primary { border-left-color: var(--pks-orange); }
        .stats-card.success { border-left-color: #4CAF50; }
        .stats-card.info { border-left-color: #2196F3; }
        .stats-card.warning { border-left-color: #FF9800; }
        
        .stats-number {
            font-size: 2.5rem;
            font-weight: 700;
            color: var(--pks-gray);
            margin-bottom: 0.5rem;
        }
        
        .stats-label {
            color: var(--pks-gray-light);
            font-weight: 500;
            text-transform: uppercase;
            font-size: 0.875rem;
            letter-spacing: 0.5px;
        }
        
        .stats-icon {
            font-size: 3rem;
            color: var(--pks-orange-light);
            opacity: 0.7;
        }
        
        .navbar {
            background: white !important;
            box-shadow: 0 2px 10px rgba(255, 87, 34, 0.1);
            border-bottom: 2px solid var(--pks-orange-lighter);
        }
        
        .alert-success {
            background-color: #E8F5E8;
            border-color: #4CAF50;
            color: #2E7D2E;
            border-radius: 10px;
        }
        
        .alert-danger {
            background-color: #FFEBEE;
            border-color: #F44336;
            color: #C62828;
            border-radius: 10px;
        }
        
        .text-primary {
            color: var(--pks-orange) !important;
        }
        
        .bg-primary {
            background-color: var(--pks-orange) !important;
        }
        
        .border-primary {
            border-color: var(--pks-orange) !important;
        }
        
        .sidebar-brand {
            padding: 1.5rem;
            border-bottom: 1px solid rgba(255, 255, 255, 0.1);
            margin-bottom: 1rem;
        }
        
        .sidebar-brand h4 {
            color: white;
            margin-bottom: 0.5rem;
            font-weight: 700;
        }
        
        .sidebar-brand small {
            color: rgba(255, 255, 255, 0.7);
            font-size: 0.875rem;
        }
        
        .dropdown-toggle {
            background: linear-gradient(135deg, var(--pks-orange-light) 0%, var(--pks-orange) 100%);
            border: none;
            color: white;
            border-radius: 8px;
            font-weight: 500;
        }
        
        .dropdown-toggle:hover {
            background: linear-gradient(135deg, var(--pks-orange) 0%, var(--pks-orange-dark) 100%);
        }
        
        .table th {
            background-color: var(--pks-orange-lighter);
            color: var(--pks-gray);
            font-weight: 600;
            border: none;
        }
        
        .badge {
            border-radius: 20px;
            font-weight: 500;
            padding: 0.4em 0.8em;
        }
        
        .badge.bg-success { background-color: #4CAF50 !important; }
        .badge.bg-warning { background-color: #FF9800 !important; }
        .badge.bg-danger { background-color: #F44336 !important; }
        .badge.bg-info { background-color: #2196F3 !important; }
        
        /* Chart containers */
        .chart-container {
            position: relative;
            height: 300px;
            margin: 1rem 0;
        }
        
        /* Loading spinner */
        .spinner-pks {
            border: 3px solid var(--pks-orange-lighter);
            border-top: 3px solid var(--pks-orange);
            border-radius: 50%;
            width: 40px;
            height: 40px;
            animation: spin 1s linear infinite;
        }
        
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        
        /* Quick actions */
        .quick-action-card {
            background: white;
            border-radius: 15px;
            padding: 2rem;
            text-align: center;
            transition: all 0.3s ease;
            border: 2px solid transparent;
        }
        
        .quick-action-card:hover {
            border-color: var(--pks-orange-light);
            transform: translateY(-5px);
            box-shadow: 0 10px 30px rgba(240, 131, 58, 0.2);
        }
        
        .quick-action-icon {
            font-size: 3rem;
            color: var(--pks-orange);
            margin-bottom: 1rem;
        }
        
        /* Custom scrollbar */
        .sidebar::-webkit-scrollbar {
            width: 6px;
        }
        
        .sidebar::-webkit-scrollbar-track {
            background: rgba(255, 255, 255, 0.1);
        }
        
        .sidebar::-webkit-scrollbar-thumb {
            background: rgba(255, 255, 255, 0.3);
            border-radius: 3px;
        }
        
        .sidebar::-webkit-scrollbar-thumb:hover {
            background: rgba(255, 255, 255, 0.5);
        }
        
        /* User Dropdown Styles */
        .dropdown {
            position: relative;
        }
        
        #userDropdown {
            position: relative;
            overflow: visible;
        }
        
        #userDropdown:hover {
            background-color: rgba(0, 123, 255, 0.1) !important;
            color: #007bff !important;
            transform: translateY(-1px);
        }
        
        #userDropdown:focus {
            box-shadow: 0 0 0 0.2rem rgba(0, 123, 255, 0.25);
            outline: none;
        }
        
        .dropdown-menu {
            animation: dropdownFadeIn 0.3s ease-out;
            transform-origin: top;
            position: absolute !important;
            top: 100% !important;
            right: 0 !important;
            left: auto !important;
            z-index: 1050 !important;
            max-height: none !important;
            overflow: visible !important;
        }
        
        @keyframes dropdownFadeIn {
            from {
                opacity: 0;
                transform: translateY(-10px) scale(0.95);
            }
            to {
                opacity: 1;
                transform: translateY(0) scale(1);
            }
        }
        
        .dropdown-item {
            position: relative;
            overflow: hidden;
        }
        
        .dropdown-item:hover {
            background-color: #f8f9fa;
            transform: translateX(4px);
        }
        
        .dropdown-item:active {
            background-color: #e9ecef;
        }
        
        .dropdown-item.text-danger:hover {
            background-color: #f8d7da;
            color: #721c24 !important;
        }
        
        .dropdown-item.text-danger:active {
            background-color: #f5c6cb;
        }
        
        /* Smooth transitions for all dropdown elements */
        .dropdown-toggle::after {
            display: none;
        }
        
        .dropdown-menu li {
            margin: 0;
        }
        
        .dropdown-menu li:first-child .dropdown-item {
            border-radius: 8px 8px 0 0;
        }
        
        .dropdown-menu li:last-child .dropdown-item {
            border-radius: 0 0 8px 8px;
        }
        
        .dropdown-menu li:only-child .dropdown-item {
            border-radius: 8px;
        }
        
        /* Custom pagination styling untuk ukuran lebih kecil */
        .pagination {
            font-size: 0.875rem;
            margin-bottom: 0;
        }
        
        .pagination .page-link {
            padding: 0.375rem 0.75rem;
            font-size: 0.875rem;
            border-radius: 0.375rem;
            margin: 0 0.125rem;
            border: 1px solid #dee2e6;
            color: #6c757d;
            text-decoration: none;
            transition: all 0.15s ease-in-out;
        }
        
        .pagination .page-link:hover {
            color: #0056b3;
            background-color: #e9ecef;
            border-color: #dee2e6;
        }
        
        .pagination .page-item.active .page-link {
            background-color: #007bff;
            border-color: #007bff;
            color: white;
        }
        
        .pagination .page-item.disabled .page-link {
            color: #6c757d;
            background-color: #fff;
            border-color: #dee2e6;
        }
        
        .pagination .page-item:first-child .page-link,
        .pagination .page-item:last-child .page-link {
            border-radius: 0.375rem;
        }
        
        /* Footer styling */
        .bg-gradient-primary {
            background: linear-gradient(135deg, var(--pks-orange) 0%, var(--pks-orange-dark) 100%);
        }
        
        footer {
            box-shadow: 0 -2px 10px rgba(255, 87, 34, 0.3);
            border-top: 3px solid var(--pks-orange-light);
        }
        
        footer .text-warning {
            color: #FFD700 !important;
            animation: heartbeat 2s ease-in-out infinite;
        }
        
        @keyframes heartbeat {
            0%, 100% { transform: scale(1); }
            50% { transform: scale(1.1); }
        }
        
        footer small {
            font-size: 0.875rem;
        }
        
        /* Loading time styling */
        #loading-time {
            font-size: 0.75rem;
            margin-top: 0.25rem;
        }
        
        #loading-time .text-success {
            color: #28a745 !important;
        }
        
        #loading-time .text-warning {
            color: #ffc107 !important;
        }
        
        #loading-time .text-danger {
            color: #dc3545 !important;
        }
        
        /* Mobile Responsive Styles */
        @media (max-width: 768px) {
            /* Sidebar mobile */
            .sidebar {
                position: fixed;
                top: 0;
                left: -100%;
                width: 280px;
                height: 100vh;
                z-index: 1050;
                transition: left 0.3s ease;
                overflow-y: auto;
                background: linear-gradient(135deg, var(--pks-orange) 0%, var(--pks-orange-dark) 100%);
            }
            
            .sidebar.show {
                left: 0;
                box-shadow: 2px 0 20px rgba(0, 0, 0, 0.3);
            }
            
            /* Mobile sidebar overlay */
            .sidebar-overlay {
                position: fixed;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
                background: rgba(0, 0, 0, 0.5);
                z-index: 1040;
                display: none;
                opacity: 0;
                transition: opacity 0.3s ease;
            }
            
            .sidebar-overlay.show {
                display: block;
                opacity: 1;
            }
            
            /* Main content mobile */
            .main-content {
                margin-left: 0;
                width: 100%;
            }
            
            /* Mobile navigation */
            .navbar-toggler {
                border: none;
                padding: 0.25rem 0.5rem;
                font-size: 1.25rem;
                background: var(--pks-orange);
                color: white;
                border-radius: 0.375rem;
            }
            
            .navbar-toggler:focus {
                box-shadow: 0 0 0 0.2rem rgba(255, 87, 34, 0.25);
            }
            
            /* Mobile stats cards */
            .stats-card {
                margin-bottom: 1rem;
                padding: 1rem;
            }
            
            .stats-number {
                font-size: 2rem;
            }
            
            .stats-icon {
                font-size: 2.5rem;
            }
            
            /* Mobile table responsive */
            .table-responsive {
                border: none;
            }
            
            .table {
                font-size: 0.875rem;
            }
            
            .table th,
            .table td {
                padding: 0.5rem 0.25rem;
                white-space: nowrap;
            }
            
            /* Mobile quick actions */
            .quick-action-card {
                padding: 1.5rem 1rem;
                margin-bottom: 1rem;
            }
            
            .quick-action-icon {
                font-size: 2.5rem;
                margin-bottom: 0.75rem;
            }
            
            /* Mobile buttons */
            .btn {
                font-size: 0.875rem;
                padding: 0.5rem 1rem;
            }
            
            .btn-sm {
                font-size: 0.75rem;
                padding: 0.375rem 0.75rem;
            }
            
            /* Mobile cards */
            .card {
                margin-bottom: 1rem;
            }
            
            .card-header {
                padding: 1rem;
                font-size: 0.9rem;
            }
            
            .card-body {
                padding: 1rem;
            }
            
            /* Mobile forms */
            .form-control {
                font-size: 16px; /* Prevents zoom on iOS */
            }
            
            .form-label {
                font-size: 0.875rem;
                font-weight: 600;
            }
            
            /* Mobile dropdown */
            .dropdown-menu {
                font-size: 0.875rem;
                min-width: 200px;
            }
            
            /* Mobile pagination */
            .pagination {
                justify-content: center;
                flex-wrap: wrap;
            }
            
            .pagination .page-link {
                padding: 0.25rem 0.5rem;
                font-size: 0.75rem;
                margin: 0.125rem;
            }
            
            /* Mobile alerts */
            .alert {
                font-size: 0.875rem;
                padding: 0.75rem 1rem;
            }
            
            /* Mobile badges */
            .badge {
                font-size: 0.75rem;
                padding: 0.25rem 0.5rem;
            }
            
            /* Mobile chart container */
            .chart-container {
                height: 250px;
            }
            
            /* Mobile footer */
            footer .col-md-6 {
                text-align: center !important;
                margin-bottom: 0.5rem;
            }
            
            footer .col-md-6:last-child {
                margin-bottom: 0;
            }
            
        /* Mobile container padding */
        .container-fluid {
            padding-left: 0.75rem;
            padding-right: 0.75rem;
        }
        
        /* Modal fixes for z-index conflicts */
        .modal {
            z-index: 1055 !important;
        }
        
        .modal-backdrop {
            z-index: 1050 !important;
        }
        
        .modal-dialog {
            z-index: 1056 !important;
        }
        
        .modal-content {
            z-index: 1057 !important;
        }
        
        .modal-content * {
            z-index: 1058 !important;
            position: relative;
        }
        
        .form-select:focus {
            z-index: 9999 !important;
        }
        
        /* Ensure modal is clickable */
        .modal.show {
            display: block !important;
        }
        
        .modal.show .modal-dialog {
            pointer-events: auto !important;
        }
        
        .modal.show .modal-content {
            pointer-events: auto !important;
        }
        
        .modal.show .modal-content * {
            pointer-events: auto !important;
        }
            
            /* Mobile text sizes */
            h1 { font-size: 1.5rem; }
            h2 { font-size: 1.25rem; }
            h3 { font-size: 1.1rem; }
            h4 { font-size: 1rem; }
            h5 { font-size: 0.9rem; }
            h6 { font-size: 0.85rem; }
            
            /* Mobile spacing */
            .mb-4 { margin-bottom: 1.5rem !important; }
            .mb-3 { margin-bottom: 1rem !important; }
            .py-4 { padding-top: 1.5rem !important; padding-bottom: 1.5rem !important; }
            .py-3 { padding-top: 1rem !important; padding-bottom: 1rem !important; }
        }
        
        /* Extra small devices (phones, 576px and down) */
        @media (max-width: 576px) {
            .stats-number {
                font-size: 1.75rem;
            }
            
            .stats-icon {
                font-size: 2rem;
            }
            
            .quick-action-card {
                padding: 1rem 0.75rem;
            }
            
            .quick-action-icon {
                font-size: 2rem;
            }
            
            .table th,
            .table td {
                padding: 0.375rem 0.125rem;
                font-size: 0.75rem;
            }
            
            .btn {
                font-size: 0.8rem;
                padding: 0.4rem 0.8rem;
            }
            
            .card-header {
                padding: 0.75rem;
                font-size: 0.85rem;
            }
            
            .card-body {
                padding: 0.75rem;
            }
            
            .chart-container {
                height: 200px;
            }
        }
        
        /* Landscape mobile */
        @media (max-width: 768px) and (orientation: landscape) {
            .sidebar {
                width: 250px;
            }
            
            .chart-container {
                height: 200px;
            }
            
            .stats-card {
                padding: 0.75rem;
            }
        }
    </style>
</head>
<body>
    <!-- Mobile Sidebar Overlay -->
    <div class="sidebar-overlay"></div>
    
    <div class="container-fluid">
        <div class="row">
            <!-- Sidebar -->
            <div class="col-md-3 col-lg-2 px-0">
                <div class="sidebar">
                    <div class="sidebar-brand text-center">
                        <h4 class="text-white mb-0">
                         <!--   <i class="fas fa-users me-2"></i> -->
                           Sistem Informasi Anggota
                        </h4>
                        <small class="text-white-50">Partai Keadilan Sejahtera</small>
                        <small class="text-white-50">Jakarta Timur</small>
                    </div>
                    
                    <nav class="nav flex-column px-3">
                        <a href="{{ route('dashboard') }}" class="nav-link {{ request()->routeIs('dashboard') ? 'active' : '' }}">
                            <i class="fas fa-tachometer-alt me-2"></i> Dashboard
                        </a>
                        
                        <div class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle {{ request()->routeIs('anggota.index') || request()->routeIs('anggota.aktif') || request()->routeIs('anggota.non-aktif') || request()->routeIs('anggota.create') || request()->routeIs('anggota.show') || request()->routeIs('anggota.edit') || request()->routeIs('anggota.keanggotaan.*') ? 'active' : '' }}" href="#" id="anggotaDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                                <i class="fas fa-users me-2"></i> Data Anggota
                            </a>
                            <ul class="dropdown-menu" aria-labelledby="anggotaDropdown">
                                <li>
                                    <a class="dropdown-item {{ request()->routeIs('anggota.index') ? 'active' : '' }}" href="{{ route('anggota.index') }}">
                                        <i class="fas fa-list me-2"></i> Semua Anggota
                                    </a>
                                </li>
                                <li>
                                    <a class="dropdown-item {{ request()->routeIs('anggota.aktif') ? 'active' : '' }}" href="{{ route('anggota.aktif') }}">
                                        <i class="fas fa-check-circle me-2"></i> Aktif
                                    </a>
                                </li>
                                <li>
                                    <a class="dropdown-item {{ request()->routeIs('anggota.non-aktif') ? 'active' : '' }}" href="{{ route('anggota.non-aktif') }}">
                                        <i class="fas fa-times-circle me-2"></i> Non Aktif
                                    </a>
                                </li>
                            </ul>
                        </div>
                        
                        <a href="{{ route('kegiatan.index') }}" class="nav-link {{ request()->routeIs('kegiatan.*') ? 'active' : '' }}">
                            <i class="fas fa-calendar-alt me-2"></i> Kegiatan
                        </a>

                        <a href="{{ route('takwim.index') }}" class="nav-link {{ request()->routeIs('takwim.*') ? 'active' : '' }}">
                            <i class="fas fa-project-diagram me-2"></i> Program Takwim
                        </a>
                        
                        <a href="{{ route('penilaian-peserta.index') }}" class="nav-link {{ request()->routeIs('penilaian-peserta.*') ? 'active' : '' }}">
                            <i class="fas fa-clipboard-check me-2"></i> Penilaian Peserta Takwim
                        </a>
                        
                        <a href="{{ route('mutasi.index') }}" class="nav-link {{ request()->routeIs('mutasi.*') ? 'active' : '' }}">
                            <i class="fas fa-exchange-alt me-2"></i> Mutasi Anggota
                        </a>
                        
                        <a href="{{ route('surat-penempatan.index') }}" class="nav-link {{ request()->routeIs('surat-penempatan.*') ? 'active' : '' }}">
                            <i class="fas fa-file-alt me-2"></i> Penempatan Anggota
                        </a>
                          <!-- Menu tersembunyi sementara - bisa diaktifkan kembali di masa mendatang -->
                        <!--
                        <a href="{{ route('perpindahan.index') }}" class="nav-link {{ request()->routeIs('perpindahan.*') ? 'active' : '' }}">
                            <i class="fas fa-arrows-alt me-2"></i> Perpindahan Anggota
                        </a>
                        
                      
                        <a href="{{ route('rekomposisi-upa.index') }}" class="nav-link {{ request()->routeIs('rekomposisi-upa.*') ? 'active' : '' }}">
                            <i class="fas fa-users-cog me-2"></i> Rekomposisi UPA
                        </a>
                        
                        <a href="{{ route('perpindahan-anggota.index') }}" class="nav-link {{ request()->routeIs('perpindahan-anggota.*') ? 'active' : '' }}">
                            <i class="fas fa-sync-alt me-2"></i> Perpindahan Anggota <span class="badge bg-success ms-1">UNIFIED</span>
                        </a>
                        -->
                        
                        <a href="{{ route('upa.index') }}" class="nav-link {{ request()->routeIs('upa.*') ? 'active' : '' }}">
                            <i class="fas fa-building me-2"></i> UPA
                        </a>
                        
                        <a href="{{ route('upa-group-activity.index') }}" class="nav-link {{ request()->routeIs('upa-group-activity.*') ? 'active' : '' }}">
                            <i class="fas fa-users me-2"></i> Aktivitas UPA
                        </a>
                        
                        <a href="{{ route('komposisi.index') }}" class="nav-link {{ request()->routeIs('komposisi.*') ? 'active' : '' }}">
                            <i class="fas fa-sitemap me-2"></i> Komposisi DPC & UPA
                        </a>
                        
                        <a href="{{ route('yaumiyah.index') }}" class="nav-link {{ request()->routeIs('yaumiyah.*') ? 'active' : '' }}">
                            <i class="fas fa-calendar-check me-2"></i> Yaumiyah
                        </a>
                        
                        <a href="{{ route('statistik.index') }}" class="nav-link {{ request()->routeIs('statistik.*') ? 'active' : '' }}">
                            <i class="fas fa-chart-pie me-2"></i> Statistik
                        </a>
                        
                        <hr class="text-white-50 my-3">
                        
                        <!-- Master Data Section -->
                        <div class="nav-section-title">
                            <span class="text-muted small fw-bold">MASTER</span>
                        </div>
                        
                        <!-- Master Data Dropdown -->
                        <div class="nav-item dropdown">
                            <a class="nav-link dropdown-toggle {{ request()->routeIs('dpc.*') || request()->routeIs('upa-agenda-master.*') || request()->routeIs('jenis-kegiatan.*') || request()->routeIs('keahlian.*') || request()->is('indikator-takwim*') || request()->routeIs('aktivitas-luar.*') ? 'active' : '' }}" 
                               href="#" id="masterDropdown" role="button" data-bs-toggle="dropdown" data-bs-auto-close="true" aria-expanded="false">
                                <i class="fas fa-database me-2"></i> Master Data
                            </a>
                            <ul class="dropdown-menu" aria-labelledby="masterDropdown">
                                <li>
                                    <a class="dropdown-item {{ request()->routeIs('dpc.*') ? 'active' : '' }}" href="{{ route('dpc.index') }}">
                                        <i class="fas fa-sitemap me-2"></i> DPC
                                    </a>
                                </li>
                                <li>
                                    <a class="dropdown-item {{ request()->routeIs('upa-agenda-master.*') ? 'active' : '' }}" href="{{ route('upa-agenda-master.index') }}">
                                        <i class="fas fa-list me-2"></i> Master Agenda UPA
                                    </a>
                                </li>
                                <li>
                                    <a class="dropdown-item {{ request()->routeIs('jenis-kegiatan.*') ? 'active' : '' }}" href="{{ route('jenis-kegiatan.index') }}">
                                        <i class="fas fa-tasks me-2"></i> Jenis Kegiatan
                                    </a>
                                </li>
                                <li>
                                    <a class="dropdown-item {{ request()->routeIs('keahlian.*') ? 'active' : '' }}" href="{{ route('keahlian.index') }}">
                                        <i class="fas fa-cogs me-2"></i> Keahlian
                                    </a>
                                </li>
                                <li>
                                    <a class="dropdown-item {{ request()->is('indikator-takwim*') ? 'active' : '' }}" href="{{ route('indikator-takwim.index') }}">
                                        <i class="fas fa-clipboard-list me-2"></i> Indikator Takwim
                                    </a>
                                </li>
                                <li>
                                    <a class="dropdown-item {{ request()->routeIs('aktivitas-luar.*') ? 'active' : '' }}" href="{{ route('aktivitas-luar.index') }}">
                                        <i class="fas fa-running me-2"></i> Aktivitas Luar
                                    </a>
                                </li>
                            </ul>
                        </div>
                        
                        @if(auth()->check() && auth()->user()->role === 'superadmin')
                        <a href="{{ route('user-management.index') }}" class="nav-link {{ request()->routeIs('user-management.*') ? 'active' : '' }}">
                            <i class="fas fa-users-cog me-2"></i> Management User
                        </a>
                        @endif
                    </nav>
                </div>
            </div>
            
            <!-- Main Content -->
            <div class="col-md-9 col-lg-10 px-0">
                <div class="main-content">
                    <!-- Top Navigation -->
                    <nav class="navbar navbar-expand-lg navbar-light bg-white border-bottom">
                        <div class="container-fluid">
                            <button class="navbar-toggler d-md-none" type="button" id="sidebarToggle">
                                <span class="navbar-toggler-icon"></span>
                            </button>
                            
                            <div class="ms-auto">
                                <div class="dropdown">
                                    <button class="btn btn-link text-decoration-none dropdown-toggle d-flex align-items-center" type="button" id="userDropdown" data-bs-toggle="dropdown" aria-expanded="false" style="border: none; background: none; color: #6c757d; padding: 8px 12px; border-radius: 8px; transition: all 0.3s ease;">
                                        <i class="fas fa-user-circle me-2" style="font-size: 1.2em;"></i>
                                        <span style="font-weight: 500;">{{ Auth::user()->name ?? 'Admin' }}</span>
                                        <i class="fas fa-chevron-down ms-2" style="font-size: 0.8em;"></i>
                                    </button>
                                    <ul class="dropdown-menu dropdown-menu-end shadow-lg border-0" aria-labelledby="userDropdown" style="min-width: 200px; border-radius: 12px; padding: 8px 0; margin-top: 8px; position: absolute; top: 100%; right: 0; z-index: 1050;">
                                        <li>
                                            <a class="dropdown-item d-flex align-items-center py-2 px-3" href="#" style="transition: all 0.2s ease;">
                                                <i class="fas fa-user me-3 text-muted"></i>
                                                <span>Profile</span>
                                            </a>
                                        </li>
                                        <li>
                                            <a class="dropdown-item d-flex align-items-center py-2 px-3" href="#" data-bs-toggle="modal" data-bs-target="#changePasswordModal" style="transition: all 0.2s ease;">
                                                <i class="fas fa-key me-3 text-muted"></i>
                                                <span>Ubah Password</span>
                                            </a>
                                        </li>
                                        <li><hr class="dropdown-divider my-2"></li>
                                        <li>
                                            <form method="POST" action="{{ route('logout') }}" class="d-inline w-100">
                                                @csrf
                                                <button type="submit" class="dropdown-item d-flex align-items-center py-2 px-3 text-danger w-100 border-0 bg-transparent" style="transition: all 0.2s ease;">
                                                    <i class="fas fa-sign-out-alt me-3"></i>
                                                    <span>Logout</span>
                                                </button>
                                            </form>
                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </nav>
                    
                    <!-- Page Content -->
                    <div class="container-fluid p-4">
                        @if(session('success'))
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                <i class="fas fa-check-circle me-2"></i>{{ session('success') }}
                                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                            </div>
                        @endif
                        
                        @if(session('error'))
                            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                                <i class="fas fa-exclamation-circle me-2"></i>{{ session('error') }}
                                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                            </div>
                        @endif
                        
                        @yield('content')
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Bootstrap JS -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <!-- DataTables JS -->
    <script src="https://cdn.datatables.net/1.13.4/js/jquery.dataTables.min.js"></script>
    <script src="https://cdn.datatables.net/1.13.4/js/dataTables.bootstrap5.min.js"></script>
    <!-- Select2 JS -->
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <!-- SweetAlert2 JS -->
    <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    <!-- Chart.js -->
    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
    <!-- Mobile Enhancements -->
    <script src="{{ asset('js/mobile-enhancements.js') }}"></script>
    
    <script>
        // Auto-hide alerts after 5 seconds
        setTimeout(function() {
            $('.alert').fadeOut('slow');
        }, 5000);
        
        // Initialize DataTables with Indonesian language
        $.extend(true, $.fn.dataTable.defaults, {
            language: {
                url: 'https://cdn.datatables.net/plug-ins/1.13.4/i18n/id.json'
            },
            responsive: true,
            pageLength: 25,
            lengthMenu: [[10, 25, 50, 100, -1], [10, 25, 50, 100, "Semua"]]
        });
        
        // Initialize Select2
        $(document).ready(function() {
            $('.select2').select2({
                theme: 'bootstrap-5',
                placeholder: function() {
                    return $(this).data('placeholder') || 'Pilih...';
                },
                allowClear: true,
                width: '100%'
            });
        });
        
        // CSRF Token setup for AJAX
        $.ajaxSetup({
            headers: {
                'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            }
        });
        
        // Chart.js default colors (PKS Orange Dusty theme)
        Chart.defaults.color = '#757575';
        Chart.defaults.borderColor = '#FDEBD0';
        Chart.defaults.backgroundColor = 'rgba(240, 131, 58, 0.1)';
        
        // Initialize dropdowns
        $(document).ready(function() {
            // Fix sidebar dropdown positioning
            $('.sidebar .nav-item.dropdown').each(function() {
                $(this).on('show.bs.dropdown', function() {
                    var dropdownMenu = $(this).find('.dropdown-menu');
                    dropdownMenu.css({
                        'margin-top': '0',
                        'top': '100%',
                        'left': '0',
                        'right': 'auto',
                        'transform': 'translateY(0)',
                        'position': 'absolute'
                    });
                });
            });
            
            // Initialize user dropdown specifically
            $('#userDropdown').dropdown({
                display: 'static',
                boundary: 'viewport',
                popperConfig: {
                    placement: 'bottom-end',
                    modifiers: [
                        {
                            name: 'preventOverflow',
                            options: {
                                boundary: 'viewport'
                            }
                        },
                        {
                            name: 'flip',
                            options: {
                                fallbackPlacements: ['top-end', 'bottom-start', 'top-start']
                            }
                        }
                    ]
                }
            });
            
            // Add smooth hover effects
            $('.dropdown-item').hover(
                function() {
                    $(this).addClass('show');
                },
                function() {
                    $(this).removeClass('show');
                }
            );
            
        // Handle dropdown show/hide events
        $('#userDropdown').on('show.bs.dropdown', function() {
            $(this).addClass('show');
            var dropdownMenu = $(this).next('.dropdown-menu');
            dropdownMenu.addClass('show');
        });
        
        $('#userDropdown').on('hide.bs.dropdown', function() {
            $(this).removeClass('show');
            var dropdownMenu = $(this).next('.dropdown-menu');
            dropdownMenu.removeClass('show');
        });
        
        // Bootstrap dropdown will handle Master Data dropdown automatically
            
            // Password confirmation validation
            $('#new_password_confirmation').on('keyup', function() {
                var password = $('#new_password').val();
                var confirmPassword = $(this).val();
                
                if (password !== confirmPassword) {
                    this.setCustomValidity('Password tidak sesuai');
                } else {
                    this.setCustomValidity('');
                }
            });
            
            // Clear modal when closed
            $('#changePasswordModal').on('hidden.bs.modal', function() {
                $(this).find('form')[0].reset();
                $(this).find('.is-invalid').removeClass('is-invalid');
                $(this).find('.invalid-feedback').remove();
            });
            
        // Mobile sidebar toggle - Simple version
        $(document).on('click', '#sidebarToggle', function(e) {
            e.preventDefault();
            e.stopPropagation();
            console.log('Sidebar toggle clicked'); // Debug log
            $('.sidebar').toggleClass('show');
            $('.sidebar-overlay').toggleClass('show');
            $('body').toggleClass('sidebar-open');
        });
        
        // Close sidebar when clicking overlay
        $('.sidebar-overlay').on('click', function(e) {
            e.preventDefault();
            e.stopPropagation();
            $('.sidebar').removeClass('show');
            $('.sidebar-overlay').removeClass('show');
            $('body').removeClass('sidebar-open');
        });
        
        // Add click outside to close dropdown and sidebar
        $(document).on('click', function(e) {
            // Close dropdowns
            if (!$(e.target).closest('.dropdown').length) {
                $('.dropdown').removeClass('show');
                $('.dropdown-menu').removeClass('show');
                $('.dropdown-toggle').removeClass('show');
            }
            
            // Close sidebar on mobile
            if ($(window).width() <= 768) {
                if (!$(e.target).closest('.sidebar, #sidebarToggle').length) {
                    $('.sidebar').removeClass('show');
                    $('.sidebar-overlay').removeClass('show');
                    $('body').removeClass('sidebar-open');
                }
            }
        });
        
        // Handle window resize
        $(window).on('resize', function() {
            if ($(window).width() > 768) {
                $('.sidebar').removeClass('show');
                $('.sidebar-overlay').removeClass('show');
                $('body').removeClass('sidebar-open');
            }
        });
    });
    </script>
    
    @stack('scripts')
    
    <!-- Change Password Modal -->
    <div class="modal fade" id="changePasswordModal" tabindex="-1" aria-labelledby="changePasswordModalLabel" aria-hidden="true">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="changePasswordModalLabel">
                        <i class="fas fa-key me-2"></i>Ubah Password
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <form method="POST" action="{{ route('change-password') }}">
                    @csrf
                    <div class="modal-body">
                        <div class="mb-3">
                            <label for="current_password" class="form-label">Password Lama <span class="text-danger">*</span></label>
                            <input type="password" class="form-control @error('current_password') is-invalid @enderror" 
                                   id="current_password" name="current_password" required>
                            @error('current_password')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <div class="mb-3">
                            <label for="new_password" class="form-label">Password Baru <span class="text-danger">*</span></label>
                            <input type="password" class="form-control @error('new_password') is-invalid @enderror" 
                                   id="new_password" name="new_password" required minlength="8">
                            <div class="form-text">
                                <small class="text-muted">
                                    Password harus minimal 8 karakter dan mengandung huruf besar, huruf kecil, angka, dan simbol khusus.
                                </small>
                            </div>
                            @error('new_password')
                                <div class="invalid-feedback">{{ $message }}</div>
                            @enderror
                        </div>
                        
                        <div class="mb-3">
                            <label for="new_password_confirmation" class="form-label">Konfirmasi Password Baru <span class="text-danger">*</span></label>
                            <input type="password" class="form-control" 
                                   id="new_password_confirmation" name="new_password_confirmation" required minlength="8">
                        </div>
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save me-2"></i>Simpan Password
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <!-- Footer -->
    <footer class="bg-gradient-primary text-white py-4 mt-5">
        <div class="container-fluid">
            <div class="row align-items-center">
                <div class="col-md-6">
                    <div class="d-flex align-items-center">
                        <i class="fas fa-heart text-warning me-2"></i>
                        <span class="fw-bold">BKAP DPD PKS Jakarta Timur</span>
                    </div>
                </div>
                <div class="col-md-6 text-md-end">
                    <small class="text-white-50">
                        <i class="fas fa-copyright me-1"></i>
                        Copyright @2025 - Sistem Informasi Anggota PKS
                    </small>
                    <br>
                    <small class="text-white-50" id="loading-time">
                        <i class="fas fa-clock me-1"></i>
                        Loading: <span id="load-time">0.00</span> detik
                    </small>
                </div>
            </div>
        </div>
    </footer>
    
    <!-- Loading Time Calculator -->
    <script>
    (function() {
        // Mulai hitung waktu dari saat script ini dijalankan
        const startTime = performance.now();
        let isLoaded = false;
        
        function updateLoadingTime() {
            if (isLoaded) return;
            isLoaded = true;
            
            const endTime = performance.now();
            const loadTime = ((endTime - startTime) / 1000).toFixed(2);
            
            // Update display
            const loadTimeElement = document.getElementById('load-time');
            if (loadTimeElement) {
                loadTimeElement.textContent = loadTime;
                
                // Tambahkan warna berdasarkan performa
                const loadingTimeElement = document.getElementById('loading-time');
                if (loadingTimeElement) {
                    if (loadTime < 1.0) {
                        loadingTimeElement.classList.add('text-success');
                    } else if (loadTime < 2.0) {
                        loadingTimeElement.classList.add('text-warning');
                    } else {
                        loadingTimeElement.classList.add('text-danger');
                    }
                }
            }
        }
        
        // Tunggu semua resource selesai dimuat
        if (document.readyState === 'complete') {
            updateLoadingTime();
        } else {
            window.addEventListener('load', updateLoadingTime);
        }
        
        // Fallback jika window.load tidak trigger (setelah 10 detik)
        setTimeout(function() {
            if (!isLoaded) {
                updateLoadingTime();
            }
        }, 10000);
    })();
    </script>
    
    <!-- Debug Script untuk Mobile Sidebar -->
    <script>
    $(document).ready(function() {
        console.log('Document ready - Mobile sidebar script loaded');
        
        // Debug: Check if elements exist
        console.log('Sidebar element:', $('.sidebar').length);
        console.log('Overlay element:', $('.sidebar-overlay').length);
        console.log('Toggle button:', $('#sidebarToggle').length);
        
        // Simple toggle function
        function toggleSidebar() {
            console.log('Toggle sidebar function called');
            $('.sidebar').toggleClass('show');
            $('.sidebar-overlay').toggleClass('show');
            $('body').toggleClass('sidebar-open');
        }
        
        // Bind click event
        $('#sidebarToggle').click(function(e) {
            e.preventDefault();
            console.log('Button clicked!');
            toggleSidebar();
        });
        
        // Close on overlay click
        $('.sidebar-overlay').click(function(e) {
            e.preventDefault();
            console.log('Overlay clicked - closing sidebar');
            $('.sidebar').removeClass('show');
            $('.sidebar-overlay').removeClass('show');
            $('body').removeClass('sidebar-open');
        });
        
        // Close on window resize
        $(window).resize(function() {
            if ($(window).width() > 768) {
                $('.sidebar').removeClass('show');
                $('.sidebar-overlay').removeClass('show');
                $('body').removeClass('sidebar-open');
            }
        });
    });
    </script>
</body>
</html>