<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Komposisi Semua DPC dan UPA</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 11px;
            line-height: 1.3;
            margin: 0;
            padding: 15px;
            background: white;
        }
        
        .header {
            text-align: center;
            margin-bottom: 20px;
            border-bottom: 2px solid #333;
            padding-bottom: 15px;
        }
        
        .header h1 {
            margin: 0;
            font-size: 18px;
            color: #333;
            font-weight: bold;
        }
        
        .header h2 {
            margin: 5px 0 0 0;
            font-size: 14px;
            color: #666;
        }
        
        .print-date {
            text-align: right;
            margin-bottom: 15px;
            color: #666;
            font-size: 10px;
        }
        
        .composition-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 10px;
        }
        
        .composition-table th {
            background-color: #FFD700;
            color: #000;
            font-weight: bold;
            padding: 8px 5px;
            text-align: center;
            border: 1px solid #000;
            font-size: 10px;
        }
        
        .composition-table td {
            padding: 6px 5px;
            border: 1px solid #000;
            vertical-align: top;
            font-size: 10px;
        }
        
        .upa-header-row {
            background-color: #FFD700;
            font-weight: bold;
        }
        
        .member-row {
            background-color: white;
        }
        
        .member-row:nth-child(even) {
            background-color: #f9f9f9;
        }
        
        .dpr-text {
            color: red;
            font-weight: bold;
        }
        
        .kode-upa {
            font-weight: bold;
            text-align: center;
        }
        
        .pembimbing-baru {
            font-weight: bold;
        }
        
        .pembimbing-lama {
            font-style: italic;
        }
        
        .ket-text {
            font-size: 9px;
        }
        
        .no-col {
            width: 30px;
            text-align: center;
        }
        
        .kode-upa-col {
            width: 80px;
            text-align: center;
        }
        
        .pembimbing-col {
            width: 120px;
        }
        
        .nama-anggota-col {
            width: 200px;
        }
        
        .telp-col {
            width: 80px;
        }
        
        .dpr-col {
            width: 100px;
        }
        
        
        .dpc-section {
            margin-bottom: 30px;
            page-break-before: auto;
        }
        
        .dpc-title {
            background-color: #007bff;
            color: white;
            padding: 10px;
            font-weight: bold;
            font-size: 14px;
            margin-bottom: 10px;
            text-align: center;
        }
        
        @media print {
            body {
                margin: 0;
                padding: 10px;
            }
            
            .no-print {
                display: none;
            }
        }
    </style>
</head>
<body>
    <div class="print-date">
        Tanggal : {{ now()->format('d F Y') }}
    </div>

    <div class="header">
        <h1>KOMPOSISI SEMUA DPC DAN UPA</h1>
        <h2>Laporan Komposisi Organisasi</h2>
        @if(request()->hasAny(['dpd_id', 'jenjang_id']))
            <p style="font-size: 12px; color: #666; margin-top: 10px;">
                <strong>Filter Aktif:</strong>
                @if(request('dpd_id'))
                    DPD: {{ $dpdList->where('dpd_id', request('dpd_id'))->first()->nama_dpd ?? 'N/A' }}
                @endif
                @if(request('jenjang_id'))
                    | Jenjang: {{ $jenjangList->where('ref_jenjang_id', request('jenjang_id'))->first()->jenjang ?? 'N/A' }}
                @endif
            </p>
        @endif
    </div>

    @foreach($dpcList as $dpc)
    <div class="dpc-section">
        <div class="dpc-title">
            DPC: {{ $dpc->nama_dpc }} ({{ $dpc->kode_dpc }}) - {{ $dpc->dpd->nama_dpd ?? 'N/A' }}
        </div>
        
        <table class="composition-table">
            <thead>
            <tr>
                <th class="no-col">No</th>
                <th class="kode-upa-col">KODE UPA</th>
                <th class="pembimbing-col">Pembimbing Baru</th>
                <th class="no-col">No</th>
                <th class="nama-anggota-col">Nama Anggota</th>
                <th class="telp-col">Telp</th>
                <th class="dpr-col">DPC</th>
            </tr>
            </thead>
            <tbody>
                @if($dpc->upa->count() > 0)
                    @php $rowNumber = 1; @endphp
                    @foreach($dpc->upa as $upa)
                        @if($upa->anggotaAktif->count() > 0)
                            <tr class="upa-header-row">
                                <td class="no-col">{{ $rowNumber }}</td>
                                <td class="kode-upa">{{ $upa->kode_upa }}</td>
                                <td class="pembimbing-baru">
                                    @if($upa->pembimbingAktif->count() > 0)
                                        {{ $upa->pembimbingAktif->first()->nama_lengkap }}
                                    @else
                                        -
                                    @endif
                                </td>
                                <td class="no-col">-</td>
                                <td class="nama-anggota-col">-</td>
                                <td class="telp-col">-</td>
                                <td class="dpr-col">-</td>
                            </tr>
                            
                            @foreach($upa->anggotaAktif as $index => $anggota)
                            <tr class="member-row">
                                <td class="no-col"></td>
                                <td class="kode-upa"></td>
                                <td class="pembimbing-baru"></td>
                                <td class="no-col">{{ $index + 1 }}</td>
                                <td class="nama-anggota-col">{{ $anggota->nama_lengkap }}</td>
                                <td class="telp-col">{{ $anggota->no_telepon ?? '-' }}</td>
                                <td class="dpr-col dpr-text">{{ $dpc->nama_dpc }}</td>
                            </tr>
                            @endforeach
                            
                            @php $rowNumber++; @endphp
                        @endif
                    @endforeach
                @else
                    <tr>
                        <td colspan="7" style="text-align: center; padding: 20px;">
                            <em>Belum ada UPA yang terdaftar di DPC ini.</em>
                        </td>
                    </tr>
                @endif
            </tbody>
        </table>
    </div>
    @endforeach

    <script>
        window.onload = function() {
            window.print();
        }
    </script>
</body>
</html>
