@extends('layouts.app')

@section('title', 'Komposisi DPC dan UPA')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-sitemap mr-2"></i>
                        Komposisi DPC dan UPA
                    </h3>
                    <div class="card-tools">
                        <a href="{{ route('komposisi.print-all') }}" class="btn btn-success btn-sm" target="_blank">
                            <i class="fas fa-print mr-1"></i>
                            Print Semua
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <!-- Filter Section -->
                    <div class="row mb-4">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">
                                        <i class="fas fa-filter mr-2"></i>
                                        Filter Komposisi
                                    </h5>
                                </div>
                                <div class="card-body">
                                    <form method="GET" action="{{ route('komposisi.index') }}" id="filterForm">
                                        <div class="row">
                                            <div class="col-md-2">
                                                <div class="form-group">
                                                    <label for="dpd_id">DPD</label>
                                                    <select name="dpd_id" id="dpd_id" class="form-control">
                                                        <option value="">Semua DPD</option>
                                                        @foreach($dpdList as $dpd)
                                                            <option value="{{ $dpd->dpd_id }}" 
                                                                {{ request('dpd_id') == $dpd->dpd_id ? 'selected' : '' }}>
                                                                {{ $dpd->nama_dpd }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-2">
                                                <div class="form-group">
                                                    <label for="dpc_id">DPC</label>
                                                    <select name="dpc_id" id="dpc_id" class="form-control">
                                                        <option value="">Semua DPC</option>
                                                        @foreach($allDpcList as $dpc)
                                                            <option value="{{ $dpc->dpc_id }}" 
                                                                {{ request('dpc_id') == $dpc->dpc_id ? 'selected' : '' }}>
                                                                {{ $dpc->nama_dpc }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-2">
                                                <div class="form-group">
                                                    <label for="upa_id">UPA</label>
                                                    <select name="upa_id" id="upa_id" class="form-control">
                                                        <option value="">Semua UPA</option>
                                                        @foreach($allUpaList as $upa)
                                                            <option value="{{ $upa->upa_id }}" 
                                                                {{ request('upa_id') == $upa->upa_id ? 'selected' : '' }}>
                                                                {{ $upa->nama_upa }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-2">
                                                <div class="form-group">
                                                    <label for="status_dpc">Status DPC</label>
                                                    <select name="status_dpc" id="status_dpc" class="form-control">
                                                        <option value="">Semua Status</option>
                                                        @foreach($statusDpcOptions as $value => $label)
                                                            <option value="{{ $value }}" 
                                                                {{ request('status_dpc') == $value ? 'selected' : '' }}>
                                                                {{ $label }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                            <div class="col-md-2">
                                                <div class="form-group">
                                                    <label for="jenjang_id">Jenjang Anggota</label>
                                                    <select name="jenjang_id" id="jenjang_id" class="form-control">
                                                        <option value="">Semua Jenjang</option>
                                                        @foreach($jenjangList as $jenjang)
                                                            <option value="{{ $jenjang->ref_jenjang_id }}" 
                                                                {{ request('jenjang_id') == $jenjang->ref_jenjang_id ? 'selected' : '' }}>
                                                                {{ $jenjang->jenjang }}
                                                            </option>
                                                        @endforeach
                                                    </select>
                                                </div>
                                            </div>
                                        </div>
                                        <!-- Min. Jumlah Anggota filter removed -->
                                        <div class="row">
                                            <div class="col-12">
                                                <button type="submit" class="btn btn-primary mt-2">
                                                    <i class="fas fa-search mr-1"></i>
                                                    Terapkan Filter
                                                </button>
                                                <a href="{{ route('komposisi.index') }}" class="btn btn-secondary mt-2">
                                                    <i class="fas fa-times mr-1"></i>
                                                    Reset Filter
                                                </a>
                                                @if(request()->hasAny(['dpd_id', 'dpc_id', 'upa_id', 'status_dpc', 'jenjang_id']))
                                                    <a href="{{ route('komposisi.print-all', request()->query()) }}" class="btn btn-success mr-2 mt-2" target="_blank">
                                                        <i class="fas fa-print mr-1"></i>
                                                        Print Hasil Filter
                                                    </a>
                                                    <a href="{{ route('komposisi.print-sk', request()->query()) }}" class="btn btn-primary mt-2" target="_blank">
                                                        <i class="fas fa-file-alt mr-1"></i>
                                                        Print Format SK
                                                    </a>
                                                @else
                                                    <a href="{{ route('komposisi.print-all') }}" class="btn btn-success mr-2 mt-2" target="_blank">
                                                        <i class="fas fa-print mr-1"></i>
                                                        Print Semua
                                                    </a>
                                                    <a href="{{ route('komposisi.print-sk') }}" class="btn btn-primary mt-2" target="_blank">
                                                        <i class="fas fa-file-alt mr-1"></i>
                                                        Print Format SK
                                                    </a>
                                                @endif
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Filter Active Info -->
                    @if(request()->hasAny(['dpd_id', 'dpc_id', 'upa_id', 'status_dpc', 'jenjang_id']))
                    <div class="row mb-3">
                        <div class="col-12">
                            <div class="alert alert-info">
                                <i class="fas fa-info-circle mr-2"></i>
                                <strong>Filter Aktif:</strong>
                                @if(request('dpd_id'))
                                    DPD: {{ $dpdList->where('dpd_id', request('dpd_id'))->first()->nama_dpd ?? 'N/A' }}
                                @endif
                                @if(request('dpc_id'))
                                    | DPC: {{ $allDpcList->where('dpc_id', request('dpc_id'))->first()->nama_dpc ?? 'N/A' }}
                                @endif
                                @if(request('upa_id'))
                                    | UPA: {{ $allUpaList->where('upa_id', request('upa_id'))->first()->nama_upa ?? 'N/A' }}
                                @endif
                                @if(request('status_dpc'))
                                    | Status DPC: {{ $statusDpcOptions[request('status_dpc')] ?? 'N/A' }}
                                @endif
                                @if(request('jenjang_id'))
                                    | Jenjang: {{ $jenjangList->where('ref_jenjang_id', request('jenjang_id'))->first()->jenjang ?? 'N/A' }}
                                @endif
                                
                            </div>
                        </div>
                    </div>
                    @endif

                    <!-- Statistik Overview -->
                    <div class="stats-overview-grid mb-4">
                        <div class="stats-overview-item">
                            <div class="info-box">
                                <span class="info-box-icon bg-info">
                                    <i class="fas fa-building"></i>
                                </span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Total DPC</span>
                                    <span class="info-box-number">{{ $statistik['total_dpc'] }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="stats-overview-item">
                            <div class="info-box">
                                <span class="info-box-icon bg-success">
                                    <i class="fas fa-users"></i>
                                </span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Total UPA</span>
                                    <span class="info-box-number">{{ $statistik['total_upa'] }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="stats-overview-item">
                            <div class="info-box">
                                <span class="info-box-icon bg-warning">
                                    <i class="fas fa-user-friends"></i>
                                </span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Total Anggota</span>
                                    <span class="info-box-number">{{ $statistik['total_anggota'] }}</span>
                                </div>
                            </div>
                        </div>
                        <div class="stats-overview-item">
                            <div class="info-box">
                                <span class="info-box-icon bg-primary">
                                    <i class="fas fa-chart-pie"></i>
                                </span>
                                <div class="info-box-content">
                                    <span class="info-box-text">Rata-rata Anggota/DPC</span>
                                    <span class="info-box-number">{{ $statistik['total_dpc'] > 0 ? round($statistik['total_anggota'] / $statistik['total_dpc'], 1) : 0 }}</span>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Statistik per Jenjang -->
                    <div class="row mb-4">
                        <div class="col-12">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="card-title">Distribusi Anggota per Jenjang</h5>
                                </div>
                                <div class="card-body">
                                    <div class="statistik-jenjang-grid">
                                        @foreach($statistik['statistik_jenjang'] as $jenjang)
                                        <div class="statistik-jenjang-item">
                                            <div class="small-box bg-light">
                                                <div class="inner">
                                                    <h3>{{ $jenjang->total }}</h3>
                                                    <p>{{ $jenjang->jenjang }}</p>
                                                </div>
                                                <div class="icon">
                                                    <i class="fas fa-graduation-cap"></i>
                                                </div>
                                            </div>
                                        </div>
                                        @endforeach
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Daftar DPC -->
                    <div class="row">
                        @foreach($dpcList as $dpc)
                        <div class="col-lg-6 col-xl-4 mb-4">
                            <div class="card komposisi-card h-100 shadow-sm">
                                <!-- Header Card -->
                                <div class="card-header bg-gradient-warning text-white">
                                    <div class="d-flex align-items-center">
                                        <div class="card-icon me-3">
                                            <i class="fas fa-building fa-2x"></i>
                                        </div>
                                        <div class="flex-grow-1">
                                            <h4 class="card-title mb-1">{{ $dpc->nama_dpc }}</h4>
                                            <p class="card-subtitle mb-0 opacity-75">{{ $dpc->dpd->nama_dpd ?? 'N/A' }}</p>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Body Card -->
                                <div class="card-body">
                                    <div class="row text-center">
                                        <div class="col-6">
                                            <div class="stat-item">
                                                <div class="stat-number text-warning">{{ $dpc->upa->where('status', 'Aktif')->count() }}</div>
                                                <div class="stat-label">UPA Aktif</div>
                                            </div>
                                        </div>
                                        <div class="col-6">
                                            <div class="stat-item">
                                                <div class="stat-number text-info">{{ $dpc->anggota->where('status_keanggotaan', 'Aktif')->count() }}</div>
                                                <div class="stat-label">Total Anggota</div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Footer Card -->
                                <div class="card-footer bg-light">
                                    <div class="row g-2">
                                        <div class="col-6">
                                            @php
                                                $firstUpa = $dpc->upa->where('status', 'Aktif')->first();
                                            @endphp
                                            @if($firstUpa)
                                                <a href="{{ route('upa.show', $firstUpa->upa_id) }}" class="btn btn-warning btn-sm w-100">
                                                    <i class="fas fa-eye me-1"></i>
                                                    Detail UPA
                                                </a>
                                            @else
                                                <a href="{{ route('komposisi.show-dpc', $dpc->dpc_id) }}" class="btn btn-warning btn-sm w-100">
                                                    <i class="fas fa-eye me-1"></i>
                                                    Detail DPC
                                                </a>
                                            @endif
                                        </div>
                                        <div class="col-6">
                                            <a href="{{ route('komposisi.print-dpc', $dpc->dpc_id) }}" class="btn btn-success btn-sm w-100" target="_blank">
                                                <i class="fas fa-print me-1"></i>
                                                Print
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @endforeach
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    // Cascading filter functionality
    $('#dpd_id').change(function() {
        var dpdId = $(this).val();
        var dpcSelect = $('#dpc_id');
        var upaSelect = $('#upa_id');
        
        // Reset dependent selects
        upaSelect.html('<option value="">Semua UPA</option>');
        
        if (dpdId) {
            // Load DPC based on selected DPD
            $.get('{{ route("komposisi.get-dpc-by-dpd") }}', {dpd_id: dpdId}, function(data) {
                dpcSelect.html('<option value="">Semua DPC</option>');
                $.each(data, function(index, dpc) {
                    dpcSelect.append('<option value="' + dpc.dpc_id + '">' + dpc.nama_dpc + '</option>');
                });
            });
        } else {
            // Load all DPC
            $.get('{{ route("komposisi.get-dpc-by-dpd") }}', function(data) {
                dpcSelect.html('<option value="">Semua DPC</option>');
                $.each(data, function(index, dpc) {
                    dpcSelect.append('<option value="' + dpc.dpc_id + '">' + dpc.nama_dpc + '</option>');
                });
            });
        }
    });
    
    $('#dpc_id').change(function() {
        var dpcId = $(this).val();
        var upaSelect = $('#upa_id');
        
        if (dpcId) {
            // Load UPA based on selected DPC
            $.get('{{ route("komposisi.get-upa-by-dpc") }}', {dpc_id: dpcId}, function(data) {
                upaSelect.html('<option value="">Semua UPA</option>');
                $.each(data, function(index, upa) {
                    upaSelect.append('<option value="' + upa.upa_id + '">' + upa.nama_upa + '</option>');
                });
            });
        } else {
            // Load all UPA
            $.get('{{ route("komposisi.get-upa-by-dpc") }}', function(data) {
                upaSelect.html('<option value="">Semua UPA</option>');
                $.each(data, function(index, upa) {
                    upaSelect.append('<option value="' + upa.upa_id + '">' + upa.nama_upa + '</option>');
                });
            });
        }
    });
    
    // Auto-submit form when filter changes (except for cascading selects)
    $('#filterForm select').not('#dpd_id, #dpc_id').change(function() {
        $('#filterForm').submit();
    });
    
    // Manual submit for cascading selects
    $('#dpd_id, #dpc_id, #upa_id').change(function() {
        setTimeout(function() {
            $('#filterForm').submit();
        }, 500); // Small delay to allow cascading to complete
    });
    
    // Show loading state
    $('#filterForm').on('submit', function() {
        $('button[type="submit"]').prop('disabled', true).html('<i class="fas fa-spinner fa-spin mr-1"></i>Memproses...');
    });
});
</script>
@endpush

@push('styles')
<style>
/* Komposisi Card Styles */
.komposisi-card {
    border: none;
    border-radius: 12px;
    transition: all 0.3s ease;
    overflow: hidden;
}

.komposisi-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.15) !important;
}

.komposisi-card .card-header {
    border: none;
    border-radius: 12px 12px 0 0 !important;
    padding: 1.5rem;
    background: linear-gradient(135deg, #fd7e14 0%, #e8590c 100%);
}

.komposisi-card .card-icon {
    width: 60px;
    height: 60px;
    background: rgba(255,255,255,0.2);
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    backdrop-filter: blur(10px);
}

.komposisi-card .card-title {
    font-size: 1.25rem;
    font-weight: 600;
    margin: 0;
    color: white;
}

.komposisi-card .card-subtitle {
    font-size: 0.875rem;
    color: rgba(255,255,255,0.8);
}

.komposisi-card .card-body {
    padding: 1.5rem;
    background: white;
}

.komposisi-card .card-footer {
    border: none;
    border-radius: 0 0 12px 12px !important;
    padding: 1rem 1.5rem;
    background: #f8f9fa;
}

/* Stat Item Styles */
.stat-item {
    padding: 0.5rem;
}

.stat-number {
    font-size: 2rem;
    font-weight: 700;
    line-height: 1;
    margin-bottom: 0.25rem;
}

.stat-label {
    font-size: 0.875rem;
    color: #6c757d;
    font-weight: 500;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

/* Button Improvements */
.komposisi-card .btn {
    border-radius: 8px;
    font-weight: 500;
    transition: all 0.2s ease;
    border: none;
}

.komposisi-card .btn:hover {
    transform: translateY(-1px);
    box-shadow: 0 4px 12px rgba(0,0,0,0.15);
}

.komposisi-card .btn-warning {
    background: linear-gradient(135deg, #fd7e14 0%, #e8590c 100%);
    border-color: #fd7e14;
    color: white;
}

.komposisi-card .btn-success {
    background: linear-gradient(135deg, #28a745 0%, #1e7e34 100%);
}

/* Info Box Improvements */
.info-box {
    border-radius: 12px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    transition: all 0.3s ease;
}

.info-box:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 20px rgba(0,0,0,0.15);
}

.info-box-icon {
    border-radius: 12px 0 0 12px;
    width: 80px;
    display: flex;
    align-items: center;
    justify-content: center;
    font-size: 2rem;
}

.info-box-content {
    padding: 1rem 1.5rem;
}

.info-box-text {
    font-size: 0.875rem;
    color: #6c757d;
    font-weight: 500;
    text-transform: uppercase;
    letter-spacing: 0.5px;
}

.info-box-number {
    font-size: 2rem;
    font-weight: 700;
    color: #2c3e50;
    line-height: 1;
}

/* Stats overview grid - cleaner layout */
.stats-overview-grid {
    display: grid;
    grid-template-columns: repeat(4, 1fr);
    gap: 16px;
}

.stats-overview-item .info-box {
    height: 100%;
    display: flex;
}

.stats-overview-item .info-box-content {
    display: flex;
    flex-direction: column;
    justify-content: center;
}

@media (max-width: 1200px) {
    .stats-overview-grid {
        grid-template-columns: repeat(2, 1fr);
    }
}

@media (max-width: 576px) {
    .stats-overview-grid {
        grid-template-columns: 1fr;
    }
}

/* Small Box Improvements */
.small-box {
    border-radius: 12px;
    position: relative;
    display: block;
    margin-bottom: 20px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    transition: all 0.3s ease;
    overflow: hidden;
}

.small-box:hover {
    transform: translateY(-2px);
    box-shadow: 0 4px 20px rgba(0,0,0,0.15);
}

.small-box .inner {
    padding: 1.5rem;
    position: relative;
    z-index: 2;
}

.small-box .inner h3 {
    font-size: 2.5rem;
    font-weight: 700;
    margin: 0 0 0.5rem 0;
    color: #2c3e50;
}

.small-box .inner p {
    font-size: 1rem;
    margin: 0;
    color: #6c757d;
    font-weight: 500;
}

.small-box .icon {
    transition: all .3s linear;
    position: absolute;
    top: -10px;
    right: 10px;
    z-index: 1;
    font-size: 80px;
    color: rgba(0,0,0,0.1);
}

/* Filter Card Improvements */
.card {
    border: none;
    border-radius: 12px;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
}

.card-header {
    border-radius: 12px 12px 0 0 !important;
    border-bottom: 1px solid #e9ecef;
    background: #f8f9fa;
}

/* Grid untuk 5 kartu per baris pada statistik jenjang */
.statistik-jenjang-grid {
    display: grid;
    grid-template-columns: repeat(5, 1fr);
    gap: 16px;
}

.statistik-jenjang-item {
    display: block;
}

@media (max-width: 1400px) {
    .statistik-jenjang-grid {
        grid-template-columns: repeat(4, 1fr);
    }
}

@media (max-width: 992px) {
    .statistik-jenjang-grid {
        grid-template-columns: repeat(3, 1fr);
    }
}

@media (max-width: 768px) {
    .statistik-jenjang-grid {
        grid-template-columns: repeat(2, 1fr);
    }
}

@media (max-width: 480px) {
    .statistik-jenjang-grid {
        grid-template-columns: 1fr;
    }
}

/* Responsive Improvements */
@media (max-width: 768px) {
    .komposisi-card .card-header {
        padding: 1rem;
    }
    
    .komposisi-card .card-body {
        padding: 1rem;
    }
    
    .komposisi-card .card-footer {
        padding: 0.75rem 1rem;
    }
    
    .stat-number {
        font-size: 1.5rem;
    }
    
    .info-box-number {
        font-size: 1.5rem;
    }
    
    .small-box .inner h3 {
        font-size: 2rem;
    }
}
</style>
@endpush
