@extends('layouts.app')

@section('title', 'Data Kegiatan - Sistem Informasi PKS')

@section('content')
<style>
/* Custom pagination styling untuk ukuran lebih kecil */
.pagination {
    font-size: 0.875rem;
    margin-bottom: 0;
}

.pagination .page-link {
    padding: 0.375rem 0.75rem;
    font-size: 0.875rem;
    border-radius: 0.375rem;
    margin: 0 0.125rem;
    border: 1px solid #dee2e6;
    color: #6c757d;
    text-decoration: none;
    transition: all 0.15s ease-in-out;
}

.pagination .page-link:hover {
    color: #0056b3;
    background-color: #e9ecef;
    border-color: #dee2e6;
}

.pagination .page-item.active .page-link {
    background-color: #007bff;
    border-color: #007bff;
    color: white;
}

.pagination .page-item.disabled .page-link {
    color: #6c757d;
    background-color: #fff;
    border-color: #dee2e6;
}

.pagination .page-item:first-child .page-link,
.pagination .page-item:last-child .page-link {
    border-radius: 0.375rem;
}

/* Mobile responsive table */
@media (max-width: 768px) {
    .table-responsive {
        border: none;
    }
    
    .table {
        font-size: 0.75rem;
    }
    
    .table th,
    .table td {
        padding: 0.375rem 0.25rem;
        white-space: nowrap;
    }
    
    .table th:first-child,
    .table td:first-child {
        position: sticky;
        left: 0;
        background: white;
        z-index: 10;
    }
    
    .table th:last-child,
    .table td:last-child {
        position: sticky;
        right: 0;
        background: white;
        z-index: 10;
    }
    
    /* Mobile form adjustments */
    .form-control,
    .form-select {
        font-size: 16px; /* Prevents zoom on iOS */
    }
    
    .btn {
        font-size: 0.8rem;
        padding: 0.4rem 0.8rem;
    }
    
    .badge {
        font-size: 0.7rem;
        padding: 0.2rem 0.4rem;
    }
    
    /* Mobile card adjustments */
    .card-header {
        padding: 0.75rem;
    }
    
    .card-body {
        padding: 0.75rem;
    }
    
    /* Mobile search form */
    .row.g-2 > .col-lg-2,
    .row.g-2 > .col-lg-3,
    .row.g-2 > .col-lg-9 {
        margin-bottom: 0.5rem;
    }
    
    /* Mobile table scroll indicator */
    .table-responsive::after {
        content: "← Scroll untuk melihat lebih banyak →";
        display: block;
        text-align: center;
        font-size: 0.75rem;
        color: #6c757d;
        padding: 0.5rem;
        background: #f8f9fa;
        border-top: 1px solid #dee2e6;
    }
}
</style>

<!-- Success/Error Messages -->
@if(session('success'))
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="fas fa-check-circle me-2"></i>
        {{ session('success') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
@endif

@if(session('error'))
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <i class="fas fa-exclamation-circle me-2"></i>
        {{ session('error') }}
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>
@endif

<!-- Page Header -->
<div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center mb-4">
    <div class="mb-3 mb-md-0">
        <h1 class="h2 fw-bold text-dark mb-2">
            <i class="fas fa-calendar-alt text-primary me-2"></i>Data Kegiatan
        </h1>
        <p class="text-muted mb-0 fs-6">
            <i class="fas fa-info-circle me-1"></i>Kelola data kegiatan Partai Keadilan Sejahtera
        </p>
    </div>
    <div class="d-flex flex-column flex-sm-row gap-2">
        <a href="{{ route('kegiatan.create') }}" class="btn btn-primary px-3" style="border-radius: 6px;">
            <i class="fas fa-plus me-1"></i>Tambah Kegiatan
        </a>
    </div>
</div>

<!-- Filter & Search -->
<div class="card shadow-sm mb-4 border-0">
    <div class="card-header bg-gradient-primary py-3">
        <h6 class="m-0 font-weight-bold text-white d-flex align-items-center">
            <i class="fas fa-filter me-2"></i>Filter & Pencarian
        </h6>
    </div>
    <div class="card-body p-3">
        <form method="GET" action="{{ route('kegiatan.index') }}" id="filterForm">
            <!-- Row 1: Pencarian, Jenis, Status, Tanggal -->
            <div class="row g-2 mb-3">
                <div class="col-lg-3 col-md-6">
                    <label class="form-label fw-semibold text-dark small">
                        <i class="fas fa-search me-1 text-primary"></i>Pencarian
                    </label>
                    <input type="text" class="form-control" name="search" 
                           value="{{ request('search') }}" 
                           placeholder="Cari nama kegiatan..."
                           style="border-radius: 6px;">
                </div>
                <div class="col-lg-3 col-md-6">
                    <label class="form-label fw-semibold text-dark small">
                        <i class="fas fa-tag me-1 text-primary"></i>Jenis Kegiatan
                    </label>
                    <select class="form-select" name="jenis" style="border-radius: 6px;">
                        <option value="">Semua Jenis</option>
                        @foreach($jenisKegiatans as $jenis)
                            <option value="{{ $jenis->ref_jenis_kegiatan_id }}" 
                                    {{ request('jenis') == $jenis->ref_jenis_kegiatan_id ? 'selected' : '' }}>
                                {{ $jenis->nama_jenis_kegiatan }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-lg-3 col-md-6">
                    <label class="form-label fw-semibold text-dark small">
                        <i class="fas fa-flag me-1 text-primary"></i>Status
                    </label>
                    <select class="form-select" name="status" style="border-radius: 6px;">
                        <option value="">Semua Status</option>
                        <option value="Direncanakan" {{ request('status') == 'Direncanakan' ? 'selected' : '' }}>Direncanakan</option>
                        <option value="Berlangsung" {{ request('status') == 'Berlangsung' ? 'selected' : '' }}>Berlangsung</option>
                        <option value="Selesai" {{ request('status') == 'Selesai' ? 'selected' : '' }}>Selesai</option>
                        <option value="Dibatalkan" {{ request('status') == 'Dibatalkan' ? 'selected' : '' }}>Dibatalkan</option>
                    </select>
                </div>
                <div class="col-lg-3 col-md-6">
                    <label class="form-label fw-semibold text-dark small">
                        <i class="fas fa-calendar me-1 text-primary"></i>Tanggal Mulai
                    </label>
                    <input type="date" class="form-control" name="tanggal_dari" 
                           value="{{ request('tanggal_dari') }}" 
                           style="border-radius: 6px;">
                </div>
            </div>
            
            <!-- Row 2: Tanggal Sampai dan Action Buttons -->
            <div class="row g-2 align-items-end">
                <div class="col-lg-3 col-md-6">
                    <label class="form-label fw-semibold text-dark small">
                        <i class="fas fa-calendar-check me-1 text-primary"></i>Tanggal Selesai
                    </label>
                    <input type="date" class="form-control" name="tanggal_sampai" 
                           value="{{ request('tanggal_sampai') }}" 
                           style="border-radius: 6px;">
                </div>
                <div class="col-lg-9 col-md-6">
                    <div class="d-flex gap-2">
                        <button type="submit" class="btn btn-primary px-4" style="border-radius: 6px;">
                            <i class="fas fa-search me-1"></i>Cari Data
                        </button>
                        <a href="{{ route('kegiatan.index') }}" class="btn btn-outline-secondary px-4" style="border-radius: 6px;">
                            <i class="fas fa-undo me-1"></i>Reset
                        </a>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Data Table -->
<div class="card shadow-sm border-0">
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table table-striped table-hover mb-0">
                <thead class="table-light">
                    <tr>
                        <th width="5%" class="text-center">No</th>
                        <th width="25%">Nama Kegiatan</th>
                        <th width="12%">Tanggal</th>
                        <th width="10%">Waktu</th>
                        <th width="15%">Tempat</th>
                        <th width="10%">Jenis</th>
                        <th width="12%">PIC</th>
                        <th width="8%" class="text-center">Status</th>
                        <th width="8%" class="text-center">Peserta</th>
                        <th width="12%" class="text-center">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($kegiatans as $index => $kegiatan)
                    <tr>
                        <td class="text-center">{{ $kegiatans->firstItem() + $index }}</td>
                        <td>
                            <strong>{{ $kegiatan->nama_kegiatan }}</strong>
                            @if($kegiatan->deskripsi)
                                <br><small class="text-muted">{{ Str::limit($kegiatan->deskripsi, 50) }}</small>
                            @endif
                        </td>
                        <td>
                            @if($kegiatan->tanggal_mulai)
                                @if($kegiatan->tanggal_selesai && $kegiatan->tanggal_mulai != $kegiatan->tanggal_selesai)
                                    {{ $kegiatan->tanggal_mulai->format('d/m/Y') }} - {{ $kegiatan->tanggal_selesai->format('d/m/Y') }}
                                @else
                                    {{ $kegiatan->tanggal_mulai->format('d/m/Y') }}
                                @endif
                            @else
                                <span class="text-muted">-</span>
                            @endif
                        </td>
                        <td>{{ $kegiatan->waktu_lengkap }}</td>
                        <td>{{ Str::limit($kegiatan->tempat, 30) }}</td>
                        <td>
                            <span class="text-dark">
                                {{ $kegiatan->nama_jenis_kegiatan }}
                            </span>
                        </td>
                        <td>
                            @if($kegiatan->picAnggota)
                                <small class="text-primary">
                                    <i class="fas fa-user me-1"></i>
                                    {{ $kegiatan->picAnggota->nama_lengkap }}
                                </small>
                            @else
                                <small class="text-muted">-</small>
                            @endif
                        </td>
                        <td class="text-center">
                            <span class="text-dark">
                                {{ $kegiatan->status_kegiatan }}
                            </span>
                        </td>
                        <td class="text-center">
                            <small>
                                {{ $kegiatan->getTotalPartisipan() }} orang
                                @if($kegiatan->status_kegiatan == 'Selesai')
                                    <br><span class="text-success">{{ $kegiatan->getTotalHadir() }} hadir</span>
                                @endif
                            </small>
                        </td>
                        <td class="text-center">
                            <div class="btn-group" role="group" aria-label="Actions">
                                {{-- Detail Button --}}
                                <a href="{{ route('kegiatan.show', $kegiatan->id) }}" 
                                   class="btn btn-sm btn-outline-primary" title="Detail">
                                    <i class="fas fa-eye"></i>
                                </a>
                                
                                {{-- Edit Button (jika bisa diedit) --}}
                                @if($kegiatan->canBeEdited())
                                    <a href="{{ route('kegiatan.edit', $kegiatan->id) }}" 
                                       class="btn btn-sm btn-outline-warning" title="Edit">
                                        <i class="fas fa-edit"></i>
                                    </a>
                                    
                                    {{-- Delete Button --}}
                                    <form action="{{ route('kegiatan.destroy', $kegiatan->id) }}" 
                                          method="POST" style="display: inline;" 
                                          onsubmit="return confirm('Yakin hapus kegiatan ini?')">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-outline-danger" title="Hapus">
                                            <i class="fas fa-trash"></i>
                                        </button>
                                    </form>
                                @endif
                            </div>
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="10" class="text-center text-muted py-4">
                            <i class="fas fa-calendar-times fa-3x mb-3 d-block"></i>
                            <strong>Tidak ada data kegiatan</strong><br>
                            <small>Klik tombol "Tambah Kegiatan" untuk menambah kegiatan baru</small>
                        </td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        
        {{-- Pagination --}}
        @if($kegiatans->hasPages())
            <div class="d-flex justify-content-center p-3">
                {{ $kegiatans->appends(request()->query())->links() }}
            </div>
        @endif
    </div>
</div>
@endsection