@extends('layouts.app')

@section('title', 'Buat Kegiatan - Seleksi Partisipan Bertingkat')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h3 class="card-title">
                        <i class="fas fa-calendar-plus"></i> Buat Kegiatan Baru
                    </h3>
                    <div class="card-tools">
                        <a href="{{ route('kegiatan.index') }}" class="btn btn-sm btn-secondary">
                            <i class="fas fa-arrow-left"></i> Kembali
                        </a>
                    </div>
                </div>

                <form action="{{ route('kegiatan.hierarchical.store') }}" method="POST" id="kegiatanForm">
                    @csrf
                    <div class="card-body">
                        <!-- Informasi Dasar Kegiatan -->
                        <div class="row">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="nama_kegiatan">Nama Kegiatan <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('nama_kegiatan') is-invalid @enderror" 
                                           id="nama_kegiatan" name="nama_kegiatan" 
                                           value="{{ old('nama_kegiatan') }}" required>
                                    @error('nama_kegiatan')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="ref_jenis_kegiatan_id">Jenis Kegiatan <span class="text-danger">*</span></label>
                                    <select class="form-control @error('ref_jenis_kegiatan_id') is-invalid @enderror" 
                                            id="ref_jenis_kegiatan_id" name="ref_jenis_kegiatan_id" required>
                                        <option value="">Pilih Jenis Kegiatan</option>
                                        @foreach($jenisKegiatans as $jenis)
                                            <option value="{{ $jenis->ref_jenis_kegiatan_id }}" 
                                                    {{ old('ref_jenis_kegiatan_id') == $jenis->ref_jenis_kegiatan_id ? 'selected' : '' }}>
                                                {{ $jenis->nama_jenis_kegiatan }}
                                            </option>
                                        @endforeach
                                        <option value="lainnya" {{ old('ref_jenis_kegiatan_id') == 'lainnya' ? 'selected' : '' }}>Lainnya</option>
                                    </select>
                                    @error('ref_jenis_kegiatan_id')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row" id="jenis_lainnya_row" style="display: none;">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="jenis_kegiatan_lainnya">Jenis Kegiatan Lainnya <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('jenis_kegiatan_lainnya') is-invalid @enderror" 
                                           id="jenis_kegiatan_lainnya" name="jenis_kegiatan_lainnya" 
                                           value="{{ old('jenis_kegiatan_lainnya') }}">
                                    @error('jenis_kegiatan_lainnya')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12">
                                <div class="form-group">
                                    <label for="deskripsi">Deskripsi Kegiatan</label>
                                    <textarea class="form-control @error('deskripsi') is-invalid @enderror" 
                                              id="deskripsi" name="deskripsi" rows="3">{{ old('deskripsi') }}</textarea>
                                    @error('deskripsi')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- Waktu dan Tempat -->
                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label>Jenis Event <span class="text-danger">*</span></label>
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" name="event_type" id="event_single" 
                                               value="single" {{ old('event_type', 'single') == 'single' ? 'checked' : '' }}>
                                        <label class="form-check-label" for="event_single">
                                            Event Tunggal
                                        </label>
                                    </div>
                                    <div class="form-check">
                                        <input class="form-check-input" type="radio" name="event_type" id="event_multi" 
                                               value="multi" {{ old('event_type') == 'multi' ? 'checked' : '' }}>
                                        <label class="form-check-label" for="event_multi">
                                            Event Berkelanjutan
                                        </label>
                                    </div>
                                </div>
                            </div>
                            <div class="col-md-3" id="tanggal_single">
                                <div class="form-group">
                                    <label for="tanggal_kegiatan">Tanggal Kegiatan <span class="text-danger">*</span></label>
                                    <input type="date" class="form-control @error('tanggal_kegiatan') is-invalid @enderror" 
                                           id="tanggal_kegiatan" name="tanggal_kegiatan" 
                                           value="{{ old('tanggal_kegiatan') }}">
                                    @error('tanggal_kegiatan')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-3" id="tanggal_multi" style="display: none;">
                                <div class="form-group">
                                    <label for="tanggal_mulai">Tanggal Mulai <span class="text-danger">*</span></label>
                                    <input type="date" class="form-control @error('tanggal_mulai') is-invalid @enderror" 
                                           id="tanggal_mulai" name="tanggal_mulai" 
                                           value="{{ old('tanggal_mulai') }}">
                                    @error('tanggal_mulai')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-3" id="tanggal_selesai_multi" style="display: none;">
                                <div class="form-group">
                                    <label for="tanggal_selesai">Tanggal Selesai <span class="text-danger">*</span></label>
                                    <input type="date" class="form-control @error('tanggal_selesai') is-invalid @enderror" 
                                           id="tanggal_selesai" name="tanggal_selesai" 
                                           value="{{ old('tanggal_selesai') }}">
                                    @error('tanggal_selesai')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="waktu_mulai">Waktu Mulai <span class="text-danger">*</span></label>
                                    <input type="time" class="form-control @error('waktu_mulai') is-invalid @enderror" 
                                           id="waktu_mulai" name="waktu_mulai" 
                                           value="{{ old('waktu_mulai') }}">
                                    @error('waktu_mulai')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label for="waktu_selesai">Waktu Selesai</label>
                                    <input type="time" class="form-control @error('waktu_selesai') is-invalid @enderror" 
                                           id="waktu_selesai" name="waktu_selesai" 
                                           value="{{ old('waktu_selesai') }}">
                                    @error('waktu_selesai')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="tempat">Tempat <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control @error('tempat') is-invalid @enderror" 
                                           id="tempat" name="tempat" 
                                           value="{{ old('tempat') }}" required>
                                    @error('tempat')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>

                        <!-- Seleksi Partisipan Bertingkat -->
                        <div class="card mt-4">
                            <div class="card-header">
                                <h5 class="card-title">
                                    <i class="fas fa-users"></i> Seleksi Partisipan Bertingkat
                                </h5>
                                <p class="text-muted">Pilih partisipan berdasarkan hierarki: DPD → DPC → UPA → Orang</p>
                            </div>
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label for="dpd_id">DPD (Provinsi)</label>
                                            <select class="form-control" id="dpd_id" name="dpd_id">
                                                <option value="">Pilih DPD</option>
                                                @foreach($dpds as $dpd)
                                                    <option value="{{ $dpd->dpd_id }}">{{ $dpd->nama_dpd }}</option>
                                                @endforeach
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label for="dpc_id">DPC (Kabupaten/Kota)</label>
                                            <select class="form-control" id="dpc_id" name="dpc_id" disabled>
                                                <option value="">Pilih DPC</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label for="upa_id">UPA (Kecamatan)</label>
                                            <select class="form-control" id="upa_id" name="upa_id" disabled>
                                                <option value="">Pilih UPA</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label for="anggota_id">Anggota</label>
                                            <select class="form-control" id="anggota_id" name="anggota_id" disabled>
                                                <option value="">Pilih Anggota</option>
                                            </select>
                                        </div>
                                    </div>
                                </div>

                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="status_partisipasi">Status Partisipasi</label>
                                            <select class="form-control" id="status_partisipasi" name="status_partisipasi">
                                                <option value="Wajib">Wajib</option>
                                                <option value="Opsional">Opsional</option>
                                                <option value="Undangan">Undangan</option>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label>&nbsp;</label>
                                            <div>
                                                <button type="button" class="btn btn-primary" id="addPartisipan">
                                                    <i class="fas fa-plus"></i> Tambah Partisipan
                                                </button>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <!-- Daftar Partisipan yang Dipilih -->
                                <div class="mt-4">
                                    <h6>Partisipan yang Dipilih:</h6>
                                    <div id="partisipanList" class="table-responsive">
                                        <table class="table table-sm table-bordered">
                                            <thead>
                                                <tr>
                                                    <th>Jenis</th>
                                                    <th>Nama</th>
                                                    <th>Hierarki</th>
                                                    <th>Status</th>
                                                    <th>Aksi</th>
                                                </tr>
                                            </thead>
                                            <tbody id="partisipanTableBody">
                                                <!-- Partisipan akan ditambahkan di sini -->
                                            </tbody>
                                        </table>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Informasi Tambahan -->
                        <div class="row mt-4">
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="target_peserta">Target Peserta</label>
                                    <input type="number" class="form-control @error('target_peserta') is-invalid @enderror" 
                                           id="target_peserta" name="target_peserta" 
                                           value="{{ old('target_peserta') }}" min="1">
                                    @error('target_peserta')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="form-group">
                                    <label for="catatan">Catatan</label>
                                    <textarea class="form-control @error('catatan') is-invalid @enderror" 
                                              id="catatan" name="catatan" rows="2">{{ old('catatan') }}</textarea>
                                    @error('catatan')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                    </div>

                    <div class="card-footer">
                        <button type="submit" class="btn btn-primary">
                            <i class="fas fa-save"></i> Simpan Kegiatan
                        </button>
                        <a href="{{ route('kegiatan.index') }}" class="btn btn-secondary">
                            <i class="fas fa-times"></i> Batal
                        </a>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    let partisipanCounter = 0;
    let selectedPartisipan = [];

    // Handle event type change
    $('input[name="event_type"]').change(function() {
        if ($(this).val() === 'single') {
            $('#tanggal_single').show();
            $('#tanggal_multi').hide();
            $('#tanggal_selesai_multi').hide();
            $('#tanggal_mulai').prop('required', false);
            $('#tanggal_selesai').prop('required', false);
            $('#tanggal_kegiatan').prop('required', true);
        } else {
            $('#tanggal_single').hide();
            $('#tanggal_multi').show();
            $('#tanggal_selesai_multi').show();
            $('#tanggal_kegiatan').prop('required', false);
            $('#tanggal_mulai').prop('required', true);
            $('#tanggal_selesai').prop('required', true);
        }
    });

    // Handle jenis kegiatan change
    $('#ref_jenis_kegiatan_id').change(function() {
        if ($(this).val() === 'lainnya') {
            $('#jenis_lainnya_row').show();
            $('#jenis_kegiatan_lainnya').prop('required', true);
        } else {
            $('#jenis_lainnya_row').hide();
            $('#jenis_kegiatan_lainnya').prop('required', false);
        }
    });

    // Initialize jenis kegiatan
    if ($('#ref_jenis_kegiatan_id').val() === 'lainnya') {
        $('#jenis_lainnya_row').show();
        $('#jenis_kegiatan_lainnya').prop('required', true);
    }

    // Handle DPD change
    $('#dpd_id').change(function() {
        const dpdId = $(this).val();
        
        // Reset downstream selects
        $('#dpc_id').html('<option value="">Pilih DPC</option>').prop('disabled', true);
        $('#upa_id').html('<option value="">Pilih UPA</option>').prop('disabled', true);
        $('#anggota_id').html('<option value="">Pilih Anggota</option>').prop('disabled', true);
        
        if (dpdId) {
            $.get(`/kegiatan/api/dpc-by-dpd`, { dpd_id: dpdId })
                .done(function(data) {
                    let options = '<option value="">Pilih DPC</option>';
                    data.data.forEach(function(dpc) {
                        options += `<option value="${dpc.dpc_id}">${dpc.nama_dpc}</option>`;
                    });
                    $('#dpc_id').html(options).prop('disabled', false);
                })
                .fail(function() {
                    alert('Gagal memuat data DPC');
                });
        }
    });

    // Handle DPC change
    $('#dpc_id').change(function() {
        const dpcId = $(this).val();
        
        // Reset downstream selects
        $('#upa_id').html('<option value="">Pilih UPA</option>').prop('disabled', true);
        $('#anggota_id').html('<option value="">Pilih Anggota</option>').prop('disabled', true);
        
        if (dpcId) {
            $.get(`/kegiatan/api/upa-by-dpc`, { dpc_id: dpcId })
                .done(function(data) {
                    let options = '<option value="">Pilih UPA</option>';
                    data.data.forEach(function(upa) {
                        options += `<option value="${upa.upa_id}">${upa.nama_upa}</option>`;
                    });
                    $('#upa_id').html(options).prop('disabled', false);
                })
                .fail(function() {
                    alert('Gagal memuat data UPA');
                });
        }
    });

    // Handle UPA change
    $('#upa_id').change(function() {
        const upaId = $(this).val();
        
        // Reset downstream selects
        $('#anggota_id').html('<option value="">Pilih Anggota</option>').prop('disabled', true);
        
        if (upaId) {
            $.get(`/kegiatan/api/anggota-by-upa`, { upa_id: upaId })
                .done(function(data) {
                    let options = '<option value="">Pilih Anggota</option>';
                    data.data.forEach(function(anggota) {
                        options += `<option value="${anggota.id}">${anggota.nama_lengkap}</option>`;
                    });
                    $('#anggota_id').html(options).prop('disabled', false);
                })
                .fail(function() {
                    alert('Gagal memuat data Anggota');
                });
        }
    });

    // Add partisipan
    $('#addPartisipan').click(function() {
        const dpdId = $('#dpd_id').val();
        const dpcId = $('#dpc_id').val();
        const upaId = $('#upa_id').val();
        const anggotaId = $('#anggota_id').val();
        const statusPartisipasi = $('#status_partisipasi').val();

        // Determine selection type and data
        let selectionType = '';
        let selectionId = '';
        let selectionName = '';
        let hierarchyPath = '';

        if (anggotaId) {
            selectionType = 'anggota';
            selectionId = anggotaId;
            selectionName = $('#anggota_id option:selected').text();
            hierarchyPath = `${$('#dpd_id option:selected').text()} → ${$('#dpc_id option:selected').text()} → ${$('#upa_id option:selected').text()} → ${selectionName}`;
        } else if (upaId) {
            selectionType = 'upa';
            selectionId = upaId;
            selectionName = $('#upa_id option:selected').text();
            hierarchyPath = `${$('#dpd_id option:selected').text()} → ${$('#dpc_id option:selected').text()} → ${selectionName}`;
        } else if (dpcId) {
            selectionType = 'dpc';
            selectionId = dpcId;
            selectionName = $('#dpc_id option:selected').text();
            hierarchyPath = `${$('#dpd_id option:selected').text()} → ${selectionName}`;
        } else if (dpdId) {
            selectionType = 'dpd';
            selectionId = dpdId;
            selectionName = $('#dpd_id option:selected').text();
            hierarchyPath = selectionName;
        } else {
            alert('Pilih minimal DPD untuk menambahkan partisipan');
            return;
        }

        // Check if already selected
        const existingKey = `${selectionType}_${selectionId}`;
        if (selectedPartisipan.includes(existingKey)) {
            alert('Partisipan ini sudah dipilih');
            return;
        }

        // Add to selected list
        selectedPartisipan.push(existingKey);

        // Add to table
        const row = `
            <tr data-counter="${partisipanCounter}">
                <td>
                    <input type="hidden" name="partisipan_hierarchical[${partisipanCounter}][selection_type]" value="${selectionType}">
                    <input type="hidden" name="partisipan_hierarchical[${partisipanCounter}][status_partisipasi]" value="${statusPartisipasi}">
                    <input type="hidden" name="partisipan_hierarchical[${partisipanCounter}][dpd_id]" value="${dpdId}">
                    <input type="hidden" name="partisipan_hierarchical[${partisipanCounter}][dpc_id]" value="${dpcId}">
                    <input type="hidden" name="partisipan_hierarchical[${partisipanCounter}][upa_id]" value="${upaId}">
                    <input type="hidden" name="partisipan_hierarchical[${partisipanCounter}][anggota_id]" value="${anggotaId}">
                    <span class="badge badge-info">${selectionType.toUpperCase()}</span>
                </td>
                <td>${selectionName}</td>
                <td>${hierarchyPath}</td>
                <td><span class="badge badge-primary">${statusPartisipasi}</span></td>
                <td>
                    <button type="button" class="btn btn-sm btn-danger removePartisipan" data-counter="${partisipanCounter}">
                        <i class="fas fa-trash"></i>
                    </button>
                </td>
            </tr>
        `;
        
        $('#partisipanTableBody').append(row);
        partisipanCounter++;

        // Reset form
        $('#dpd_id, #dpc_id, #upa_id, #anggota_id').val('').trigger('change');
        $('#dpc_id, #upa_id, #anggota_id').prop('disabled', true);
    });

    // Remove partisipan
    $(document).on('click', '.removePartisipan', function() {
        const counter = $(this).data('counter');
        const row = $(`tr[data-counter="${counter}"]`);
        
        // Remove from selected list
        const selectionType = row.find('input[name*="[selection_type]"]').val();
        const selectionId = row.find(`input[name*="[${selectionType}_id]"]`).val();
        const existingKey = `${selectionType}_${selectionId}`;
        
        selectedPartisipan = selectedPartisipan.filter(key => key !== existingKey);
        
        // Remove row
        row.remove();
    });
});
</script>
@endpush
