@extends('layouts.app')

@section('title', 'Detail Jenis Kegiatan')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0">Detail Jenis Kegiatan</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('jenis-kegiatan.index') }}">Master Jenis Kegiatan</a></li>
                        <li class="breadcrumb-item active">Detail Jenis Kegiatan</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-8">
            <div class="card">
                <div class="card-header">
                    <div class="d-flex justify-content-between align-items-center">
                        <h5 class="card-title mb-0">{{ $jenisKegiatan->nama_jenis_kegiatan }}</h5>
                        <div>
                            <a href="{{ route('jenis-kegiatan.edit', $jenisKegiatan) }}" class="btn btn-warning btn-sm">
                                <i class="fas fa-edit me-1"></i> Edit
                            </a>
                            <a href="{{ route('jenis-kegiatan.index') }}" class="btn btn-secondary btn-sm">
                                <i class="fas fa-arrow-left me-1"></i> Kembali
                            </a>
                        </div>
                    </div>
                </div>

                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <td class="fw-bold text-muted">Kode Jenis Kegiatan:</td>
                                    <td><span class="badge bg-primary">{{ $jenisKegiatan->kode_jenis_kegiatan }}</span></td>
                                </tr>
                                <tr>
                                    <td class="fw-bold text-muted">Nama Jenis Kegiatan:</td>
                                    <td>{{ $jenisKegiatan->nama_jenis_kegiatan }}</td>
                                </tr>
                                <tr>
                                    <td class="fw-bold text-muted">Kategori:</td>
                                    <td>
                                        @if($jenisKegiatan->kategori)
                                            <span class="badge bg-info">{{ $jenisKegiatan->kategori }}</span>
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <td class="fw-bold text-muted">Status:</td>
                                    <td>
                                        <span class="badge bg-{{ $jenisKegiatan->is_active ? 'success' : 'warning' }}">
                                            {{ $jenisKegiatan->is_active ? 'Aktif' : 'Tidak Aktif' }}
                                        </span>
                                    </td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-md-6">
                            <table class="table table-borderless">
                                <tr>
                                    <td class="fw-bold text-muted">Durasi Standar:</td>
                                    <td>
                                        @if($jenisKegiatan->durasi_standar)
                                            <span class="text-muted">{{ $jenisKegiatan->durasi_formatted }}</span>
                                        @else
                                            <span class="text-muted">-</span>
                                        @endif
                                    </td>
                                </tr>
                                <tr>
                                    <td class="fw-bold text-muted">Dibuat:</td>
                                    <td>{{ $jenisKegiatan->created_at->format('d F Y H:i') }}</td>
                                </tr>
                                <tr>
                                    <td class="fw-bold text-muted">Diperbarui:</td>
                                    <td>{{ $jenisKegiatan->updated_at->format('d F Y H:i') }}</td>
                                </tr>
                            </table>
                        </div>
                    </div>

                    @if($jenisKegiatan->deskripsi)
                        <div class="row mt-3">
                            <div class="col-12">
                                <h6 class="text-primary">Deskripsi</h6>
                                <p class="text-muted">{{ $jenisKegiatan->deskripsi }}</p>
                            </div>
                        </div>
                    @endif

                    @if($jenisKegiatan->catatan)
                        <div class="row mt-3">
                            <div class="col-12">
                                <h6 class="text-primary">Catatan</h6>
                                <p class="text-muted">{{ $jenisKegiatan->catatan }}</p>
                            </div>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
