@extends('layouts.app')

@section('title', 'Master Jenis Kegiatan')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0">Master Jenis Kegiatan</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
                        <li class="breadcrumb-item active">Master Jenis Kegiatan</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <div class="row align-items-center">
                        <div class="col">
                            <h5 class="card-title mb-0">Daftar Jenis Kegiatan</h5>
                        </div>
                        <div class="col-auto">
                            <a href="{{ route('jenis-kegiatan.create') }}" class="btn btn-primary">
                                <i class="fas fa-plus me-1"></i> Tambah Jenis Kegiatan
                            </a>
                        </div>
                    </div>
                </div>

                <div class="card-body">
                    <!-- Filter dan Pencarian -->
                    <div class="row mb-3">
                        <div class="col-md-4">
                            <form method="GET" class="d-flex">
                                <input type="text" class="form-control me-2" name="search" 
                                       value="{{ request('search') }}" placeholder="Cari jenis kegiatan...">
                                <button type="submit" class="btn btn-outline-primary">
                                    <i class="fas fa-search"></i>
                                </button>
                            </form>
                        </div>
                        <div class="col-md-3">
                            <select class="form-select" onchange="filterByKategori(this.value)">
                                <option value="">Semua Kategori</option>
                                @foreach($kategoriList as $kategori)
                                    <option value="{{ $kategori }}" {{ request('kategori') == $kategori ? 'selected' : '' }}>
                                        {{ $kategori }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-3">
                            <select class="form-select" onchange="filterByStatus(this.value)">
                                <option value="">Semua Status</option>
                                <option value="aktif" {{ request('status') == 'aktif' ? 'selected' : '' }}>Aktif</option>
                                <option value="tidak-aktif" {{ request('status') == 'tidak-aktif' ? 'selected' : '' }}>Tidak Aktif</option>
                            </select>
                        </div>
                        <div class="col-md-2 text-end">
                            @if(request('search') || request('kategori') || request('status'))
                                <a href="{{ route('jenis-kegiatan.index') }}" class="btn btn-outline-secondary">
                                    <i class="fas fa-times me-1"></i> Reset
                                </a>
                            @endif
                        </div>
                    </div>

                    <!-- Tabel Jenis Kegiatan -->
                    <div class="table-responsive">
                        <table class="table table-hover">
                            <thead class="table-light">
                                <tr>
                                    <th>No</th>
                                    <th>Kode</th>
                                    <th>Nama Jenis Kegiatan</th>
                                    <th>Kategori</th>
                                    <th>Durasi Standar</th>
                                    <th>Status</th>
                                    <th>Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse($jenisKegiatans as $index => $jenisKegiatan)
                                    <tr>
                                        <td>{{ $jenisKegiatans->firstItem() + $index }}</td>
                                        <td>
                                            <span class="fw-bold text-primary">{{ $jenisKegiatan->kode_jenis_kegiatan }}</span>
                                        </td>
                                        <td>
                                            <div>
                                                <div class="fw-bold">{{ $jenisKegiatan->nama_jenis_kegiatan }}</div>
                                                @if($jenisKegiatan->deskripsi)
                                                    <small class="text-muted">{{ Str::limit($jenisKegiatan->deskripsi, 50) }}</small>
                                                @endif
                                            </div>
                                        </td>
                                        <td>
                                            @if($jenisKegiatan->kategori)
                                                <span class="badge bg-info">{{ $jenisKegiatan->kategori }}</span>
                                            @else
                                                <span class="text-muted">-</span>
                                            @endif
                                        </td>
                                        <td>
                                            @if($jenisKegiatan->durasi_standar)
                                                <span class="text-muted">{{ $jenisKegiatan->durasi_formatted }}</span>
                                            @else
                                                <span class="text-muted">-</span>
                                            @endif
                                        </td>
                                        <td>
                                            <span class="badge bg-{{ $jenisKegiatan->is_active ? 'success' : 'warning' }}">
                                                {{ $jenisKegiatan->is_active ? 'Aktif' : 'Tidak Aktif' }}
                                            </span>
                                        </td>
                                        <td>
                                            <div class="btn-group" role="group">
                                                <a href="{{ route('jenis-kegiatan.show', $jenisKegiatan) }}" class="btn btn-sm btn-outline-info" title="Lihat Detail">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                                <a href="{{ route('jenis-kegiatan.edit', $jenisKegiatan) }}" class="btn btn-sm btn-outline-warning" title="Edit">
                                                    <i class="fas fa-edit"></i>
                                                </a>
                                                <form action="{{ route('jenis-kegiatan.destroy', $jenisKegiatan) }}" method="POST" class="d-inline" 
                                                      onsubmit="return confirm('Apakah Anda yakin ingin menghapus jenis kegiatan ini?')">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="submit" class="btn btn-sm btn-outline-danger" title="Hapus">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="7" class="text-center py-4">
                                            <div class="text-muted">
                                                <i class="fas fa-inbox fa-3x mb-3"></i>
                                                <p>Tidak ada data jenis kegiatan ditemukan</p>
                                                @if(request('search') || request('kategori') || request('status'))
                                                    <a href="{{ route('jenis-kegiatan.index') }}" class="btn btn-outline-primary">
                                                        Lihat Semua Jenis Kegiatan
                                                    </a>
                                                @endif
                                            </div>
                                        </td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <!-- Pagination -->
                    @if($jenisKegiatans->hasPages())
                        <div class="d-flex justify-content-center">
                            {{ $jenisKegiatans->links() }}
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<script>
function filterByKategori(kategori) {
    const url = new URL(window.location);
    if (kategori) {
        url.searchParams.set('kategori', kategori);
    } else {
        url.searchParams.delete('kategori');
    }
    window.location = url;
}

function filterByStatus(status) {
    const url = new URL(window.location);
    if (status) {
        url.searchParams.set('status', status);
    } else {
        url.searchParams.delete('status');
    }
    window.location = url;
}
</script>
@endsection
