@extends('layouts.app')

@section('title', 'Edit Indikator Takwim')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0">Edit Indikator Takwim</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('indikator-takwim.index') }}">Master Indikator Takwim</a></li>
                        <li class="breadcrumb-item active">Edit Indikator</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">Form Edit Indikator Takwim</h5>
                </div>

                <div class="card-body">
                    @if(session('error'))
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            {{ session('error') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    @endif
                    
                    <form action="{{ route('indikator-takwim.update', $indikatorTakwim) }}" method="POST">
                        @csrf
                        @method('PUT')
                        
                        <div class="row">
                            <div class="col-md-3 mb-3">
                                <label class="form-label">Nomor Urut <span class="text-danger">*</span></label>
                                <input type="number" class="form-control @error('nomor') is-invalid @enderror" 
                                       name="nomor" value="{{ old('nomor', $indikatorTakwim->nomor) }}" 
                                       placeholder="1" min="1">
                                @error('nomor')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <div class="form-text">Nomor urut indikator (harus unik)</div>
                            </div>
                            
                            <div class="col-md-9 mb-3">
                                <label class="form-label">Indikator <span class="text-danger">*</span></label>
                                <textarea class="form-control @error('indikator') is-invalid @enderror" 
                                          name="indikator" rows="3" 
                                          placeholder="Masukkan deskripsi indikator takwim">{{ old('indikator', $indikatorTakwim->indikator) }}</textarea>
                                @error('indikator')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <div class="form-text">Deskripsi lengkap indikator penilaian takwim</div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12 mb-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="is_active" id="is_active" 
                                           {{ old('is_active', $indikatorTakwim->is_active) ? 'checked' : '' }}>
                                    <label class="form-check-label" for="is_active">
                                        Status Aktif
                                    </label>
                                </div>
                                <div class="form-text">Centang jika indikator ini aktif digunakan</div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-12">
                                <div class="d-flex justify-content-between">
                                    <a href="{{ route('indikator-takwim.index') }}" class="btn btn-secondary">
                                        <i class="fas fa-arrow-left me-1"></i> Kembali
                                    </a>
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-save me-1"></i> Update Indikator
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Info Card -->
    <div class="row mt-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">Informasi Indikator</h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <p><strong>Dibuat pada:</strong> {{ $indikatorTakwim->created_at->format('d/m/Y H:i:s') }}</p>
                            <p><strong>Terakhir diupdate:</strong> {{ $indikatorTakwim->updated_at->format('d/m/Y H:i:s') }}</p>
                        </div>
                        <div class="col-md-6">
                            <p><strong>Status saat ini:</strong> 
                                @if($indikatorTakwim->is_active)
                                    <span class="badge bg-success">Aktif</span>
                                @else
                                    <span class="badge bg-danger">Tidak Aktif</span>
                                @endif
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
