@extends('layouts.app')

@section('title', 'Tambah Indikator Takwim')

@section('content')
<div class="container-fluid">
    <div class="row">
        <div class="col-12">
            <div class="page-title-box d-sm-flex align-items-center justify-content-between">
                <h4 class="mb-sm-0">Tambah Indikator Takwim</h4>
                <div class="page-title-right">
                    <ol class="breadcrumb m-0">
                        <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
                        <li class="breadcrumb-item"><a href="{{ route('indikator-takwim.index') }}">Master Indikator Takwim</a></li>
                        <li class="breadcrumb-item active">Tambah Indikator</li>
                    </ol>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">Form Tambah Indikator Takwim</h5>
                </div>

                <div class="card-body">
                    @if(session('error'))
                        <div class="alert alert-danger alert-dismissible fade show" role="alert">
                            {{ session('error') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    @endif
                    
                    <form action="{{ route('indikator-takwim.store') }}" method="POST">
                        @csrf
                        
                        <div class="row">
                            <div class="col-md-3 mb-3">
                                <label class="form-label">Nomor Urut <span class="text-danger">*</span></label>
                                <input type="number" class="form-control @error('nomor') is-invalid @enderror" 
                                       name="nomor" value="{{ old('nomor') }}" 
                                       placeholder="1" min="1">
                                @error('nomor')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <div class="form-text">Nomor urut indikator (harus unik)</div>
                            </div>
                            
                            <div class="col-md-9 mb-3">
                                <label class="form-label">Indikator <span class="text-danger">*</span></label>
                                <textarea class="form-control @error('indikator') is-invalid @enderror" 
                                          name="indikator" rows="3" 
                                          placeholder="Masukkan deskripsi indikator takwim">{{ old('indikator') }}</textarea>
                                @error('indikator')
                                    <div class="invalid-feedback">{{ $message }}</div>
                                @enderror
                                <div class="form-text">Deskripsi lengkap indikator penilaian takwim</div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-12 mb-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" name="is_active" id="is_active" 
                                           {{ old('is_active', true) ? 'checked' : '' }}>
                                    <label class="form-check-label" for="is_active">
                                        Status Aktif
                                    </label>
                                </div>
                                <div class="form-text">Centang jika indikator ini aktif digunakan</div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-12">
                                <div class="d-flex justify-content-between">
                                    <a href="{{ route('indikator-takwim.index') }}" class="btn btn-secondary">
                                        <i class="fas fa-arrow-left me-1"></i> Kembali
                                    </a>
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-save me-1"></i> Simpan Indikator
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- Preview Card -->
    <div class="row mt-4">
        <div class="col-12">
            <div class="card">
                <div class="card-header">
                    <h5 class="card-title mb-0">Contoh Indikator Takwim</h5>
                </div>
                <div class="card-body">
                    <div class="info-box">
                        <h6><i class="fas fa-info-circle me-2"></i>Contoh Indikator Takwim:</h6>
                        <ol class="mb-0">
                            <li>Memiliki pemahaman keagamaan yang mendalam, utuh, dan moderat sesuai dengan akidah ahlus sunnah wal jama'ah</li>
                            <li>Berusaha mewujudkan keluarga dakwah</li>
                            <li>Berkontribusi dan terlibat aktif dalam struktur partai atau amanah yang telah ditugaskan pimpinan partai</li>
                            <li>Melakukan pembinaan secara rutin baik langsung maupun tidak langsung</li>
                            <li>Setia dan komitmen pada seluruh kebijakan dan peraturan partai</li>
                            <li>Terlibat aktif dalam mengcounter opini yang mendeskreditkan partai dan pimpinan</li>
                            <li>Menerapkan pemahaman Konsensus Dasar Kebangsaan</li>
                        </ol>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
