@extends('layouts.app')

@section('title', 'Detail DPC')

@section('content')
<style>
.bg-gradient-primary {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
}

.info-card {
    border-left: 4px solid #667eea;
    background: white;
    border-radius: 10px;
    padding: 1.5rem;
    box-shadow: 0 2px 15px rgba(102, 126, 234, 0.1);
    transition: all 0.3s ease;
}

.info-card:hover {
    transform: translateY(-3px);
    box-shadow: 0 8px 25px rgba(102, 126, 234, 0.2);
}

.stats-box {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    border-radius: 15px;
    padding: 2rem;
    color: white;
    text-align: center;
    box-shadow: 0 4px 20px rgba(102, 126, 234, 0.3);
    transition: all 0.3s ease;
}

.stats-box:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 30px rgba(102, 126, 234, 0.4);
}

.stats-number {
    font-size: 3rem;
    font-weight: 700;
    margin-bottom: 0.5rem;
}

.stats-label {
    font-size: 1rem;
    opacity: 0.9;
    text-transform: uppercase;
    letter-spacing: 1px;
}

.upa-card {
    border: 1px solid #e0e0e0;
    border-radius: 10px;
    padding: 1.5rem;
    margin-bottom: 1rem;
    transition: all 0.3s ease;
    background: white;
}

.upa-card:hover {
    border-color: #667eea;
    box-shadow: 0 4px 20px rgba(102, 126, 234, 0.15);
    transform: translateX(5px);
}
</style>

<!-- Page Header -->
<div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center mb-4">
    <div class="mb-3 mb-md-0">
        <h1 class="h2 fw-bold text-dark mb-2">
            <i class="fas fa-info-circle text-primary me-2"></i>Detail DPC
        </h1>
        <p class="text-muted mb-0 fs-6">
            <i class="fas fa-sitemap me-1"></i>Informasi lengkap Dewan Pimpinan Cabang
        </p>
    </div>
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb mb-0">
            <li class="breadcrumb-item"><a href="{{ route('dashboard') }}">Dashboard</a></li>
            <li class="breadcrumb-item"><a href="{{ route('dpc.index') }}">Data DPC</a></li>
            <li class="breadcrumb-item active">Detail DPC</li>
        </ol>
    </nav>
</div>

<!-- DPC Information Card -->
<div class="row mb-4">
    <div class="col-12">
        <div class="card shadow-sm border-0">
            <div class="card-header bg-gradient-primary py-3">
                <h5 class="m-0 font-weight-bold text-white d-flex align-items-center">
                    <i class="fas fa-sitemap me-2"></i>Informasi DPC
                </h5>
            </div>
            <div class="card-body p-4">
                <div class="row">
                    <!-- Left Column -->
                    <div class="col-md-6">
                        <div class="mb-4">
                            <label class="text-muted small fw-bold mb-2">
                                <i class="fas fa-barcode me-1"></i>Kode DPC
                            </label>
                            <h4 class="text-dark mb-0">
                                <span class="badge bg-info text-white px-3 py-2" style="font-size: 1.1rem;">
                                    {{ $dpc->kode_dpc }}
                                </span>
                            </h4>
                        </div>
                        
                        <div class="mb-4">
                            <label class="text-muted small fw-bold mb-2">
                                <i class="fas fa-sitemap me-1"></i>Nama DPC
                            </label>
                            <h3 class="text-dark mb-0">{{ $dpc->nama_dpc }}</h3>
                        </div>
                        
                        <div class="mb-4">
                            <label class="text-muted small fw-bold mb-2">
                                <i class="fas fa-building me-1"></i>DPD
                            </label>
                            <h5 class="text-dark mb-0">
                                @if($dpc->dpd)
                                    <span class="badge bg-secondary px-3 py-2" style="font-size: 1rem;">
                                        {{ $dpc->dpd->nama_dpd }}
                                    </span>
                                @else
                                    <span class="text-muted">-</span>
                                @endif
                            </h5>
                        </div>
                    </div>
                    
                    <!-- Right Column -->
                    <div class="col-md-6">
                        <div class="mb-4">
                            <label class="text-muted small fw-bold mb-2">
                                <i class="fas fa-info-circle me-1"></i>Status
                            </label>
                            <h5 class="mb-0">
                                <span class="badge bg-{{ $dpc->is_active ? 'success' : 'danger' }} px-3 py-2" style="font-size: 1rem;">
                                    {{ $dpc->is_active ? 'Aktif' : 'Tidak Aktif' }}
                                </span>
                            </h5>
                        </div>
                        
                        <div class="mb-4">
                            <label class="text-muted small fw-bold mb-2">
                                <i class="fas fa-calendar me-1"></i>Tanggal Dibuat
                            </label>
                            <p class="text-dark mb-0">
                                {{ $dpc->created_at->format('d F Y, H:i') }} WIB
                            </p>
                        </div>
                        
                        <div class="mb-4">
                            <label class="text-muted small fw-bold mb-2">
                                <i class="fas fa-calendar-check me-1"></i>Terakhir Diupdate
                            </label>
                            <p class="text-dark mb-0">
                                {{ $dpc->updated_at->format('d F Y, H:i') }} WIB
                            </p>
                        </div>
                    </div>
                    
                    <!-- Deskripsi Full Width -->
                    @if($dpc->deskripsi)
                    <div class="col-12 mt-3">
                        <label class="text-muted small fw-bold mb-2">
                            <i class="fas fa-align-left me-1"></i>Deskripsi
                        </label>
                        <div class="alert alert-light border" style="border-radius: 10px;">
                            {{ $dpc->deskripsi }}
                        </div>
                    </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>

<!-- Statistics Cards -->
<div class="row mb-4">
    <div class="col-md-6 mb-3">
        <div class="stats-box">
            <i class="fas fa-building fa-3x mb-3" style="opacity: 0.8;"></i>
            <div class="stats-number">{{ $dpc->upa()->count() }}</div>
            <div class="stats-label">Total UPA</div>
        </div>
    </div>
    <div class="col-md-6 mb-3">
        <div class="stats-box" style="background: linear-gradient(135deg, #4CAF50 0%, #45a049 100%);">
            <i class="fas fa-users fa-3x mb-3" style="opacity: 0.8;"></i>
            <div class="stats-number">{{ $dpc->anggota()->count() }}</div>
            <div class="stats-label">Total Anggota</div>
        </div>
    </div>
</div>

<!-- UPA List -->
<div class="row">
    <div class="col-12">
        <div class="card shadow-sm border-0">
            <div class="card-header bg-gradient-primary py-3">
                <h5 class="m-0 font-weight-bold text-white d-flex align-items-center">
                    <i class="fas fa-building me-2"></i>Daftar UPA di {{ $dpc->nama_dpc }}
                </h5>
            </div>
            <div class="card-body p-4">
                @if($dpc->upa()->count() > 0)
                    <div class="row">
                        @foreach($dpc->upa()->orderBy('nama_upa')->get() as $index => $upa)
                            <div class="col-md-6 mb-3">
                                <div class="upa-card">
                                    <div class="d-flex justify-content-between align-items-start mb-3">
                                        <div>
                                            <h5 class="text-dark mb-1 fw-bold">
                                                <i class="fas fa-building text-primary me-2"></i>{{ $upa->nama_upa }}
                                            </h5>
                                            <small class="text-muted">
                                                <i class="fas fa-barcode me-1"></i>{{ $upa->kode_upa }}
                                            </small>
                                        </div>
                                        <span class="badge bg-{{ $upa->status == 'Aktif' ? 'success' : 'secondary' }}">
                                            {{ $upa->status }}
                                        </span>
                                    </div>
                                    
                                    <hr class="my-2">
                                    
                                    <div class="row">
                                        <div class="col-6">
                                            <small class="text-muted d-block">
                                                <i class="fas fa-users me-1"></i>Anggota
                                            </small>
                                            <strong class="text-primary">
                                                {{ $upa->anggota()->count() }} orang
                                            </strong>
                                        </div>
                                        <div class="col-6">
                                            <small class="text-muted d-block">
                                                <i class="fas fa-user-tie me-1"></i>Pembimbing
                                            </small>
                                            <strong class="text-success">
                                                {{ $upa->pembimbingAktif()->count() }} orang
                                            </strong>
                                        </div>
                                    </div>
                                    
                                    @if($upa->alamat_lengkap)
                                        <div class="mt-3">
                                            <small class="text-muted">
                                                <i class="fas fa-map-marker-alt me-1"></i>
                                                {{ Str::limit($upa->alamat_lengkap, 50) }}
                                            </small>
                                        </div>
                                    @endif
                                    
                                    <div class="mt-3">
                                        <a href="{{ route('upa.show', $upa) }}" class="btn btn-sm btn-outline-primary">
                                            <i class="fas fa-eye me-1"></i>Lihat Detail
                                        </a>
                                    </div>
                                </div>
                            </div>
                        @endforeach
                    </div>
                @else
                    <div class="text-center py-5">
                        <i class="fas fa-inbox fa-4x text-muted mb-3"></i>
                        <h5 class="text-muted">Belum ada UPA di DPC ini</h5>
                        <p class="text-muted">Silakan tambahkan UPA baru untuk DPC {{ $dpc->nama_dpc }}</p>
                        <a href="{{ route('upa.create') }}" class="btn btn-primary mt-3">
                            <i class="fas fa-plus me-1"></i>Tambah UPA
                        </a>
                    </div>
                @endif
            </div>
        </div>
    </div>
</div>

<!-- Action Buttons -->
<div class="row mt-4">
    <div class="col-12">
        <div class="d-flex gap-2">
            <a href="{{ route('dpc.edit', $dpc) }}" class="btn btn-warning">
                <i class="fas fa-edit me-1"></i>Edit DPC
            </a>
            <a href="{{ route('dpc.index') }}" class="btn btn-secondary">
                <i class="fas fa-arrow-left me-1"></i>Kembali ke Daftar
            </a>
        </div>
    </div>
</div>

@endsection



