@extends('layouts.app')

@section('title', 'Data DPC')

@section('content')
<style>
/* Custom pagination styling untuk ukuran lebih kecil */
.pagination {
    font-size: 0.875rem;
    margin-bottom: 0;
}

.pagination .page-link {
    padding: 0.375rem 0.75rem;
    font-size: 0.875rem;
    border-radius: 0.375rem;
    margin: 0 0.125rem;
    border: 1px solid #dee2e6;
    color: #6c757d;
    text-decoration: none;
    transition: all 0.15s ease-in-out;
}

.pagination .page-link:hover {
    color: #0056b3;
    background-color: #e9ecef;
    border-color: #dee2e6;
}

.pagination .page-item.active .page-link {
    background-color: #007bff;
    border-color: #007bff;
    color: white;
}

.pagination .page-item.disabled .page-link {
    color: #6c757d;
    background-color: #fff;
    border-color: #dee2e6;
}

.pagination .page-item:first-child .page-link,
.pagination .page-item:last-child .page-link {
    border-radius: 0.375rem;
}

/* Gradient primary background */
.bg-gradient-primary {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
}

/* Mobile responsive table */
@media (max-width: 768px) {
    .table-responsive {
        border: none;
    }
    
    .table {
        font-size: 0.75rem;
    }
    
    .table th,
    .table td {
        padding: 0.375rem 0.25rem;
        white-space: nowrap;
    }
    
    .btn {
        font-size: 0.8rem;
        padding: 0.4rem 0.8rem;
    }
    
    .badge {
        font-size: 0.7rem;
        padding: 0.2rem 0.4rem;
    }
}
</style>

<!-- Page Header -->
<div class="d-flex flex-column flex-md-row justify-content-between align-items-start align-items-md-center mb-4">
    <div class="mb-3 mb-md-0">
        <h1 class="h2 fw-bold text-dark mb-2">
            <i class="fas fa-sitemap text-primary me-2"></i>Data DPC
        </h1>
        <p class="text-muted mb-0 fs-6">
            <i class="fas fa-info-circle me-1"></i>Kelola data Dewan Pimpinan Cabang
        </p>
    </div>
    <div class="d-flex flex-column flex-sm-row gap-2">
        <a href="{{ route('dpc.create') }}" class="btn btn-primary px-3" style="border-radius: 6px;">
            <i class="fas fa-plus me-1"></i>Tambah DPC
        </a>
    </div>
</div>

<!-- Filter & Search -->
<div class="card shadow-sm mb-4 border-0">
    <div class="card-header bg-gradient-primary py-3">
        <h6 class="m-0 font-weight-bold text-white d-flex align-items-center">
            <i class="fas fa-filter me-2"></i>Filter & Pencarian
        </h6>
    </div>
    <div class="card-body p-3">
        <form method="GET" action="{{ route('dpc.index') }}" id="filterForm">
            <!-- Row 1: Pencarian, DPD, Status -->
            <div class="row g-2 align-items-end">
                <div class="col-lg-4 col-md-6">
                    <label class="form-label fw-semibold text-dark small">
                        <i class="fas fa-search me-1 text-primary"></i>Pencarian
                    </label>
                    <input type="text" class="form-control" name="search" 
                           value="{{ request('search') }}" 
                           placeholder="Cari DPC..."
                           style="border-radius: 6px;">
                </div>
                <div class="col-lg-3 col-md-6">
                    <label class="form-label fw-semibold text-dark small">
                        <i class="fas fa-building me-1 text-primary"></i>DPD
                    </label>
                    <select class="form-select" name="dpd_id" style="border-radius: 6px;">
                        <option value="">Semua DPD</option>
                        @foreach($dpds as $dpd)
                            <option value="{{ $dpd->dpd_id }}" {{ request('dpd_id') == $dpd->dpd_id ? 'selected' : '' }}>
                                {{ $dpd->nama_dpd }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-lg-2 col-md-6">
                    <label class="form-label fw-semibold text-dark small">
                        <i class="fas fa-info-circle me-1 text-primary"></i>Status
                    </label>
                    <select class="form-select" name="status" style="border-radius: 6px;">
                        <option value="">Semua Status</option>
                        <option value="aktif" {{ request('status') == 'aktif' ? 'selected' : '' }}>Aktif</option>
                        <option value="tidak_aktif" {{ request('status') == 'tidak_aktif' ? 'selected' : '' }}>Tidak Aktif</option>
                    </select>
                </div>
                <div class="col-lg-3 col-md-6">
                    <div class="d-flex gap-2 justify-content-end">
                        <button type="submit" class="btn btn-primary px-3" style="border-radius: 6px;">
                            <i class="fas fa-search me-1"></i>Cari Data
                        </button>
                        <a href="{{ route('dpc.index') }}" class="btn btn-outline-secondary px-3" style="border-radius: 6px;">
                            <i class="fas fa-undo me-1"></i>Reset
                        </a>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<!-- Data Table -->
<div class="card shadow-sm border-0">
    <div class="card-header bg-gradient-primary py-4 d-flex justify-content-between align-items-center">
        <h6 class="m-0 font-weight-bold text-white d-flex align-items-center">
            <i class="fas fa-list me-2"></i>Daftar DPC
        </h6>
        <span class="badge bg-white text-primary fs-6 px-3 py-2" style="border-radius: 20px;">
            <i class="fas fa-sitemap me-1"></i>Total: {{ $dpcs->total() }} DPC
        </span>
    </div>
    <div class="card-body p-0">
        @if($dpcs->count() > 0)
            <div class="table-responsive">
                <table class="table table-hover mb-0" id="dataTable">
                    <thead class="table-light">
                        <tr>
                            <th class="text-center py-3" style="width: 60px;">
                                <i class="fas fa-hashtag me-1 text-primary"></i>No
                            </th>
                            <th class="py-3" style="width: 120px;">
                                <i class="fas fa-barcode me-1 text-primary"></i>Kode DPC
                            </th>
                            <th class="py-3">
                                <i class="fas fa-sitemap me-1 text-primary"></i>Nama DPC
                            </th>
                            <th class="text-center py-3" style="width: 150px;">
                                <i class="fas fa-building me-1 text-primary"></i>DPD
                            </th>
                            <th class="text-center py-3" style="width: 120px;">
                                <i class="fas fa-users me-1 text-primary"></i>Jumlah UPA
                            </th>
                            <th class="text-center py-3" style="width: 130px;">
                                <i class="fas fa-user-friends me-1 text-primary"></i>Jumlah Anggota
                            </th>
                            <th class="text-center py-3" style="width: 100px;">
                                <i class="fas fa-info-circle me-1 text-primary"></i>Status
                            </th>
                            <th class="text-center py-3" style="width: 150px;">
                                <i class="fas fa-cogs me-1 text-primary"></i>Aksi
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($dpcs as $index => $dpc)
                            <tr class="align-middle">
                                <td class="text-center">
                                    <span class="fw-bold text-muted fs-6">{{ $dpcs->firstItem() + $index }}.</span>
                                </td>
                                <td>
                                    <span class="badge bg-info text-white px-2 py-1" style="font-size: 0.85rem;">
                                        {{ $dpc->kode_dpc }}
                                    </span>
                                </td>
                                <td>
                                    <div class="fw-bold text-dark">{{ $dpc->nama_dpc }}</div>
                                    @if($dpc->deskripsi)
                                        <small class="text-muted">{{ Str::limit($dpc->deskripsi, 50) }}</small>
                                    @endif
                                </td>
                                <td class="text-center">
                                    @if($dpc->dpd)
                                        <span class="badge bg-secondary px-2 py-1" style="font-size: 0.85rem;">
                                            {{ $dpc->dpd->nama_dpd }}
                                        </span>
                                    @else
                                        <span class="text-muted">-</span>
                                    @endif
                                </td>
                                <td class="text-center">
                                    <span class="badge bg-primary px-2 py-1" style="font-size: 0.85rem;">
                                        {{ $dpc->upa()->count() }} UPA
                                    </span>
                                </td>
                                <td class="text-center">
                                    <span class="badge bg-success px-2 py-1" style="font-size: 0.85rem;">
                                        {{ $dpc->anggota()->count() }} Anggota
                                    </span>
                                </td>
                                <td class="text-center">
                                    <span class="badge bg-{{ $dpc->is_active ? 'success' : 'danger' }} px-2 py-1" style="font-size: 0.85rem;">
                                        {{ $dpc->is_active ? 'Aktif' : 'Tidak Aktif' }}
                                    </span>
                                </td>
                                <td class="text-center">
                                    <div class="btn-group" role="group">
                                        <a href="{{ route('dpc.show', $dpc) }}" 
                                           class="btn btn-info btn-sm" 
                                           title="Detail"
                                           style="border-radius: 4px 0 0 0;">
                                            <i class="fas fa-eye"></i>
                                        </a>
                                        <a href="{{ route('dpc.edit', $dpc) }}" 
                                           class="btn btn-warning btn-sm" 
                                           title="Edit"
                                           style="border-radius: 0;">
                                            <i class="fas fa-edit"></i>
                                        </a>
                                        <form action="{{ route('dpc.toggle-status', $dpc) }}" method="POST" class="d-inline">
                                            @csrf
                                            <button type="submit" 
                                                    class="btn btn-{{ $dpc->is_active ? 'secondary' : 'success' }} btn-sm" 
                                                    title="{{ $dpc->is_active ? 'Nonaktifkan' : 'Aktifkan' }}"
                                                    onclick="return confirm('Apakah Anda yakin ingin {{ $dpc->is_active ? 'menonaktifkan' : 'mengaktifkan' }} DPC ini?')"
                                                    style="border-radius: 0;">
                                                <i class="fas fa-{{ $dpc->is_active ? 'pause' : 'play' }}"></i>
                                            </button>
                                        </form>
                                        <form action="{{ route('dpc.destroy', $dpc) }}" method="POST" class="d-inline" 
                                              onsubmit="return confirm('Apakah Anda yakin ingin menghapus DPC ini? Data akan dihapus permanen!')">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" 
                                                    class="btn btn-danger btn-sm" 
                                                    title="Hapus"
                                                    style="border-radius: 0 4px 4px 0;">
                                                <i class="fas fa-trash"></i>
                                            </button>
                                        </form>
                                    </div>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
            
            <!-- Pagination -->
            @if($dpcs->hasPages())
                <div class="card-footer bg-white border-top">
                    <div class="d-flex justify-content-center">
                        {{ $dpcs->links() }}
                    </div>
                </div>
            @endif
        @else
            <div class="text-center py-5">
                <div class="mb-4">
                    <i class="fas fa-inbox fa-4x text-muted"></i>
                </div>
                <h5 class="text-muted mb-3">Tidak ada data DPC ditemukan</h5>
                @if(request('search') || request('status') || request('dpd_id'))
                    <p class="text-muted mb-3">Coba ubah filter pencarian Anda</p>
                    <a href="{{ route('dpc.index') }}" class="btn btn-outline-primary">
                        <i class="fas fa-undo me-1"></i>Reset Filter & Lihat Semua DPC
                    </a>
                @else
                    <p class="text-muted mb-3">Belum ada DPC yang terdaftar</p>
                    <a href="{{ route('dpc.create') }}" class="btn btn-primary">
                        <i class="fas fa-plus me-1"></i>Tambah DPC Pertama
                    </a>
                @endif
            </div>
        @endif
    </div>
</div>
@endsection
