@extends('layouts.app')

@section('title', 'Data Keanggotaan - ' . $anggota->nama_lengkap)

@section('content')
<div class="container-fluid">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h2 class="h3 mb-0 text-gray-800">
                        <i class="fas fa-users text-primary me-2"></i>
                        Data Keanggotaan
                    </h2>
                    <p class="text-muted mb-0">{{ $anggota->nama_lengkap }} ({{ $anggota->nomor_identitas_anggota }})</p>
                </div>
                <div>
                    <a href="{{ route('anggota.show', $anggota->id) }}" class="btn btn-outline-secondary me-2">
                        <i class="fas fa-arrow-left me-1"></i> Kembali ke Profil
                    </a>
                    <a href="{{ route('anggota.keanggotaan.edit', $anggota->id) }}" class="btn btn-primary">
                        <i class="fas fa-edit me-1"></i> Edit Data
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Data Keanggotaan Saat Ini -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card shadow">
                <div class="card-header bg-primary text-white">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-info-circle me-2"></i>
                        Data Keanggotaan Saat Ini
                    </h5>
                </div>
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label fw-bold text-muted">Jenjang Anggota</label>
                                <p class="form-control-plaintext">
                                    @if($anggota->refJenjang)
                                        <span class="badge bg-info">{{ $anggota->refJenjang->nama_jenjang }}</span>
                                    @else
                                        <span class="text-muted">-</span>
                                    @endif
                                </p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label fw-bold text-muted">Grup UPA</label>
                                <p class="form-control-plaintext">
                                    @if($anggota->refGrupUpa)
                                        <span class="badge bg-success">{{ $anggota->refGrupUpa->nama_grup_upa }}</span>
                                    @else
                                        <span class="text-muted">-</span>
                                    @endif
                                </p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label fw-bold text-muted">DPC</label>
                                <p class="form-control-plaintext">
                                    @if($anggota->dpc)
                                        {{ $anggota->dpc->nama_dpc }}
                                    @else
                                        <span class="text-muted">-</span>
                                    @endif
                                </p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label fw-bold text-muted">DPD</label>
                                <p class="form-control-plaintext">
                                    @if($anggota->dpd)
                                        {{ $anggota->dpd->nama_dpd }}
                                    @else
                                        <span class="text-muted">-</span>
                                    @endif
                                </p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label fw-bold text-muted">UPA</label>
                                <p class="form-control-plaintext">
                                    @if($anggota->upa)
                                        {{ $anggota->upa->nama_upa }} ({{ $anggota->upa->kode_upa }})
                                    @else
                                        <span class="text-muted">-</span>
                                    @endif
                                </p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label fw-bold text-muted">Status Keanggotaan</label>
                                <p class="form-control-plaintext">
                                    <span class="badge bg-{{ $anggota->getStatusBadgeClass() }}">
                                        {{ $anggota->status_keanggotaan }}
                                    </span>
                                </p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label fw-bold text-muted">Tanggal Bergabung</label>
                                <p class="form-control-plaintext">
                                    {{ $anggota->tanggal_bergabung ? $anggota->tanggal_bergabung->format('d/m/Y') : '-' }}
                                </p>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="mb-3">
                                <label class="form-label fw-bold text-muted">Terakhir Diperbarui</label>
                                <p class="form-control-plaintext">
                                    {{ $anggota->updated_at ? $anggota->updated_at->format('d/m/Y H:i') : '-' }}
                                </p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Filter History -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="card shadow">
                <div class="card-header">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-filter me-2"></i>
                        Filter History
                    </h5>
                </div>
                <div class="card-body">
                    <form id="filterForm" class="row g-3">
                        <div class="col-md-4">
                            <label for="start_date" class="form-label">Tanggal Mulai</label>
                            <input type="date" class="form-control" id="start_date" name="start_date">
                        </div>
                        <div class="col-md-4">
                            <label for="end_date" class="form-label">Tanggal Akhir</label>
                            <input type="date" class="form-control" id="end_date" name="end_date">
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">&nbsp;</label>
                            <div class="d-grid">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fas fa-search me-1"></i> Filter
                                </button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    <!-- History Data Keanggotaan -->
    <div class="row">
        <div class="col-12">
            <div class="card shadow">
                <div class="card-header d-flex justify-content-between align-items-center">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-history me-2"></i>
                        History Perubahan Data Keanggotaan
                    </h5>
                    <div>
                        <a href="{{ route('anggota.keanggotaan.export', $anggota->id) }}" class="btn btn-outline-success btn-sm">
                            <i class="fas fa-file-pdf me-1"></i> Export PDF
                        </a>
                    </div>
                </div>
                <div class="card-body">
                    <div id="historyTable">
                        @include('anggota.keanggotaan.partials.history-table', ['history' => $history])
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    // Filter form submission
    $('#filterForm').on('submit', function(e) {
        e.preventDefault();
        
        const startDate = $('#start_date').val();
        const endDate = $('#end_date').val();
        
        // Show loading
        $('#historyTable').html('<div class="text-center"><i class="fas fa-spinner fa-spin"></i> Memuat data...</div>');
        
        // AJAX request
        $.get('{{ route("anggota.keanggotaan.history", $anggota->id) }}', {
            start_date: startDate,
            end_date: endDate
        })
        .done(function(response) {
            $('#historyTable').html(response.html);
        })
        .fail(function() {
            $('#historyTable').html('<div class="alert alert-danger">Terjadi kesalahan saat memuat data.</div>');
        });
    });
    
    // Reset filter
    $('#resetFilter').on('click', function() {
        $('#filterForm')[0].reset();
        location.reload();
    });
});
</script>
@endpush
