@if($history->count() > 0)
    <div class="table-responsive">
        <table class="table table-hover">
            <thead class="table-light">
                <tr>
                    <th>No</th>
                    <th>Tanggal Perubahan</th>
                    <th>Jenjang</th>
                    <th>Grup UPA</th>
                    <th>DPC</th>
                    <th>DPD</th>
                    <th>UPA</th>
                    <th>Status</th>
                    <th>Keterangan</th>
                    <th>User</th>
                </tr>
            </thead>
            <tbody>
                @foreach($history as $index => $record)
                    <tr>
                        <td>{{ $history->firstItem() + $index }}</td>
                        <td>
                            <span class="badge bg-primary">
                                {{ $record->tanggal_perubahan_formatted }}
                            </span>
                        </td>
                        <td>
                            @if($record->refJenjang)
                                <span class="badge bg-info">{{ $record->refJenjang->nama_jenjang }}</span>
                            @else
                                <span class="text-muted">-</span>
                            @endif
                        </td>
                        <td>
                            @if($record->refGrupUpa)
                                <span class="badge bg-success">{{ $record->refGrupUpa->nama_grup_upa }}</span>
                            @else
                                <span class="text-muted">-</span>
                            @endif
                        </td>
                        <td>
                            @if($record->dpc)
                                {{ $record->dpc->nama_dpc }}
                            @else
                                <span class="text-muted">-</span>
                            @endif
                        </td>
                        <td>
                            @if($record->dpd)
                                {{ $record->dpd->nama_dpd }}
                            @else
                                <span class="text-muted">-</span>
                            @endif
                        </td>
                        <td>
                            @if($record->upa)
                                {{ $record->upa->nama_upa }}
                                @if($record->upa->kode_upa)
                                    <br><small class="text-muted">({{ $record->upa->kode_upa }})</small>
                                @endif
                            @else
                                <span class="text-muted">-</span>
                            @endif
                        </td>
                        <td>
                            @if($record->status_keanggotaan)
                                @php
                                    $statusClass = match($record->status_keanggotaan) {
                                        'Aktif' => 'success',
                                        'Tidak Aktif' => 'warning',
                                        'Diberhentikan' => 'danger',
                                        'Pindah' => 'info',
                                        default => 'secondary'
                                    };
                                @endphp
                                <span class="badge bg-{{ $statusClass }}">
                                    {{ $record->status_keanggotaan }}
                                </span>
                            @else
                                <span class="text-muted">-</span>
                            @endif
                        </td>
                        <td>
                            @if($record->keterangan)
                                <span title="{{ $record->keterangan }}">
                                    {{ $record->keterangan_singkat }}
                                </span>
                            @else
                                <span class="text-muted">-</span>
                            @endif
                        </td>
                        <td>
                            @if($record->user)
                                <small class="text-muted">{{ $record->user->name }}</small>
                            @else
                                <span class="text-muted">-</span>
                            @endif
                        </td>
                    </tr>
                @endforeach
            </tbody>
        </table>
    </div>
    
    <!-- Pagination -->
    @if($history->hasPages())
        <div class="d-flex justify-content-between align-items-center mt-3">
            <div class="text-muted">
                Menampilkan {{ $history->firstItem() }} - {{ $history->lastItem() }} dari {{ $history->total() }} data
            </div>
            <div>
                {{ $history->links() }}
            </div>
        </div>
    @endif
@else
    <div class="text-center py-5">
        <i class="fas fa-history fa-3x text-muted mb-3"></i>
        <h5 class="text-muted">Belum ada history perubahan</h5>
        <p class="text-muted">Data keanggotaan belum pernah diubah.</p>
    </div>
@endif
