<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>History Data Keanggotaan - {{ $anggota->nama_lengkap }}</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
            line-height: 1.4;
            margin: 0;
            padding: 20px;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #333;
            padding-bottom: 20px;
        }
        .header h1 {
            margin: 0;
            font-size: 18px;
            color: #333;
        }
        .header h2 {
            margin: 5px 0 0 0;
            font-size: 14px;
            color: #666;
            font-weight: normal;
        }
        .info-section {
            margin-bottom: 20px;
        }
        .info-section h3 {
            font-size: 14px;
            margin: 0 0 10px 0;
            color: #333;
            background: #f5f5f5;
            padding: 5px 10px;
        }
        .info-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 15px;
        }
        .info-table td {
            padding: 5px 10px;
            border: 1px solid #ddd;
        }
        .info-table td:first-child {
            background: #f9f9f9;
            font-weight: bold;
            width: 30%;
        }
        .history-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        .history-table th,
        .history-table td {
            padding: 8px;
            border: 1px solid #ddd;
            text-align: left;
            font-size: 10px;
        }
        .history-table th {
            background: #f5f5f5;
            font-weight: bold;
        }
        .history-table tr:nth-child(even) {
            background: #f9f9f9;
        }
        .badge {
            padding: 2px 6px;
            border-radius: 3px;
            font-size: 9px;
            font-weight: bold;
        }
        .badge-success { background: #d4edda; color: #155724; }
        .badge-info { background: #d1ecf1; color: #0c5460; }
        .badge-warning { background: #fff3cd; color: #856404; }
        .badge-danger { background: #f8d7da; color: #721c24; }
        .badge-primary { background: #cce5ff; color: #004085; }
        .text-center { text-align: center; }
        .text-muted { color: #666; }
        .page-break {
            page-break-before: always;
        }
        .footer {
            margin-top: 30px;
            text-align: center;
            font-size: 10px;
            color: #666;
            border-top: 1px solid #ddd;
            padding-top: 10px;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>HISTORY DATA KEANGGOTAAN</h1>
        <h2>{{ $anggota->nama_lengkap }} ({{ $anggota->nomor_identitas_anggota }})</h2>
    </div>

    <!-- Data Anggota Saat Ini -->
    <div class="info-section">
        <h3>Data Keanggotaan Saat Ini</h3>
        <table class="info-table">
            <tr>
                <td>Nama Lengkap</td>
                <td>{{ $anggota->nama_lengkap }}</td>
            </tr>
            <tr>
                <td>Nomor Identitas Anggota</td>
                <td>{{ $anggota->nomor_identitas_anggota }}</td>
            </tr>
            <tr>
                <td>Jenjang Anggota</td>
                <td>{{ $anggota->refJenjang ? $anggota->refJenjang->nama_jenjang : '-' }}</td>
            </tr>
            <tr>
                <td>Grup UPA</td>
                <td>{{ $anggota->refGrupUpa ? $anggota->refGrupUpa->nama_grup_upa : '-' }}</td>
            </tr>
            <tr>
                <td>DPC</td>
                <td>{{ $anggota->dpc ? $anggota->dpc->nama_dpc : '-' }}</td>
            </tr>
            <tr>
                <td>DPD</td>
                <td>{{ $anggota->dpd ? $anggota->dpd->nama_dpd : '-' }}</td>
            </tr>
            <tr>
                <td>UPA</td>
                <td>{{ $anggota->upa ? $anggota->upa->nama_upa . ' (' . $anggota->upa->kode_upa . ')' : '-' }}</td>
            </tr>
            <tr>
                <td>Status Keanggotaan</td>
                <td>{{ $anggota->status_keanggotaan }}</td>
            </tr>
            <tr>
                <td>Tanggal Bergabung</td>
                <td>{{ $anggota->tanggal_bergabung ? $anggota->tanggal_bergabung->format('d/m/Y') : '-' }}</td>
            </tr>
        </table>
    </div>

    <!-- History Perubahan -->
    <div class="info-section">
        <h3>History Perubahan Data Keanggotaan</h3>
        @if($history->count() > 0)
            <table class="history-table">
                <thead>
                    <tr>
                        <th style="width: 5%;">No</th>
                        <th style="width: 12%;">Tanggal</th>
                        <th style="width: 12%;">Jenjang</th>
                        <th style="width: 12%;">Grup UPA</th>
                        <th style="width: 12%;">DPC</th>
                        <th style="width: 12%;">DPD</th>
                        <th style="width: 12%;">UPA</th>
                        <th style="width: 10%;">Status</th>
                        <th style="width: 13%;">Keterangan</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($history as $index => $record)
                        <tr>
                            <td class="text-center">{{ $index + 1 }}</td>
                            <td>{{ $record->tanggal_perubahan_formatted }}</td>
                            <td>{{ $record->refJenjang ? $record->refJenjang->nama_jenjang : '-' }}</td>
                            <td>{{ $record->refGrupUpa ? $record->refGrupUpa->nama_grup_upa : '-' }}</td>
                            <td>{{ $record->dpc ? $record->dpc->nama_dpc : '-' }}</td>
                            <td>{{ $record->dpd ? $record->dpd->nama_dpd : '-' }}</td>
                            <td>
                                @if($record->upa)
                                    {{ $record->upa->nama_upa }}
                                    @if($record->upa->kode_upa)
                                        <br><small class="text-muted">({{ $record->upa->kode_upa }})</small>
                                    @endif
                                @else
                                    -
                                @endif
                            </td>
                            <td>
                                @if($record->status_keanggotaan)
                                    <span class="badge badge-{{ $record->status_keanggotaan == 'Aktif' ? 'success' : ($record->status_keanggotaan == 'Tidak Aktif' ? 'warning' : ($record->status_keanggotaan == 'Diberhentikan' ? 'danger' : 'info')) }}">
                                        {{ $record->status_keanggotaan }}
                                    </span>
                                @else
                                    -
                                @endif
                            </td>
                            <td>{{ $record->keterangan ?: '-' }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        @else
            <p class="text-muted">Belum ada history perubahan data keanggotaan.</p>
        @endif
    </div>

    <div class="footer">
        <p>Dokumen ini dibuat pada {{ now()->format('d/m/Y H:i') }}</p>
        <p>Sistem Informasi Manajemen Anggota PKS</p>
    </div>
</body>
</html>
