@extends('layouts.app')

@section('title', 'Edit Data Keanggotaan - ' . $anggota->nama_lengkap)

@section('content')
<div class="container-fluid">
    <!-- Header -->
    <div class="row mb-4">
        <div class="col-12">
            <div class="d-flex justify-content-between align-items-center">
                <div>
                    <h2 class="h3 mb-0 text-gray-800">
                        <i class="fas fa-edit text-primary me-2"></i>
                        Edit Data Keanggotaan
                    </h2>
                    <p class="text-muted mb-0">{{ $anggota->nama_lengkap }} ({{ $anggota->nomor_identitas_anggota }})</p>
                </div>
                <div>
                    <a href="{{ route('anggota.keanggotaan.show', $anggota->id) }}" class="btn btn-outline-secondary">
                        <i class="fas fa-arrow-left me-1"></i> Kembali
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Form Edit -->
    <div class="row">
        <div class="col-12">
            <div class="card shadow">
                <div class="card-header bg-primary text-white">
                    <h5 class="card-title mb-0">
                        <i class="fas fa-users me-2"></i>
                        Data Keanggotaan
                    </h5>
                </div>
                <div class="card-body">
                    <form action="{{ route('anggota.keanggotaan.update', $anggota->id) }}" method="POST" id="editForm">
                        @csrf
                        @method('PUT')
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="ref_jenjang_id" class="form-label">
                                        Jenjang Anggota <span class="text-danger">*</span>
                                    </label>
                                    <select class="form-select @error('ref_jenjang_id') is-invalid @enderror" 
                                            id="ref_jenjang_id" name="ref_jenjang_id">
                                        <option value="">Pilih Jenjang</option>
                                        @foreach($jenjangs as $jenjang)
                                            <option value="{{ $jenjang->ref_jenjang_id }}" 
                                                    {{ old('ref_jenjang_id', $anggota->ref_jenjang_id) == $jenjang->ref_jenjang_id ? 'selected' : '' }}>
                                                {{ $jenjang->jenjang }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('ref_jenjang_id')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            
                            
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="dpc_id" class="form-label">
                                        DPC <span class="text-danger">*</span>
                                    </label>
                                    <select class="form-select @error('dpc_id') is-invalid @enderror" 
                                            id="dpc_id" name="dpc_id">
                                        <option value="">Pilih DPC</option>
                                        @foreach($dpcs as $dpc)
                                            <option value="{{ $dpc->dpc_id }}" 
                                                    {{ old('dpc_id', $anggota->dpc_id) == $dpc->dpc_id ? 'selected' : '' }}>
                                                {{ $dpc->nama_dpc }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('dpc_id')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="dpd_id" class="form-label">
                                        DPD <span class="text-danger">*</span>
                                    </label>
                                    <select class="form-select @error('dpd_id') is-invalid @enderror" 
                                            id="dpd_id" name="dpd_id">
                                        <option value="">Pilih DPD</option>
                                        @foreach($dpds as $dpd)
                                            <option value="{{ $dpd->dpd_id }}" 
                                                    {{ old('dpd_id', $anggota->dpd_id) == $dpd->dpd_id ? 'selected' : '' }}>
                                                {{ $dpd->nama_dpd }}
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('dpd_id')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="upa_id" class="form-label">UPA</label>
                                    <select class="form-select @error('upa_id') is-invalid @enderror" 
                                            id="upa_id" name="upa_id">
                                        <option value="">Pilih UPA</option>
                                        @foreach($upas as $upa)
                                            <option value="{{ $upa->upa_id }}" 
                                                    {{ old('upa_id', $anggota->upa_id) == $upa->upa_id ? 'selected' : '' }}>
                                                {{ $upa->nama_upa }} ({{ $upa->kode_upa }})
                                            </option>
                                        @endforeach
                                    </select>
                                    @error('upa_id')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="status_keanggotaan" class="form-label">
                                        Status Keanggotaan <span class="text-danger">*</span>
                                    </label>
                                    <select class="form-select @error('status_keanggotaan') is-invalid @enderror" 
                                            id="status_keanggotaan" name="status_keanggotaan">
                                        <option value="">Pilih Status</option>
                                        <option value="Aktif" {{ old('status_keanggotaan', $anggota->status_keanggotaan) == 'Aktif' ? 'selected' : '' }}>Aktif</option>
                                        <option value="Tidak Aktif" {{ old('status_keanggotaan', $anggota->status_keanggotaan) == 'Tidak Aktif' ? 'selected' : '' }}>Tidak Aktif</option>
                                        <option value="Diberhentikan" {{ old('status_keanggotaan', $anggota->status_keanggotaan) == 'Diberhentikan' ? 'selected' : '' }}>Diberhentikan</option>
                                        <option value="Pindah" {{ old('status_keanggotaan', $anggota->status_keanggotaan) == 'Pindah' ? 'selected' : '' }}>Pindah</option>
                                    </select>
                                    @error('status_keanggotaan')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="tanggal_perubahan" class="form-label">
                                        Tanggal Perubahan <span class="text-danger">*</span>
                                    </label>
                                    <input type="date" 
                                           class="form-control @error('tanggal_perubahan') is-invalid @enderror" 
                                           id="tanggal_perubahan" 
                                           name="tanggal_perubahan" 
                                           value="{{ old('tanggal_perubahan', now()->format('Y-m-d')) }}">
                                    @error('tanggal_perubahan')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                            
                            <div class="col-md-6">
                                <div class="mb-3">
                                    <label for="keterangan" class="form-label">Keterangan Perubahan</label>
                                    <textarea class="form-control @error('keterangan') is-invalid @enderror" 
                                              id="keterangan" 
                                              name="keterangan" 
                                              rows="3" 
                                              placeholder="Masukkan keterangan perubahan...">{{ old('keterangan') }}</textarea>
                                    @error('keterangan')
                                        <div class="invalid-feedback">{{ $message }}</div>
                                    @enderror
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-12">
                                <div class="alert alert-info">
                                    <i class="fas fa-info-circle me-2"></i>
                                    <strong>Perhatian:</strong> Data lama akan disimpan dalam history sebelum data baru disimpan.
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-12">
                                <div class="d-flex justify-content-end gap-2">
                                    <a href="{{ route('anggota.keanggotaan.show', $anggota->id) }}" 
                                       class="btn btn-secondary">
                                        <i class="fas fa-times me-1"></i> Batal
                                    </a>
                                    <button type="submit" class="btn btn-primary">
                                        <i class="fas fa-save me-1"></i> Simpan Perubahan
                                    </button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

@push('scripts')
<script>
$(document).ready(function() {
    
    // Form validation
    $('#editForm').on('submit', function(e) {
        const requiredFields = ['ref_jenjang_id', 'dpc_id', 'dpd_id', 'status_keanggotaan', 'tanggal_perubahan'];
        let isValid = true;
        
        requiredFields.forEach(function(field) {
            const element = $(`#${field}`);
            if (!element.val()) {
                element.addClass('is-invalid');
                isValid = false;
            } else {
                element.removeClass('is-invalid');
            }
        });
        
        if (!isValid) {
            e.preventDefault();
            alert('Mohon lengkapi semua field yang wajib diisi.');
        }
    });
});
</script>
@endpush
