<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\YaumiyahActivity;

class YaumiyahActivitySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $activities = [
            [
                'name' => 'Mengelola UPA (sebagai mentor)',
                'description' => 'Aktivitas mengelola UPA sebagai mentor',
                'target_per_week' => 1,
                'unit' => 'kali',
                'is_active' => true,
                'sort_order' => 1
            ],
            [
                'name' => 'Shalat berjamaah di Masjid (maksimal 35 per pekan)',
                'description' => 'Shalat berjamaah di masjid dengan target maksimal 35 kali per pekan',
                'target_per_week' => 35,
                'unit' => 'kali',
                'is_active' => true,
                'sort_order' => 2
            ],
            [
                'name' => 'Tilawah, 7 Juz 1 Pekan',
                'description' => 'Membaca Al-Quran 7 juz dalam 1 pekan',
                'target_per_week' => 7,
                'unit' => 'juz',
                'is_active' => true,
                'sort_order' => 3
            ],
            [
                'name' => 'Qiyamul Lail, 7 x 1 Pekan',
                'description' => 'Shalat malam 7 kali dalam 1 pekan',
                'target_per_week' => 7,
                'unit' => 'kali',
                'is_active' => true,
                'sort_order' => 4
            ],
            [
                'name' => 'Wazhifah Kubro, 7 x 1 Pekan',
                'description' => 'Wazhifah Kubro 7 kali dalam 1 pekan',
                'target_per_week' => 7,
                'unit' => 'kali',
                'is_active' => true,
                'sort_order' => 5
            ],
            [
                'name' => 'Shaum Sunnah min 3 x 1 Bulan',
                'description' => 'Puasa sunnah minimal 3 kali dalam 1 bulan',
                'target_per_week' => 1,
                'unit' => 'kali',
                'is_active' => true,
                'sort_order' => 6
            ],
            [
                'name' => 'Dakwah Fardiyah / Rabthul Am',
                'description' => 'Dakwah individual atau hubungan dengan masyarakat',
                'target_per_week' => 1,
                'unit' => 'kali',
                'is_active' => true,
                'sort_order' => 7
            ],
            [
                'name' => 'Bersedekah 1 x 1 Pekan',
                'description' => 'Bersedekah 1 kali dalam 1 pekan',
                'target_per_week' => 1,
                'unit' => 'kali',
                'is_active' => true,
                'sort_order' => 8
            ],
            [
                'name' => 'Berolah raga 3 x 1 Pekan',
                'description' => 'Berolahraga 3 kali dalam 1 pekan',
                'target_per_week' => 3,
                'unit' => 'kali',
                'is_active' => true,
                'sort_order' => 9
            ],
            [
                'name' => 'Hafalan surat / ayat sesuai KKP',
                'description' => 'Hafalan surat atau ayat sesuai Kurikulum Kaderisasi PKS',
                'target_per_week' => 1,
                'unit' => 'surat',
                'is_active' => true,
                'sort_order' => 10
            ]
        ];

        foreach ($activities as $activity) {
            YaumiyahActivity::create($activity);
        }
    }
}