<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Upa;
use App\Models\Anggota;

class UpaSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Data UPA contoh
        $upas = [
            [
                'kode_upa' => 'UPA001',
                'nama_upa' => 'UPA Cakung',
                'deskripsi' => 'Unit Pengembangan Anggota Cakung, Jakarta Timur',
                'alamat' => 'Jl. Raya Cakung No. 123',
                'kota' => 'Jakarta Timur',
                'provinsi' => 'DKI Jakarta',
                'kode_pos' => '13910',
                'no_telepon' => '021-1234567',
                'email' => 'upa.cakung@pks.or.id',
                'tanggal_berdiri' => '2020-01-15',
                'status' => 'Aktif',
                'catatan' => 'UPA pertama di Jakarta Timur'
            ],
            [
                'kode_upa' => 'UPA002',
                'nama_upa' => 'UPA Jatinegara',
                'deskripsi' => 'Unit Pengembangan Anggota Jatinegara, Jakarta Timur',
                'alamat' => 'Jl. Raya Jatinegara No. 456',
                'kota' => 'Jakarta Timur',
                'provinsi' => 'DKI Jakarta',
                'kode_pos' => '13310',
                'no_telepon' => '021-2345678',
                'email' => 'upa.jatinegara@pks.or.id',
                'tanggal_berdiri' => '2020-03-20',
                'status' => 'Aktif',
                'catatan' => 'UPA kedua di Jakarta Timur'
            ],
            [
                'kode_upa' => 'UPA003',
                'nama_upa' => 'UPA Pulo Gadung',
                'deskripsi' => 'Unit Pengembangan Anggota Pulo Gadung, Jakarta Timur',
                'alamat' => 'Jl. Raya Pulo Gadung No. 789',
                'kota' => 'Jakarta Timur',
                'provinsi' => 'DKI Jakarta',
                'kode_pos' => '13220',
                'no_telepon' => '021-3456789',
                'email' => 'upa.pulogadung@pks.or.id',
                'tanggal_berdiri' => '2020-06-10',
                'status' => 'Aktif',
                'catatan' => 'UPA ketiga di Jakarta Timur'
            ]
        ];

        foreach ($upas as $upaData) {
            $upa = Upa::create($upaData);
            
            // Ambil beberapa anggota untuk menjadi pembimbing
            $anggotaList = Anggota::where('status_keanggotaan', 'Aktif')->take(3)->get();
            
            if ($anggotaList->count() > 0) {
                // Ketua
                $upa->pembimbing()->attach($anggotaList[0]->id, [
                    'jabatan' => 'Ketua',
                    'tanggal_mulai' => $upa->tanggal_berdiri,
                    'status' => 'Aktif',
                    'catatan' => 'Ketua UPA ' . $upa->nama_upa
                ]);
                
                // Wakil Ketua (jika ada anggota kedua)
                if ($anggotaList->count() > 1) {
                    $upa->pembimbing()->attach($anggotaList[1]->id, [
                        'jabatan' => 'Wakil Ketua',
                        'tanggal_mulai' => $upa->tanggal_berdiri,
                        'status' => 'Aktif',
                        'catatan' => 'Wakil Ketua UPA ' . $upa->nama_upa
                    ]);
                }
                
                // Sekretaris (jika ada anggota ketiga)
                if ($anggotaList->count() > 2) {
                    $upa->pembimbing()->attach($anggotaList[2]->id, [
                        'jabatan' => 'Sekretaris',
                        'tanggal_mulai' => $upa->tanggal_berdiri,
                        'status' => 'Aktif',
                        'catatan' => 'Sekretaris UPA ' . $upa->nama_upa
                    ]);
                }
            }
        }
    }
}