<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Upa;
use App\Models\Dpc;
use Illuminate\Support\Facades\DB;

class UpaComprehensiveSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Ambil semua DPC
        $dpcList = Dpc::all();

        if ($dpcList->isEmpty()) {
            $this->command->warn('Tidak ada DPC ditemukan! Jalankan DpcSeeder terlebih dahulu.');
            return;
        }

        // Hapus semua UPA yang ada (optional - uncomment jika ingin reset)
        // Upa::truncate();
        // DB::table('tbl_upa_pembimbing')->truncate();

        $this->command->info("Membuat 4 UPA untuk setiap DPC...");

        $upaCounter = 1;

        foreach ($dpcList as $dpc) {
            $this->command->info("Membuat UPA untuk DPC: {$dpc->nama_dpc}");

            for ($i = 1; $i <= 4; $i++) {
                $kodeUpa = 'UPA-' . $dpc->kode_dpc . '-' . str_pad($i, 3, '0', STR_PAD_LEFT);
                
                // Generate nama UPA berdasarkan DPC
                $namaUpa = $this->generateNamaUpa($dpc->nama_dpc, $i);

                // Skip jika UPA sudah ada
                if (Upa::where('kode_upa', $kodeUpa)->exists()) {
                    $this->command->warn("  ↳ UPA {$kodeUpa} sudah ada, skip...");
                    $upaCounter++;
                    continue;
                }

                Upa::create([
                    'kode_upa' => $kodeUpa,
                    'nama_upa' => $namaUpa,
                    'deskripsi' => "Unit Pengembangan Anggota {$namaUpa}",
                    'alamat' => "Jl. {$dpc->nama_dpc} No. " . ($i * 10),
                    'kota' => 'Jakarta Timur',
                    'provinsi' => 'DKI Jakarta',
                    'kode_pos' => '13' . str_pad($upaCounter, 3, '0', STR_PAD_LEFT),
                    'no_telepon' => '021-' . str_pad($upaCounter, 7, '0', STR_PAD_LEFT),
                    'email' => strtolower(str_replace(' ', '', $namaUpa)) . '@pks.or.id',
                    'tanggal_berdiri' => now()->subYears(rand(1, 5))->format('Y-m-d'),
                    'status' => 'Aktif',
                    'catatan' => "UPA ke-{$i} di DPC {$dpc->nama_dpc}",
                    'dpc_id' => $dpc->dpc_id,
                    'provinsi_id' => 1, // DKI Jakarta
                    'kota_id' => 5, // Jakarta Timur
                ]);

                $this->command->info("  ✓ {$kodeUpa} - {$namaUpa}");

                $upaCounter++;
            }
        }

        $this->command->info("✓ Berhasil membuat " . ($upaCounter - 1) . " UPA untuk " . $dpcList->count() . " DPC");
    }

    /**
     * Generate nama UPA berdasarkan DPC
     */
    private function generateNamaUpa($namaDpc, $nomor)
    {
        $variants = [
            'Utara',
            'Selatan',
            'Barat',
            'Timur',
        ];

        return "UPA {$namaDpc} {$variants[$nomor - 1]}";
    }
}

