<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Upa;
use App\Models\Anggota;

class UpaAnggotaSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Ambil beberapa UPA yang ada
        $upas = Upa::where('status', 'Aktif')->take(3)->get();
        
        if ($upas->count() == 0) {
            $this->command->info('Tidak ada UPA aktif ditemukan. Membuat UPA sample...');
            
            // Buat UPA sample
            $upa = Upa::create([
                'kode_upa' => 'UPA001',
                'nama_upa' => 'UPA Cakung',
                'deskripsi' => 'Unit Pelaksana Anggota Cakung',
                'alamat' => 'Jl. Raya Cakung No. 1',
                'dpc_id' => 1,
                'provinsi_id' => 1,
                'kota_id' => 1,
                'kecamatan_id' => 1,
                'kelurahan_id' => 1,
                'status' => 'Aktif'
            ]);
            $upas = collect([$upa]);
        }

        // Ambil beberapa anggota yang belum memiliki UPA
        $anggota = Anggota::whereNull('upa_id')
                          ->where('status_keanggotaan', 'Aktif')
                          ->take(10)
                          ->get();

        if ($anggota->count() == 0) {
            $this->command->info('Tidak ada anggota tanpa UPA ditemukan. Membuat anggota sample...');
            
            // Buat anggota sample
            $anggota = collect();
            for ($i = 1; $i <= 5; $i++) {
                $anggota->push(Anggota::create([
                    'nomor_identitas_anggota' => 'NIA' . str_pad($i, 6, '0', STR_PAD_LEFT),
                    'nama_lengkap' => 'Anggota UPA ' . $i,
                    'tempat_lahir' => 'Jakarta',
                    'tanggal_lahir' => '1990-01-01',
                    'jenis_kelamin' => 'Laki-laki',
                    'alamat_jalan' => 'Jl. Contoh No. ' . $i,
                    'rt' => '001',
                    'rw' => '001',
                    'kelurahan' => 'Kelurahan Contoh',
                    'kecamatan' => 'Kecamatan Contoh',
                    'kota' => 'Jakarta',
                    'provinsi' => 'DKI Jakarta',
                    'no_telepon' => '0812345678' . $i,
                    'email' => 'anggota' . $i . '@example.com',
                    'status_keanggotaan' => 'Aktif',
                    'tanggal_bergabung' => now()->subDays(30),
                    'dpc_id' => 1,
                    'dpd_id' => 1
                ]));
            }
        }

        // Assign anggota ke UPA
        $anggotaPerUpa = ceil($anggota->count() / $upas->count());
        $anggotaChunks = $anggota->chunk($anggotaPerUpa);

        foreach ($upas as $index => $upa) {
            if (isset($anggotaChunks[$index])) {
                $anggotaChunk = $anggotaChunks[$index];
                foreach ($anggotaChunk as $ang) {
                    $ang->update(['upa_id' => $upa->upa_id]);
                }
                $this->command->info("Assigned {$anggotaChunk->count()} anggota ke UPA {$upa->nama_upa}");
            }
        }

        $this->command->info('UPA Anggota seeding completed!');
    }
}
