<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\UpaAgendaMaster;

class UpaAgendaMasterSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $agendas = [
            [
                'nama_agenda' => 'Pembahasan Materi Keislaman',
                'deskripsi' => 'Diskusi dan pembelajaran tentang dasar-dasar keislaman',
                'is_active' => true
            ],
            [
                'nama_agenda' => 'Pembahasan Materi Kepartaian',
                'deskripsi' => 'Pembelajaran tentang ideologi dan platform partai',
                'is_active' => true
            ],
            [
                'nama_agenda' => 'Pembahasan Materi Organisasi',
                'deskripsi' => 'Pembelajaran tentang struktur dan tata kelola organisasi',
                'is_active' => true
            ],
            [
                'nama_agenda' => 'Pembahasan Materi Kepemimpinan',
                'deskripsi' => 'Pembelajaran tentang prinsip-prinsip kepemimpinan',
                'is_active' => true
            ],
            [
                'nama_agenda' => 'Pembahasan Materi Komunikasi',
                'deskripsi' => 'Pembelajaran tentang teknik komunikasi efektif',
                'is_active' => true
            ],
            [
                'nama_agenda' => 'Pembahasan Materi Manajemen',
                'deskripsi' => 'Pembelajaran tentang manajemen organisasi dan proyek',
                'is_active' => true
            ],
            [
                'nama_agenda' => 'Pembahasan Materi Sosial Kemasyarakatan',
                'deskripsi' => 'Pembelajaran tentang isu-isu sosial dan kemasyarakatan',
                'is_active' => true
            ],
            [
                'nama_agenda' => 'Pembahasan Materi Politik',
                'deskripsi' => 'Pembelajaran tentang sistem politik dan demokrasi',
                'is_active' => true
            ],
            [
                'nama_agenda' => 'Pembahasan Materi Ekonomi',
                'deskripsi' => 'Pembelajaran tentang ekonomi syariah dan kesejahteraan',
                'is_active' => true
            ],
            [
                'nama_agenda' => 'Pembahasan Materi Hukum',
                'deskripsi' => 'Pembelajaran tentang hukum dan perundang-undangan',
                'is_active' => true
            ],
            [
                'nama_agenda' => 'Pembahasan Materi Teknologi',
                'deskripsi' => 'Pembelajaran tentang pemanfaatan teknologi dalam organisasi',
                'is_active' => true
            ],
            [
                'nama_agenda' => 'Pembahasan Materi Media',
                'deskripsi' => 'Pembelajaran tentang komunikasi media dan publikasi',
                'is_active' => true
            ],
            [
                'nama_agenda' => 'Pembahasan Materi Lingkungan',
                'deskripsi' => 'Pembelajaran tentang isu lingkungan dan keberlanjutan',
                'is_active' => true
            ],
            [
                'nama_agenda' => 'Pembahasan Materi Pendidikan',
                'deskripsi' => 'Pembelajaran tentang sistem pendidikan dan pengembangan SDM',
                'is_active' => true
            ],
            [
                'nama_agenda' => 'Pembahasan Materi Kesehatan',
                'deskripsi' => 'Pembelajaran tentang isu kesehatan masyarakat',
                'is_active' => true
            ],
            [
                'nama_agenda' => 'Pembahasan Materi Pertahanan',
                'deskripsi' => 'Pembelajaran tentang pertahanan dan keamanan nasional',
                'is_active' => true
            ],
            [
                'nama_agenda' => 'Pembahasan Materi Kebudayaan',
                'deskripsi' => 'Pembelajaran tentang kebudayaan dan nilai-nilai luhur bangsa',
                'is_active' => true
            ],
            [
                'nama_agenda' => 'Pembahasan Materi Internasional',
                'deskripsi' => 'Pembelajaran tentang hubungan internasional dan geopolitik',
                'is_active' => true
            ],
            [
                'nama_agenda' => 'Pembahasan Materi Kaderisasi',
                'deskripsi' => 'Pembelajaran tentang sistem kaderisasi dan regenerasi',
                'is_active' => true
            ],
            [
                'nama_agenda' => 'Pembahasan Materi Strategi',
                'deskripsi' => 'Pembelajaran tentang perencanaan strategis dan taktis',
                'is_active' => true
            ]
        ];

        // Bulk insert untuk performa yang lebih baik
        UpaAgendaMaster::insert($agendas);
    }
}
