<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Anggota;
use App\Models\Upa;
use App\Models\Dpc;
use App\Models\Dpd;
use App\Models\RefJenjang;
use App\Models\RefGrupUpa;
use Carbon\Carbon;

class SimpleDemoSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run()
    {
        // Buat DPD Jakarta Timur
        $dpd = Dpd::firstOrCreate(
            ['dpd_id' => 1],
            [
                'nama_dpd' => 'DPD PKS Jakarta Timur',
                'alamat' => 'Jakarta Timur',
                'is_active' => true
            ]
        );

        // Buat DPC
        $dpcList = [
            ['dpc_id' => 1, 'nama_dpc' => 'DPC Cipayung', 'dpd_id' => 1, 'is_active' => true],
            ['dpc_id' => 2, 'nama_dpc' => 'DPC Kramat Jati', 'dpd_id' => 1, 'is_active' => true],
            ['dpc_id' => 3, 'nama_dpc' => 'DPC Jatinegara', 'dpd_id' => 1, 'is_active' => true]
        ];

        foreach ($dpcList as $dpcData) {
            Dpc::firstOrCreate(['dpc_id' => $dpcData['dpc_id']], $dpcData);
        }

        // Buat RefJenjang
        $jenjangList = [
            ['ref_jenjang_id' => 1, 'jenjang' => 'Kader'],
            ['ref_jenjang_id' => 2, 'jenjang' => 'Madya'],
            ['ref_jenjang_id' => 3, 'jenjang' => 'Utama']
        ];

        foreach ($jenjangList as $jenjang) {
            RefJenjang::firstOrCreate(['ref_jenjang_id' => $jenjang['ref_jenjang_id']], $jenjang);
        }

        // Buat RefGrupUpa
        $grupUpaList = [
            ['ref_grup_upa_id' => 1, 'nama_grup_upa' => 'Grup A'],
            ['ref_grup_upa_id' => 2, 'nama_grup_upa' => 'Grup B']
        ];

        foreach ($grupUpaList as $grup) {
            RefGrupUpa::firstOrCreate(['ref_grup_upa_id' => $grup['ref_grup_upa_id']], $grup);
        }

        // Buat UPA
        $upaList = [
            ['upa_id' => 1, 'kode_upa' => 'UPA-CIP-001', 'nama_upa' => 'UPA Cipayung Utara', 'dpc_id' => 1, 'status' => 'Aktif'],
            ['upa_id' => 2, 'kode_upa' => 'UPA-CIP-002', 'nama_upa' => 'UPA Cipayung Selatan', 'dpc_id' => 1, 'status' => 'Aktif'],
            ['upa_id' => 3, 'kode_upa' => 'UPA-KRJ-001', 'nama_upa' => 'UPA Kramat Jati Pusat', 'dpc_id' => 2, 'status' => 'Aktif'],
            ['upa_id' => 4, 'kode_upa' => 'UPA-KRJ-002', 'nama_upa' => 'UPA Kramat Jati Timur', 'dpc_id' => 2, 'status' => 'Aktif'],
            ['upa_id' => 5, 'kode_upa' => 'UPA-JTG-001', 'nama_upa' => 'UPA Jatinegara Utara', 'dpc_id' => 3, 'status' => 'Aktif']
        ];

        foreach ($upaList as $upaData) {
            Upa::firstOrCreate(['upa_id' => $upaData['upa_id']], $upaData);
        }

        // Buat Anggota minimal
        $anggotaList = [
            [
                'nomor_identitas_anggota' => 'PKS001',
                'nama_lengkap' => 'Ahmad Yani',
                'tempat_lahir' => 'Jakarta',
                'tanggal_lahir' => '1985-01-15',
                'jenis_kelamin' => 'Laki-laki',
                'alamat_jalan' => 'Jl. Cipayung Raya No. 1',
                'rt' => '001',
                'rw' => '001',
                'kota' => 'Jakarta Timur',
                'provinsi' => 'DKI Jakarta',
                'no_telepon' => '081234567890',
                'email' => 'ahmad.yani@example.com',
                'ref_jenjang_id' => 1,
                'ref_grup_upa_id' => 1,
                'dpc_id' => 1,
                'dpd_id' => 1,
                'tanggal_bergabung' => '2020-01-01',
                'status_keanggotaan' => 'Aktif'
            ],
            [
                'nomor_identitas_anggota' => 'PKS002',
                'nama_lengkap' => 'Siti Nurhaliza',
                'tempat_lahir' => 'Jakarta',
                'tanggal_lahir' => '1990-03-20',
                'jenis_kelamin' => 'Perempuan',
                'alamat_jalan' => 'Jl. Cipayung Raya No. 2',
                'rt' => '002',
                'rw' => '001',
                'kota' => 'Jakarta Timur',
                'provinsi' => 'DKI Jakarta',
                'no_telepon' => '081234567891',
                'email' => 'siti.nurhaliza@example.com',
                'ref_jenjang_id' => 2,
                'ref_grup_upa_id' => 1,
                'dpc_id' => 1,
                'dpd_id' => 1,
                'tanggal_bergabung' => '2020-02-01',
                'status_keanggotaan' => 'Aktif'
            ],
            [
                'nomor_identitas_anggota' => 'PKS003',
                'nama_lengkap' => 'Budi Santoso',
                'tempat_lahir' => 'Jakarta',
                'tanggal_lahir' => '1988-05-10',
                'jenis_kelamin' => 'Laki-laki',
                'alamat_jalan' => 'Jl. Kramat Jati Raya No. 1',
                'rt' => '001',
                'rw' => '002',
                'kota' => 'Jakarta Timur',
                'provinsi' => 'DKI Jakarta',
                'no_telepon' => '081234567892',
                'email' => 'budi.santoso@example.com',
                'ref_jenjang_id' => 2,
                'ref_grup_upa_id' => 2,
                'dpc_id' => 2,
                'dpd_id' => 1,
                'tanggal_bergabung' => '2020-03-01',
                'status_keanggotaan' => 'Aktif'
            ],
            [
                'nomor_identitas_anggota' => 'PKS004',
                'nama_lengkap' => 'Dewi Sartika',
                'tempat_lahir' => 'Jakarta',
                'tanggal_lahir' => '1992-07-25',
                'jenis_kelamin' => 'Perempuan',
                'alamat_jalan' => 'Jl. Kramat Jati Raya No. 2',
                'rt' => '002',
                'rw' => '002',
                'kota' => 'Jakarta Timur',
                'provinsi' => 'DKI Jakarta',
                'no_telepon' => '081234567893',
                'email' => 'dewi.sartika@example.com',
                'ref_jenjang_id' => 1,
                'ref_grup_upa_id' => 2,
                'dpc_id' => 2,
                'dpd_id' => 1,
                'tanggal_bergabung' => '2020-04-01',
                'status_keanggotaan' => 'Aktif'
            ],
            [
                'nomor_identitas_anggota' => 'PKS005',
                'nama_lengkap' => 'Rudi Hartono',
                'tempat_lahir' => 'Jakarta',
                'tanggal_lahir' => '1987-09-12',
                'jenis_kelamin' => 'Laki-laki',
                'alamat_jalan' => 'Jl. Jatinegara Raya No. 1',
                'rt' => '001',
                'rw' => '003',
                'kota' => 'Jakarta Timur',
                'provinsi' => 'DKI Jakarta',
                'no_telepon' => '081234567894',
                'email' => 'rudi.hartono@example.com',
                'ref_jenjang_id' => 3,
                'ref_grup_upa_id' => 1,
                'dpc_id' => 3,
                'dpd_id' => 1,
                'tanggal_bergabung' => '2020-05-01',
                'status_keanggotaan' => 'Aktif'
            ]
        ];

        foreach ($anggotaList as $anggotaData) {
            Anggota::firstOrCreate(
                ['nomor_identitas_anggota' => $anggotaData['nomor_identitas_anggota']],
                $anggotaData
            );
        }

        $this->command->info('Demo data berhasil diinsert!');
        $this->command->info('Total DPC: ' . count($dpcList));
        $this->command->info('Total UPA: ' . count($upaList));
        $this->command->info('Total Anggota: ' . count($anggotaList));
    }
}
