<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\RefKeahlian;

class RefKeahlianSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $keahlianData = [
            [
                'nama_keahlian' => 'Akuntansi',
                'deskripsi' => 'Keahlian dalam bidang akuntansi dan keuangan',
                'is_active' => true
            ],
            [
                'nama_keahlian' => 'Hukum',
                'deskripsi' => 'Keahlian dalam bidang hukum dan perundang-undangan',
                'is_active' => true
            ],
            [
                'nama_keahlian' => 'Psikologi',
                'deskripsi' => 'Keahlian dalam bidang psikologi dan konseling',
                'is_active' => true
            ],
            [
                'nama_keahlian' => 'Agama',
                'deskripsi' => 'Keahlian dalam bidang agama dan keagamaan',
                'is_active' => true
            ],
            [
                'nama_keahlian' => 'Teknologi Informasi',
                'deskripsi' => 'Keahlian dalam bidang teknologi informasi dan komputer',
                'is_active' => true
            ],
            [
                'nama_keahlian' => 'Komunikasi',
                'deskripsi' => 'Keahlian dalam bidang komunikasi dan media',
                'is_active' => true
            ],
            [
                'nama_keahlian' => 'Pendidikan',
                'deskripsi' => 'Keahlian dalam bidang pendidikan dan pengajaran',
                'is_active' => true
            ],
            [
                'nama_keahlian' => 'Kesehatan',
                'deskripsi' => 'Keahlian dalam bidang kesehatan dan medis',
                'is_active' => true
            ],
            [
                'nama_keahlian' => 'Manajemen',
                'deskripsi' => 'Keahlian dalam bidang manajemen dan administrasi',
                'is_active' => true
            ],
            [
                'nama_keahlian' => 'Pertanian',
                'deskripsi' => 'Keahlian dalam bidang pertanian dan perkebunan',
                'is_active' => true
            ]
        ];

        foreach ($keahlianData as $keahlian) {
            RefKeahlian::create($keahlian);
        }
    }
}
