<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\RefGrupUpa;

class RefGrupUpaSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $grupUpaData = [
            [
                'nama_grup_upa' => 'UPA Al-Furqan',
                'deskripsi' => 'Unit Pembinaan Anggota Al-Furqan - Fokus pada pembinaan keagamaan dan dakwah',
                'alamat' => 'Jl. Merdeka No. 123, Jakarta Pusat',
                'koordinator' => 'Ust. Ahmad Hidayat',
                'is_active' => true
            ],
            [
                'nama_grup_upa' => 'UPA Al-Ikhlas',
                'deskripsi' => 'Unit Pembinaan Anggota Al-Ikhlas - Pembinaan karakter dan kepemimpinan',
                'alamat' => 'Jl. Sudirman No. 456, Jakarta Selatan',
                'koordinator' => 'Ust. Muhammad Rizki',
                'is_active' => true
            ],
            [
                'nama_grup_upa' => 'UPA Al-Mujahidin',
                'deskripsi' => 'Unit Pembinaan Anggota Al-Mujahidin - Pembinaan aktivis dan penggerak',
                'alamat' => 'Jl. Thamrin No. 789, Jakarta Pusat',
                'koordinator' => 'Ust. Abdullah Rahman',
                'is_active' => true
            ],
            [
                'nama_grup_upa' => 'UPA Al-Falah',
                'deskripsi' => 'Unit Pembinaan Anggota Al-Falah - Pembinaan ekonomi dan kewirausahaan',
                'alamat' => 'Jl. Gatot Subroto No. 321, Jakarta Selatan',
                'koordinator' => 'Ust. Yusuf Al-Makmun',
                'is_active' => true
            ],
            [
                'nama_grup_upa' => 'UPA Al-Munawwarah',
                'deskripsi' => 'Unit Pembinaan Anggota Al-Munawwarah - Pembinaan keluarga dan masyarakat',
                'alamat' => 'Jl. Kebon Jeruk No. 654, Jakarta Barat',
                'koordinator' => 'Ust. Fatimah Az-Zahra',
                'is_active' => true
            ],
            [
                'nama_grup_upa' => 'UPA Al-Mustaqim',
                'deskripsi' => 'Unit Pembinaan Anggota Al-Mustaqim - Pembinaan pemuda dan mahasiswa',
                'alamat' => 'Jl. Diponegoro No. 987, Jakarta Pusat',
                'koordinator' => 'Ust. Ibrahim Al-Hakim',
                'is_active' => true
            ]
        ];

        foreach ($grupUpaData as $grupUpa) {
            RefGrupUpa::create($grupUpa);
        }
    }
}
