<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\RefProvinsi;
use App\Models\RefKota;
use App\Models\RefKecamatan;
use App\Models\RefKelurahan;

class RefAlamatSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Sample data untuk demo
        $this->seedProvinsi();
        $this->seedKota();
        $this->seedKecamatan();
        $this->seedKelurahan();
    }

    private function seedProvinsi()
    {
        $provinsi = [
            ['kode_provinsi' => '31', 'nama_provinsi' => 'DKI Jakarta'],
            ['kode_provinsi' => '32', 'nama_provinsi' => 'Jawa Barat'],
            ['kode_provinsi' => '33', 'nama_provinsi' => 'Jawa Tengah'],
            ['kode_provinsi' => '34', 'nama_provinsi' => 'DI Yogyakarta'],
            ['kode_provinsi' => '35', 'nama_provinsi' => 'Jawa Timur'],
            ['kode_provinsi' => '36', 'nama_provinsi' => 'Banten'],
        ];

        foreach ($provinsi as $p) {
            RefProvinsi::create($p);
        }
    }

    private function seedKota()
    {
        $kota = [
            // DKI Jakarta - Data lengkap sesuai tabel yang diberikan
            ['kode_kota' => '3101', 'nama_kota' => 'Kab. Kepulauan Seribu', 'provinsi_id' => 1, 'tipe' => 'Kabupaten'],
            ['kode_kota' => '3173', 'nama_kota' => 'Kota Jakarta Barat', 'provinsi_id' => 1, 'tipe' => 'Kota'],
            ['kode_kota' => '3171', 'nama_kota' => 'Kota Jakarta Pusat', 'provinsi_id' => 1, 'tipe' => 'Kota'],
            ['kode_kota' => '3174', 'nama_kota' => 'Kota Jakarta Selatan', 'provinsi_id' => 1, 'tipe' => 'Kota'],
            ['kode_kota' => '3175', 'nama_kota' => 'Kota Jakarta Timur', 'provinsi_id' => 1, 'tipe' => 'Kota'],
            ['kode_kota' => '3172', 'nama_kota' => 'Kota Jakarta Utara', 'provinsi_id' => 1, 'tipe' => 'Kota'],
            
            // Jawa Barat
            ['kode_kota' => '3201', 'nama_kota' => 'Bogor', 'provinsi_id' => 2, 'tipe' => 'Kabupaten'],
            ['kode_kota' => '3271', 'nama_kota' => 'Kota Bogor', 'provinsi_id' => 2, 'tipe' => 'Kota'],
            ['kode_kota' => '3202', 'nama_kota' => 'Sukabumi', 'provinsi_id' => 2, 'tipe' => 'Kabupaten'],
            ['kode_kota' => '3272', 'nama_kota' => 'Kota Sukabumi', 'provinsi_id' => 2, 'tipe' => 'Kota'],
            ['kode_kota' => '3203', 'nama_kota' => 'Cianjur', 'provinsi_id' => 2, 'tipe' => 'Kabupaten'],
            
            // Jawa Tengah
            ['kode_kota' => '3301', 'nama_kota' => 'Cilacap', 'provinsi_id' => 3, 'tipe' => 'Kabupaten'],
            ['kode_kota' => '3302', 'nama_kota' => 'Banyumas', 'provinsi_id' => 3, 'tipe' => 'Kabupaten'],
            ['kode_kota' => '3303', 'nama_kota' => 'Purbalingga', 'provinsi_id' => 3, 'tipe' => 'Kabupaten'],
            ['kode_kota' => '3304', 'nama_kota' => 'Banjarnegara', 'provinsi_id' => 3, 'tipe' => 'Kabupaten'],
            ['kode_kota' => '3305', 'nama_kota' => 'Kebumen', 'provinsi_id' => 3, 'tipe' => 'Kabupaten'],
            
            // DI Yogyakarta
            ['kode_kota' => '3401', 'nama_kota' => 'Kulon Progo', 'provinsi_id' => 4, 'tipe' => 'Kabupaten'],
            ['kode_kota' => '3402', 'nama_kota' => 'Bantul', 'provinsi_id' => 4, 'tipe' => 'Kabupaten'],
            ['kode_kota' => '3403', 'nama_kota' => 'Sleman', 'provinsi_id' => 4, 'tipe' => 'Kabupaten'],
            ['kode_kota' => '3404', 'nama_kota' => 'Gunung Kidul', 'provinsi_id' => 4, 'tipe' => 'Kabupaten'],
            ['kode_kota' => '3471', 'nama_kota' => 'Kota Yogyakarta', 'provinsi_id' => 4, 'tipe' => 'Kota'],
            
            // Jawa Timur
            ['kode_kota' => '3501', 'nama_kota' => 'Pacitan', 'provinsi_id' => 5, 'tipe' => 'Kabupaten'],
            ['kode_kota' => '3502', 'nama_kota' => 'Ponorogo', 'provinsi_id' => 5, 'tipe' => 'Kabupaten'],
            ['kode_kota' => '3503', 'nama_kota' => 'Trenggalek', 'provinsi_id' => 5, 'tipe' => 'Kabupaten'],
            ['kode_kota' => '3504', 'nama_kota' => 'Tulungagung', 'provinsi_id' => 5, 'tipe' => 'Kabupaten'],
            ['kode_kota' => '3505', 'nama_kota' => 'Blitar', 'provinsi_id' => 5, 'tipe' => 'Kabupaten'],
            
            // Banten
            ['kode_kota' => '3601', 'nama_kota' => 'Pandeglang', 'provinsi_id' => 6, 'tipe' => 'Kabupaten'],
            ['kode_kota' => '3602', 'nama_kota' => 'Lebak', 'provinsi_id' => 6, 'tipe' => 'Kabupaten'],
            ['kode_kota' => '3603', 'nama_kota' => 'Tangerang', 'provinsi_id' => 6, 'tipe' => 'Kabupaten'],
            ['kode_kota' => '3604', 'nama_kota' => 'Serang', 'provinsi_id' => 6, 'tipe' => 'Kabupaten'],
            ['kode_kota' => '3671', 'nama_kota' => 'Kota Tangerang', 'provinsi_id' => 6, 'tipe' => 'Kota'],
            ['kode_kota' => '3672', 'nama_kota' => 'Kota Cilegon', 'provinsi_id' => 6, 'tipe' => 'Kota'],
            ['kode_kota' => '3673', 'nama_kota' => 'Kota Serang', 'provinsi_id' => 6, 'tipe' => 'Kota'],
            ['kode_kota' => '3674', 'nama_kota' => 'Kota Tangerang Selatan', 'provinsi_id' => 6, 'tipe' => 'Kota'],
        ];

        foreach ($kota as $k) {
            RefKota::create($k);
        }
    }

    private function seedKecamatan()
    {
        $kecamatan = [
            // Jakarta Pusat (kota_id = 3)
            ['kode_kecamatan' => '317101', 'nama_kecamatan' => 'Gambir', 'kota_id' => 3],
            ['kode_kecamatan' => '317102', 'nama_kecamatan' => 'Sawah Besar', 'kota_id' => 3],
            ['kode_kecamatan' => '317103', 'nama_kecamatan' => 'Kemayoran', 'kota_id' => 3],
            ['kode_kecamatan' => '317104', 'nama_kecamatan' => 'Senen', 'kota_id' => 3],
            ['kode_kecamatan' => '317105', 'nama_kecamatan' => 'Cempaka Putih', 'kota_id' => 3],
            ['kode_kecamatan' => '317106', 'nama_kecamatan' => 'Menteng', 'kota_id' => 3],
            ['kode_kecamatan' => '317107', 'nama_kecamatan' => 'Tanah Abang', 'kota_id' => 3],
            ['kode_kecamatan' => '317108', 'nama_kecamatan' => 'Johar Baru', 'kota_id' => 3],
            
            // Jakarta Utara (kota_id = 6)
            ['kode_kecamatan' => '317201', 'nama_kecamatan' => 'Penjaringan', 'kota_id' => 6],
            ['kode_kecamatan' => '317202', 'nama_kecamatan' => 'Tanjung Priok', 'kota_id' => 6],
            ['kode_kecamatan' => '317203', 'nama_kecamatan' => 'Koja', 'kota_id' => 6],
            ['kode_kecamatan' => '317204', 'nama_kecamatan' => 'Cilincing', 'kota_id' => 6],
            ['kode_kecamatan' => '317205', 'nama_kecamatan' => 'Pademangan', 'kota_id' => 6],
            ['kode_kecamatan' => '317206', 'nama_kecamatan' => 'Kelapa Gading', 'kota_id' => 6],
            
            // Jakarta Barat (kota_id = 2)
            ['kode_kecamatan' => '317301', 'nama_kecamatan' => 'Cengkareng', 'kota_id' => 2],
            ['kode_kecamatan' => '317302', 'nama_kecamatan' => 'Grogol Petamburan', 'kota_id' => 2],
            ['kode_kecamatan' => '317303', 'nama_kecamatan' => 'Taman Sari', 'kota_id' => 2],
            ['kode_kecamatan' => '317304', 'nama_kecamatan' => 'Tambora', 'kota_id' => 2],
            ['kode_kecamatan' => '317305', 'nama_kecamatan' => 'Kebon Jeruk', 'kota_id' => 2],
            ['kode_kecamatan' => '317306', 'nama_kecamatan' => 'Kalideres', 'kota_id' => 2],
            ['kode_kecamatan' => '317307', 'nama_kecamatan' => 'Palmerah', 'kota_id' => 2],
            ['kode_kecamatan' => '317308', 'nama_kecamatan' => 'Kembangan', 'kota_id' => 2],
            
            // Jakarta Selatan (kota_id = 4)
            ['kode_kecamatan' => '317401', 'nama_kecamatan' => 'Tebet', 'kota_id' => 4],
            ['kode_kecamatan' => '317402', 'nama_kecamatan' => 'Setiabudi', 'kota_id' => 4],
            ['kode_kecamatan' => '317403', 'nama_kecamatan' => 'Mampang Prapatan', 'kota_id' => 4],
            ['kode_kecamatan' => '317404', 'nama_kecamatan' => 'Pasar Minggu', 'kota_id' => 4],
            ['kode_kecamatan' => '317405', 'nama_kecamatan' => 'Kebayoran Lama', 'kota_id' => 4],
            ['kode_kecamatan' => '317406', 'nama_kecamatan' => 'Cilandak', 'kota_id' => 4],
            ['kode_kecamatan' => '317407', 'nama_kecamatan' => 'Kebayoran Baru', 'kota_id' => 4],
            ['kode_kecamatan' => '317408', 'nama_kecamatan' => 'Pancoran', 'kota_id' => 4],
            ['kode_kecamatan' => '317409', 'nama_kecamatan' => 'Jagakarsa', 'kota_id' => 4],
            ['kode_kecamatan' => '317410', 'nama_kecamatan' => 'Pesanggrahan', 'kota_id' => 4],
            
            // Jakarta Timur (kota_id = 5)
            ['kode_kecamatan' => '317501', 'nama_kecamatan' => 'Matraman', 'kota_id' => 5],
            ['kode_kecamatan' => '317502', 'nama_kecamatan' => 'Pulo Gadung', 'kota_id' => 5],
            ['kode_kecamatan' => '317503', 'nama_kecamatan' => 'Jatinegara', 'kota_id' => 5],
            ['kode_kecamatan' => '317504', 'nama_kecamatan' => 'Kramat Jati', 'kota_id' => 5],
            ['kode_kecamatan' => '317505', 'nama_kecamatan' => 'Pasar Rebo', 'kota_id' => 5],
            ['kode_kecamatan' => '317506', 'nama_kecamatan' => 'Cakung', 'kota_id' => 5],
            ['kode_kecamatan' => '317507', 'nama_kecamatan' => 'Duren Sawit', 'kota_id' => 5],
            ['kode_kecamatan' => '317508', 'nama_kecamatan' => 'Makasar', 'kota_id' => 5],
            ['kode_kecamatan' => '317509', 'nama_kecamatan' => 'Ciracas', 'kota_id' => 5],
            ['kode_kecamatan' => '317510', 'nama_kecamatan' => 'Cipayung', 'kota_id' => 5],
        ];

        foreach ($kecamatan as $k) {
            RefKecamatan::create($k);
        }
    }

    private function seedKelurahan()
    {
        $kelurahan = [
            // Kebayoran Baru
            ['kode_kelurahan' => '31710101', 'nama_kelurahan' => 'Kramat Pela', 'kecamatan_id' => 1, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31710102', 'nama_kelurahan' => 'Gandaria Selatan', 'kecamatan_id' => 1, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31710103', 'nama_kelurahan' => 'Cipete Utara', 'kecamatan_id' => 1, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31710104', 'nama_kelurahan' => 'Pulo', 'kecamatan_id' => 1, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31710105', 'nama_kelurahan' => 'Melawai', 'kecamatan_id' => 1, 'tipe' => 'Kelurahan'],
            
            // Kebayoran Lama
            ['kode_kelurahan' => '31710201', 'nama_kelurahan' => 'Grogol Utara', 'kecamatan_id' => 2, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31710202', 'nama_kelurahan' => 'Grogol Selatan', 'kecamatan_id' => 2, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31710203', 'nama_kelurahan' => 'Cipulir', 'kecamatan_id' => 2, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31710204', 'nama_kelurahan' => 'Kebayoran Lama Utara', 'kecamatan_id' => 2, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31710205', 'nama_kelurahan' => 'Kebayoran Lama Selatan', 'kecamatan_id' => 2, 'tipe' => 'Kelurahan'],
            
            // Jakarta Timur - Data lengkap dari tabel yang diberikan
            
            // Matraman (kecamatan_id = 6)
            ['kode_kelurahan' => '31750101', 'nama_kelurahan' => 'Kayu Manis', 'kecamatan_id' => 6, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750102', 'nama_kelurahan' => 'Kebon Manggis', 'kecamatan_id' => 6, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750103', 'nama_kelurahan' => 'Pal Meriam', 'kecamatan_id' => 6, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750104', 'nama_kelurahan' => 'Pisangan Baru', 'kecamatan_id' => 6, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750105', 'nama_kelurahan' => 'Utan Kayu Selatan', 'kecamatan_id' => 6, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750106', 'nama_kelurahan' => 'Utan Kayu Utara', 'kecamatan_id' => 6, 'tipe' => 'Kelurahan'],
            
            // Pulo Gadung (kecamatan_id = 7)
            ['kode_kelurahan' => '31750201', 'nama_kelurahan' => 'Cipinang', 'kecamatan_id' => 7, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750202', 'nama_kelurahan' => 'Jati', 'kecamatan_id' => 7, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750203', 'nama_kelurahan' => 'Jatinegara Kaum', 'kecamatan_id' => 7, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750204', 'nama_kelurahan' => 'Kayu Putih', 'kecamatan_id' => 7, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750205', 'nama_kelurahan' => 'Pisangan Timur', 'kecamatan_id' => 7, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750206', 'nama_kelurahan' => 'Pulo Gadung', 'kecamatan_id' => 7, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750207', 'nama_kelurahan' => 'Rawamangun', 'kecamatan_id' => 7, 'tipe' => 'Kelurahan'],
            
            // Jatinegara (kecamatan_id = 8)
            ['kode_kelurahan' => '31750301', 'nama_kelurahan' => 'Bali Mester', 'kecamatan_id' => 8, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750302', 'nama_kelurahan' => 'Bidara Cina', 'kecamatan_id' => 8, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750303', 'nama_kelurahan' => 'Cipinang Besar Selatan', 'kecamatan_id' => 8, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750304', 'nama_kelurahan' => 'Cipinang Besar Utara', 'kecamatan_id' => 8, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750305', 'nama_kelurahan' => 'Cipinang Cempedak', 'kecamatan_id' => 8, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750306', 'nama_kelurahan' => 'Cipinang Muara', 'kecamatan_id' => 8, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750307', 'nama_kelurahan' => 'Kampung Melayu', 'kecamatan_id' => 8, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750308', 'nama_kelurahan' => 'Rawa Bunga', 'kecamatan_id' => 8, 'tipe' => 'Kelurahan'],
            
            // Kramat Jati (kecamatan_id = 9)
            ['kode_kelurahan' => '31750401', 'nama_kelurahan' => 'Balekambang', 'kecamatan_id' => 9, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750402', 'nama_kelurahan' => 'Batu Ampar', 'kecamatan_id' => 9, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750403', 'nama_kelurahan' => 'Cawang', 'kecamatan_id' => 9, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750404', 'nama_kelurahan' => 'Cililitan', 'kecamatan_id' => 9, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750405', 'nama_kelurahan' => 'Dukuh', 'kecamatan_id' => 9, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750406', 'nama_kelurahan' => 'Kramat Jati', 'kecamatan_id' => 9, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750407', 'nama_kelurahan' => 'Tengah', 'kecamatan_id' => 9, 'tipe' => 'Kelurahan'],
            
            // Pasar Rebo (kecamatan_id = 10)
            ['kode_kelurahan' => '31750501', 'nama_kelurahan' => 'Baru', 'kecamatan_id' => 10, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750502', 'nama_kelurahan' => 'Cijantung', 'kecamatan_id' => 10, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750503', 'nama_kelurahan' => 'Gedong', 'kecamatan_id' => 10, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750504', 'nama_kelurahan' => 'Kalisari', 'kecamatan_id' => 10, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750505', 'nama_kelurahan' => 'Pekayon', 'kecamatan_id' => 10, 'tipe' => 'Kelurahan'],
            
            // Cakung (kecamatan_id = 11)
            ['kode_kelurahan' => '31750601', 'nama_kelurahan' => 'Cakung Barat', 'kecamatan_id' => 11, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750602', 'nama_kelurahan' => 'Cakung Timur', 'kecamatan_id' => 11, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750603', 'nama_kelurahan' => 'Jatinegara', 'kecamatan_id' => 11, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750604', 'nama_kelurahan' => 'Penggilingan', 'kecamatan_id' => 11, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750605', 'nama_kelurahan' => 'Pulo Gebang', 'kecamatan_id' => 11, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750606', 'nama_kelurahan' => 'Rawa Terate', 'kecamatan_id' => 11, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750607', 'nama_kelurahan' => 'Ujung Menteng', 'kecamatan_id' => 11, 'tipe' => 'Kelurahan'],
            
            // Duren Sawit (kecamatan_id = 12)
            ['kode_kelurahan' => '31750701', 'nama_kelurahan' => 'Duren Sawit', 'kecamatan_id' => 12, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750702', 'nama_kelurahan' => 'Klender', 'kecamatan_id' => 12, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750703', 'nama_kelurahan' => 'Malaka Jaya', 'kecamatan_id' => 12, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750704', 'nama_kelurahan' => 'Malaka Sari', 'kecamatan_id' => 12, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750705', 'nama_kelurahan' => 'Pondok Bambu', 'kecamatan_id' => 12, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750706', 'nama_kelurahan' => 'Pondok Kelapa', 'kecamatan_id' => 12, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750707', 'nama_kelurahan' => 'Pondok Kopi', 'kecamatan_id' => 12, 'tipe' => 'Kelurahan'],
            
            // Makasar (kecamatan_id = 13)
            ['kode_kelurahan' => '31750801', 'nama_kelurahan' => 'Cipinang Melayu', 'kecamatan_id' => 13, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750802', 'nama_kelurahan' => 'Halim Perdana Kusuma', 'kecamatan_id' => 13, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750803', 'nama_kelurahan' => 'Kebon Pala', 'kecamatan_id' => 13, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750804', 'nama_kelurahan' => 'Makasar', 'kecamatan_id' => 13, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750805', 'nama_kelurahan' => 'Pinang Ranti', 'kecamatan_id' => 13, 'tipe' => 'Kelurahan'],
            
            // Ciracas (kecamatan_id = 14)
            ['kode_kelurahan' => '31750901', 'nama_kelurahan' => 'Cibubur', 'kecamatan_id' => 14, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750902', 'nama_kelurahan' => 'Ciracas', 'kecamatan_id' => 14, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750903', 'nama_kelurahan' => 'Kelapa Dua Wetan', 'kecamatan_id' => 14, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750904', 'nama_kelurahan' => 'Rambutan', 'kecamatan_id' => 14, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750905', 'nama_kelurahan' => 'Susukan', 'kecamatan_id' => 14, 'tipe' => 'Kelurahan'],
            
            // Cakung (kecamatan_id = 11) - Data dari gambar yang diberikan
            ['kode_kelurahan' => '31750601', 'nama_kelurahan' => 'Cakung Barat', 'kecamatan_id' => 11, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750602', 'nama_kelurahan' => 'Cakung Timur', 'kecamatan_id' => 11, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750603', 'nama_kelurahan' => 'Rawa Terate', 'kecamatan_id' => 11, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750604', 'nama_kelurahan' => 'Jatinegara', 'kecamatan_id' => 11, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750605', 'nama_kelurahan' => 'Penggilingan', 'kecamatan_id' => 11, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750606', 'nama_kelurahan' => 'Pulo Gebang', 'kecamatan_id' => 11, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750607', 'nama_kelurahan' => 'Ujung Menteng', 'kecamatan_id' => 11, 'tipe' => 'Kelurahan'],
            
            // Duren Sawit (kecamatan_id = 12) - Data dari gambar yang diberikan
            ['kode_kelurahan' => '31750701', 'nama_kelurahan' => 'Pondok Bambu', 'kecamatan_id' => 12, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750702', 'nama_kelurahan' => 'Duren Sawit', 'kecamatan_id' => 12, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750703', 'nama_kelurahan' => 'Pondok Kelapa', 'kecamatan_id' => 12, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750704', 'nama_kelurahan' => 'Pondok Kopi', 'kecamatan_id' => 12, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750705', 'nama_kelurahan' => 'Malaka Jaya', 'kecamatan_id' => 12, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750706', 'nama_kelurahan' => 'Malaka Sari', 'kecamatan_id' => 12, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750707', 'nama_kelurahan' => 'Klender', 'kecamatan_id' => 12, 'tipe' => 'Kelurahan'],
            
            // Ciracas (kecamatan_id = 14) - Data dari gambar yang diberikan
            ['kode_kelurahan' => '31750901', 'nama_kelurahan' => 'Cibubur', 'kecamatan_id' => 14, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750902', 'nama_kelurahan' => 'Kelapa Dua Wetan', 'kecamatan_id' => 14, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750903', 'nama_kelurahan' => 'Ciracas', 'kecamatan_id' => 14, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750904', 'nama_kelurahan' => 'Susukan', 'kecamatan_id' => 14, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750905', 'nama_kelurahan' => 'Rambutan', 'kecamatan_id' => 14, 'tipe' => 'Kelurahan'],
            
            // Cipayung (kecamatan_id = 15) - Data dari gambar yang diberikan
            ['kode_kelurahan' => '31751001', 'nama_kelurahan' => 'Lubang Buaya', 'kecamatan_id' => 15, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31751002', 'nama_kelurahan' => 'Ceger', 'kecamatan_id' => 15, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31751003', 'nama_kelurahan' => 'Rambutan', 'kecamatan_id' => 15, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31751004', 'nama_kelurahan' => 'Cipayung', 'kecamatan_id' => 15, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31751005', 'nama_kelurahan' => 'Munjul', 'kecamatan_id' => 15, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31751006', 'nama_kelurahan' => 'Pondok Ranggon', 'kecamatan_id' => 15, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31751007', 'nama_kelurahan' => 'Cilangkap', 'kecamatan_id' => 15, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31751008', 'nama_kelurahan' => 'Setu', 'kecamatan_id' => 15, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31751009', 'nama_kelurahan' => 'Bambu Apus', 'kecamatan_id' => 15, 'tipe' => 'Kelurahan'],
        ];

        foreach ($kelurahan as $k) {
            RefKelurahan::create($k);
        }
    }
}
