<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\RefKelurahan;

class PasarReboPuloGadungSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $kelurahan = [
            // Pasar Rebo (kecamatan_id = 14) - Data dari gambar yang diberikan
            ['kode_kelurahan' => '31750901', 'nama_kelurahan' => 'Baru', 'kecamatan_id' => 14, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750902', 'nama_kelurahan' => 'Cijantung', 'kecamatan_id' => 14, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750903', 'nama_kelurahan' => 'Gedong', 'kecamatan_id' => 14, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750904', 'nama_kelurahan' => 'Kalisari', 'kecamatan_id' => 14, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750905', 'nama_kelurahan' => 'Pekayon', 'kecamatan_id' => 14, 'tipe' => 'Kelurahan'],
            
            // Pulo Gadung (kecamatan_id = 15) - Data dari gambar yang diberikan
            ['kode_kelurahan' => '31751001', 'nama_kelurahan' => 'Kayu Putih', 'kecamatan_id' => 15, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31751002', 'nama_kelurahan' => 'Jati', 'kecamatan_id' => 15, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31751003', 'nama_kelurahan' => 'Rawamangun', 'kecamatan_id' => 15, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31751004', 'nama_kelurahan' => 'Pisangan Timur', 'kecamatan_id' => 15, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31751005', 'nama_kelurahan' => 'Cipinang', 'kecamatan_id' => 15, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31751006', 'nama_kelurahan' => 'Jatinegara Kaum', 'kecamatan_id' => 15, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31751007', 'nama_kelurahan' => 'Pulo Gadung', 'kecamatan_id' => 15, 'tipe' => 'Kelurahan'],
        ];

        foreach ($kelurahan as $k) {
            // Check if kelurahan already exists
            $existing = RefKelurahan::where('kode_kelurahan', $k['kode_kelurahan'])->first();
            if (!$existing) {
                RefKelurahan::create($k);
            }
        }
    }
}