<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\RefKelurahan;

class MakasarMatramanSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $kelurahan = [
            // Matraman (kecamatan_id = 6) - Data dari gambar yang diberikan
            ['kode_kelurahan' => '31750101', 'nama_kelurahan' => 'Pisangan Baru', 'kecamatan_id' => 6, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750102', 'nama_kelurahan' => 'Utan Kayu Selatan', 'kecamatan_id' => 6, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750103', 'nama_kelurahan' => 'Utan Kayu Utara', 'kecamatan_id' => 6, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750104', 'nama_kelurahan' => 'Kayu Manis', 'kecamatan_id' => 6, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750105', 'nama_kelurahan' => 'Pal Meriam', 'kecamatan_id' => 6, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750106', 'nama_kelurahan' => 'Kebon Manggis', 'kecamatan_id' => 6, 'tipe' => 'Kelurahan'],
            
            // Makasar (kecamatan_id = 13) - Data dari gambar yang diberikan
            ['kode_kelurahan' => '31750801', 'nama_kelurahan' => 'Cipinang Melayu', 'kecamatan_id' => 13, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750802', 'nama_kelurahan' => 'Halim Perdana Kusuma', 'kecamatan_id' => 13, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750803', 'nama_kelurahan' => 'Kebon Pala', 'kecamatan_id' => 13, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750804', 'nama_kelurahan' => 'Makasar', 'kecamatan_id' => 13, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750805', 'nama_kelurahan' => 'Pinang Ranti', 'kecamatan_id' => 13, 'tipe' => 'Kelurahan'],
        ];

        foreach ($kelurahan as $k) {
            // Check if kelurahan already exists
            $existing = RefKelurahan::where('kode_kelurahan', $k['kode_kelurahan'])->first();
            if (!$existing) {
                RefKelurahan::create($k);
            }
        }
    }
}