<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\RefKelurahan;

class KodePosKelurahanSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $kodePosData = [
            // Matraman (kecamatan_id = 33)
            ['nama_kelurahan' => 'Pisangan Baru', 'kode_pos' => '13110'],
            ['nama_kelurahan' => 'Utan Kayu Selatan', 'kode_pos' => '13120'],
            ['nama_kelurahan' => 'Utan Kayu Utara', 'kode_pos' => '13120'],
            ['nama_kelurahan' => 'Kayu Manis', 'kode_pos' => '13130'],
            ['nama_kelurahan' => 'Pal Meriam', 'kode_pos' => '13140'],
            ['nama_kelurahan' => 'Kebon Manggis', 'kode_pos' => '13150'],
            
            // Pasar Rebo (kecamatan_id = 37)
            ['nama_kelurahan' => 'Baru', 'kode_pos' => '13780'],
            ['nama_kelurahan' => 'Cijantung', 'kode_pos' => '13770'],
            ['nama_kelurahan' => 'Gedong', 'kode_pos' => '13760'],
            ['nama_kelurahan' => 'Kalisari', 'kode_pos' => '13790'],
            ['nama_kelurahan' => 'Pekayon', 'kode_pos' => '13710'],
            
            // Pulo Gadung (kecamatan_id = 34)
            ['nama_kelurahan' => 'Kayu Putih', 'kode_pos' => '13210'],
            ['nama_kelurahan' => 'Jati', 'kode_pos' => '13220'],
            ['nama_kelurahan' => 'Rawamangun', 'kode_pos' => '13220'],
            ['nama_kelurahan' => 'Pisangan Timur', 'kode_pos' => '13230'],
            ['nama_kelurahan' => 'Cipinang', 'kode_pos' => '13240'],
            ['nama_kelurahan' => 'Jatinegara Kaum', 'kode_pos' => '13250'],
            ['nama_kelurahan' => 'Pulo Gadung', 'kode_pos' => '13260'],
        ];

        foreach ($kodePosData as $data) {
            $kelurahan = RefKelurahan::where('nama_kelurahan', $data['nama_kelurahan'])->first();
            if ($kelurahan) {
                $kelurahan->update(['kode_pos' => $data['kode_pos']]);
                echo "Updated kode_pos for {$data['nama_kelurahan']}: {$data['kode_pos']}\n";
            }
        }
    }
}