<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\RefKelurahan;

class KelurahanSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $kelurahan = [
            // Cakung (kecamatan_id = 11) - Data dari gambar yang diberikan
            ['kode_kelurahan' => '31750601', 'nama_kelurahan' => 'Cakung Barat', 'kecamatan_id' => 11, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750602', 'nama_kelurahan' => 'Cakung Timur', 'kecamatan_id' => 11, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750603', 'nama_kelurahan' => 'Rawa Terate', 'kecamatan_id' => 11, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750604', 'nama_kelurahan' => 'Jatinegara', 'kecamatan_id' => 11, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750605', 'nama_kelurahan' => 'Penggilingan', 'kecamatan_id' => 11, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750606', 'nama_kelurahan' => 'Pulo Gebang', 'kecamatan_id' => 11, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750607', 'nama_kelurahan' => 'Ujung Menteng', 'kecamatan_id' => 11, 'tipe' => 'Kelurahan'],
            
            // Duren Sawit (kecamatan_id = 12) - Data dari gambar yang diberikan
            ['kode_kelurahan' => '31750701', 'nama_kelurahan' => 'Pondok Bambu', 'kecamatan_id' => 12, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750702', 'nama_kelurahan' => 'Duren Sawit', 'kecamatan_id' => 12, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750703', 'nama_kelurahan' => 'Pondok Kelapa', 'kecamatan_id' => 12, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750704', 'nama_kelurahan' => 'Pondok Kopi', 'kecamatan_id' => 12, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750705', 'nama_kelurahan' => 'Malaka Jaya', 'kecamatan_id' => 12, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750706', 'nama_kelurahan' => 'Malaka Sari', 'kecamatan_id' => 12, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750707', 'nama_kelurahan' => 'Klender', 'kecamatan_id' => 12, 'tipe' => 'Kelurahan'],
            
            // Ciracas (kecamatan_id = 14) - Data dari gambar yang diberikan
            ['kode_kelurahan' => '31750901', 'nama_kelurahan' => 'Cibubur', 'kecamatan_id' => 14, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750902', 'nama_kelurahan' => 'Kelapa Dua Wetan', 'kecamatan_id' => 14, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750903', 'nama_kelurahan' => 'Ciracas', 'kecamatan_id' => 14, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750904', 'nama_kelurahan' => 'Susukan', 'kecamatan_id' => 14, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750905', 'nama_kelurahan' => 'Rambutan', 'kecamatan_id' => 14, 'tipe' => 'Kelurahan'],
            
            // Jatinegara (kecamatan_id = 8) - Data dari gambar yang diberikan
            ['kode_kelurahan' => '31750301', 'nama_kelurahan' => 'Bali Mester', 'kecamatan_id' => 8, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750302', 'nama_kelurahan' => 'Kampung Melayu', 'kecamatan_id' => 8, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750303', 'nama_kelurahan' => 'Bidaracina', 'kecamatan_id' => 8, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750304', 'nama_kelurahan' => 'Cipinang Cempedak', 'kecamatan_id' => 8, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750305', 'nama_kelurahan' => 'Rawa Bunga', 'kecamatan_id' => 8, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750306', 'nama_kelurahan' => 'Cipinang Besar Utara', 'kecamatan_id' => 8, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750307', 'nama_kelurahan' => 'Cipinang Besar Selatan', 'kecamatan_id' => 8, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750308', 'nama_kelurahan' => 'Cipinang Muara', 'kecamatan_id' => 8, 'tipe' => 'Kelurahan'],
            
            // Kramat Jati (kecamatan_id = 9) - Data dari gambar yang diberikan
            ['kode_kelurahan' => '31750401', 'nama_kelurahan' => 'Kramat Jati', 'kecamatan_id' => 9, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750402', 'nama_kelurahan' => 'Batuampar', 'kecamatan_id' => 9, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750403', 'nama_kelurahan' => 'Balekambang', 'kecamatan_id' => 9, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750404', 'nama_kelurahan' => 'Tengah', 'kecamatan_id' => 9, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750405', 'nama_kelurahan' => 'Dukuh', 'kecamatan_id' => 9, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750406', 'nama_kelurahan' => 'Cawang', 'kecamatan_id' => 9, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750407', 'nama_kelurahan' => 'Cililitan', 'kecamatan_id' => 9, 'tipe' => 'Kelurahan'],
            
            // Cipayung (kecamatan_id = 15) - Data dari gambar yang diberikan
            ['kode_kelurahan' => '31751001', 'nama_kelurahan' => 'Lubang Buaya', 'kecamatan_id' => 15, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31751002', 'nama_kelurahan' => 'Ceger', 'kecamatan_id' => 15, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31751003', 'nama_kelurahan' => 'Rambutan', 'kecamatan_id' => 15, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31751004', 'nama_kelurahan' => 'Cipayung', 'kecamatan_id' => 15, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31751005', 'nama_kelurahan' => 'Munjul', 'kecamatan_id' => 15, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31751006', 'nama_kelurahan' => 'Pondok Ranggon', 'kecamatan_id' => 15, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31751007', 'nama_kelurahan' => 'Cilangkap', 'kecamatan_id' => 15, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31751008', 'nama_kelurahan' => 'Setu', 'kecamatan_id' => 15, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31751009', 'nama_kelurahan' => 'Bambu Apus', 'kecamatan_id' => 15, 'tipe' => 'Kelurahan'],
        ];

        foreach ($kelurahan as $k) {
            RefKelurahan::create($k);
        }
    }
}