<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\RefKeahlian;

class KeahlianSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $keahlianList = [
            [
                'nama_keahlian' => 'Public Speaking',
                'deskripsi' => 'Kemampuan berbicara di depan umum dengan baik dan efektif',
                'is_active' => true
            ],
            [
                'nama_keahlian' => 'Leadership',
                'deskripsi' => 'Kemampuan memimpin dan mengarahkan tim',
                'is_active' => true
            ],
            [
                'nama_keahlian' => 'Communication',
                'deskripsi' => 'Kemampuan berkomunikasi yang baik dengan berbagai pihak',
                'is_active' => true
            ],
            [
                'nama_keahlian' => 'Project Management',
                'deskripsi' => 'Kemampuan mengelola proyek dari perencanaan hingga evaluasi',
                'is_active' => true
            ],
            [
                'nama_keahlian' => 'Digital Marketing',
                'deskripsi' => 'Kemampuan pemasaran digital dan media sosial',
                'is_active' => true
            ],
            [
                'nama_keahlian' => 'Data Analysis',
                'deskripsi' => 'Kemampuan menganalisis data dan membuat laporan',
                'is_active' => true
            ],
            [
                'nama_keahlian' => 'Event Management',
                'deskripsi' => 'Kemampuan mengorganisir dan mengelola acara',
                'is_active' => true
            ],
            [
                'nama_keahlian' => 'Community Development',
                'deskripsi' => 'Kemampuan mengembangkan dan memberdayakan masyarakat',
                'is_active' => true
            ],
            [
                'nama_keahlian' => 'Financial Management',
                'deskripsi' => 'Kemampuan mengelola keuangan organisasi',
                'is_active' => true
            ],
            [
                'nama_keahlian' => 'Strategic Planning',
                'deskripsi' => 'Kemampuan membuat perencanaan strategis',
                'is_active' => true
            ],
            [
                'nama_keahlian' => 'Team Building',
                'deskripsi' => 'Kemampuan membangun dan mengembangkan tim',
                'is_active' => true
            ],
            [
                'nama_keahlian' => 'Conflict Resolution',
                'deskripsi' => 'Kemampuan menyelesaikan konflik dan permasalahan',
                'is_active' => true
            ],
            [
                'nama_keahlian' => 'Training & Development',
                'deskripsi' => 'Kemampuan melatih dan mengembangkan SDM',
                'is_active' => true
            ],
            [
                'nama_keahlian' => 'Research & Development',
                'deskripsi' => 'Kemampuan melakukan penelitian dan pengembangan',
                'is_active' => true
            ],
            [
                'nama_keahlian' => 'Public Relations',
                'deskripsi' => 'Kemampuan membangun hubungan dengan publik',
                'is_active' => true
            ],
            [
                'nama_keahlian' => 'Graphic Design',
                'deskripsi' => 'Kemampuan desain grafis dan visual',
                'is_active' => false
            ],
            [
                'nama_keahlian' => 'Video Production',
                'deskripsi' => 'Kemampuan produksi video dan multimedia',
                'is_active' => false
            ],
            [
                'nama_keahlian' => 'Web Development',
                'deskripsi' => 'Kemampuan pengembangan website',
                'is_active' => false
            ]
        ];

        foreach ($keahlianList as $keahlian) {
            RefKeahlian::create($keahlian);
        }
    }
}