<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\JenisKegiatan;
use Carbon\Carbon;

class JenisKegiatanSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $jenisKegiatans = [
            [
                'kode_jenis_kegiatan' => 'JK001',
                'nama_jenis_kegiatan' => 'Pembinaan Rutin',
                'deskripsi' => 'Kegiatan pembinaan yang dilakukan secara rutin untuk anggota',
                'kategori' => 'Pembinaan',
                'durasi_standar' => 120, // 2 jam
                'is_active' => true,
                'catatan' => 'Kegiatan wajib untuk semua anggota'
            ],
            [
                'kode_jenis_kegiatan' => 'JK002',
                'nama_jenis_kegiatan' => 'Pelatihan Kader',
                'deskripsi' => 'Pelatihan khusus untuk pengembangan kader',
                'kategori' => 'Pelatihan',
                'durasi_standar' => 480, // 8 jam
                'is_active' => true,
                'catatan' => 'Untuk kader terpilih'
            ],
            [
                'kode_jenis_kegiatan' => 'JK003',
                'nama_jenis_kegiatan' => 'Seminar Keagamaan',
                'deskripsi' => 'Seminar tentang pemahaman keagamaan',
                'kategori' => 'Seminar',
                'durasi_standar' => 180, // 3 jam
                'is_active' => true,
                'catatan' => 'Terbuka untuk umum'
            ],
            [
                'kode_jenis_kegiatan' => 'JK004',
                'nama_jenis_kegiatan' => 'Workshop Kepemimpinan',
                'deskripsi' => 'Workshop pengembangan kemampuan kepemimpinan',
                'kategori' => 'Workshop',
                'durasi_standar' => 240, // 4 jam
                'is_active' => true,
                'catatan' => 'Untuk calon pemimpin'
            ],
            [
                'kode_jenis_kegiatan' => 'JK005',
                'nama_jenis_kegiatan' => 'Rapat Koordinasi',
                'deskripsi' => 'Rapat koordinasi internal organisasi',
                'kategori' => 'Rapat',
                'durasi_standar' => 90, // 1.5 jam
                'is_active' => true,
                'catatan' => 'Untuk pengurus'
            ],
            [
                'kode_jenis_kegiatan' => 'JK006',
                'nama_jenis_kegiatan' => 'Konsultasi Individual',
                'deskripsi' => 'Konsultasi pribadi dengan mentor',
                'kategori' => 'Konsultasi',
                'durasi_standar' => 60, // 1 jam
                'is_active' => true,
                'catatan' => 'Berdasarkan permintaan'
            ],
            [
                'kode_jenis_kegiatan' => 'JK007',
                'nama_jenis_kegiatan' => 'Retreat Spiritual',
                'deskripsi' => 'Retreat untuk penguatan spiritual',
                'kategori' => 'Lainnya',
                'durasi_standar' => 1440, // 24 jam
                'is_active' => true,
                'catatan' => 'Kegiatan tahunan'
            ],
            [
                'kode_jenis_kegiatan' => 'JK008',
                'nama_jenis_kegiatan' => 'Pelatihan Teknis',
                'deskripsi' => 'Pelatihan keterampilan teknis',
                'kategori' => 'Pelatihan',
                'durasi_standar' => 360, // 6 jam
                'is_active' => false,
                'catatan' => 'Sedang dalam review'
            ]
        ];

        foreach ($jenisKegiatans as $jenisKegiatan) {
            JenisKegiatan::create($jenisKegiatan);
        }
    }
}