<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\RefKelurahan;

class JatinegaraKramatJatiSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $kelurahan = [
            // Jatinegara (kecamatan_id = 8) - Data dari gambar yang diberikan
            ['kode_kelurahan' => '31750301', 'nama_kelurahan' => 'Bali Mester', 'kecamatan_id' => 8, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750302', 'nama_kelurahan' => 'Kampung Melayu', 'kecamatan_id' => 8, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750303', 'nama_kelurahan' => 'Bidaracina', 'kecamatan_id' => 8, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750304', 'nama_kelurahan' => 'Cipinang Cempedak', 'kecamatan_id' => 8, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750305', 'nama_kelurahan' => 'Rawa Bunga', 'kecamatan_id' => 8, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750306', 'nama_kelurahan' => 'Cipinang Besar Utara', 'kecamatan_id' => 8, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750307', 'nama_kelurahan' => 'Cipinang Besar Selatan', 'kecamatan_id' => 8, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750308', 'nama_kelurahan' => 'Cipinang Muara', 'kecamatan_id' => 8, 'tipe' => 'Kelurahan'],
            
            // Kramat Jati (kecamatan_id = 9) - Data dari gambar yang diberikan
            ['kode_kelurahan' => '31750401', 'nama_kelurahan' => 'Kramat Jati', 'kecamatan_id' => 9, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750402', 'nama_kelurahan' => 'Batuampar', 'kecamatan_id' => 9, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750403', 'nama_kelurahan' => 'Balekambang', 'kecamatan_id' => 9, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750404', 'nama_kelurahan' => 'Tengah', 'kecamatan_id' => 9, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750405', 'nama_kelurahan' => 'Dukuh', 'kecamatan_id' => 9, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750406', 'nama_kelurahan' => 'Cawang', 'kecamatan_id' => 9, 'tipe' => 'Kelurahan'],
            ['kode_kelurahan' => '31750407', 'nama_kelurahan' => 'Cililitan', 'kecamatan_id' => 9, 'tipe' => 'Kelurahan'],
        ];

        foreach ($kelurahan as $k) {
            // Check if kelurahan already exists
            $existing = RefKelurahan::where('kode_kelurahan', $k['kode_kelurahan'])->first();
            if (!$existing) {
                RefKelurahan::create($k);
            }
        }
    }
}