<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\IndikatorTakwim;

class IndikatorTakwimSeeder extends Seeder
{
    public function run()
    {
        $indicators = [
            ['nomor' => 1, 'indikator' => 'Memiliki pemahaman keagamaan yang mendalam, utuh, dan moderat sesuai dengan akidah ahlus sunnah wal jama\'ah'],
            ['nomor' => 2, 'indikator' => 'Berusaha mewujudkan keluarga dakwah'],
            ['nomor' => 3, 'indikator' => 'Berkontribusi dan terlibat aktif dalam struktur partai atau amanah yang telah ditugaskan pimpinan partai'],
            ['nomor' => 4, 'indikator' => 'Melakukan pembinaan secara rutin baik langsung maupun tidak langsung'],
            ['nomor' => 5, 'indikator' => 'Setia dan komitmen pada seluruh kebijakan dan peraturan partai'],
            ['nomor' => 6, 'indikator' => 'Terlibat aktif dalam mengcounter opini yang mendeskriditkan partai dan pimpinan'],
            ['nomor' => 7, 'indikator' => 'Menerapkan pemahaman Konsensus Dasar Kebangsaan']
        ];

        foreach ($indicators as $indicator) {
            IndikatorTakwim::updateOrCreate(
                ['nomor' => $indicator['nomor']],
                [
                    'indikator' => $indicator['indikator'],
                    'is_active' => true
                ]
            );
        }
    }
}