<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class FinalDemoSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run()
    {
        // Insert DPD
        DB::statement("INSERT IGNORE INTO tbl_dpd (dpd_id, nama_dpd, is_active, created_at, updated_at) VALUES (1, 'DPD PKS Jakarta Timur', 1, NOW(), NOW())");

        // Insert DPC
        DB::statement("INSERT IGNORE INTO tbl_dpc (dpc_id, nama_dpc, dpd_id, is_active, created_at, updated_at) VALUES 
            (1, 'DPC Cipayung', 1, 1, NOW(), NOW()),
            (2, 'DPC Kramat Jati', 1, 1, NOW(), NOW()),
            (3, 'DPC Jatinegara', 1, 1, NOW(), NOW())");

        // Insert RefJenjang
        DB::statement("INSERT IGNORE INTO tbl_ref_jenjang (ref_jenjang_id, jenjang, created_at, updated_at) VALUES 
            (1, 'Kader', NOW(), NOW()),
            (2, 'Madya', NOW(), NOW()),
            (3, 'Utama', NOW(), NOW())");

        // Insert RefGrupUpa
        DB::statement("INSERT IGNORE INTO tbl_ref_grup_upa (ref_grup_upa_id, nama_grup_upa, created_at, updated_at) VALUES 
            (1, 'Grup A', NOW(), NOW()),
            (2, 'Grup B', NOW(), NOW())");

        // Insert UPA
        DB::statement("INSERT IGNORE INTO tbl_upa (upa_id, kode_upa, nama_upa, dpc_id, status, created_at, updated_at) VALUES 
            (1, 'UPA-CIP-001', 'UPA Cipayung Utara', 1, 'Aktif', NOW(), NOW()),
            (2, 'UPA-CIP-002', 'UPA Cipayung Selatan', 1, 'Aktif', NOW(), NOW()),
            (3, 'UPA-KRJ-001', 'UPA Kramat Jati Pusat', 2, 'Aktif', NOW(), NOW()),
            (4, 'UPA-KRJ-002', 'UPA Kramat Jati Timur', 2, 'Aktif', NOW(), NOW()),
            (5, 'UPA-JTG-001', 'UPA Jatinegara Utara', 3, 'Aktif', NOW(), NOW())");

        // Insert Anggota dengan field minimal
        DB::statement("INSERT IGNORE INTO tbl_anggota (
            nomor_identitas_anggota, 
            nama_lengkap, 
            tempat_lahir, 
            tanggal_lahir, 
            jenis_kelamin, 
            alamat_jalan, 
            rt, 
            rw, 
            kelurahan, 
            kecamatan, 
            kota, 
            provinsi, 
            no_telepon, 
            email, 
            ref_jenjang_id, 
            ref_grup_upa_id, 
            dpc_id, 
            dpd_id, 
            tanggal_bergabung, 
            status_keanggotaan, 
            created_at, 
            updated_at
        ) VALUES 
            ('PKS001', 'Ahmad Yani', 'Jakarta', '1985-01-15', 'Laki-laki', 'Jl. Cipayung Raya No. 1', '001', '001', 'Cipayung', 'Cipayung', 'Jakarta Timur', 'DKI Jakarta', '081234567890', 'ahmad.yani@example.com', 1, 1, 1, 1, '2020-01-01', 'Aktif', NOW(), NOW()),
            ('PKS002', 'Siti Nurhaliza', 'Jakarta', '1990-03-20', 'Perempuan', 'Jl. Cipayung Raya No. 2', '002', '001', 'Cipayung', 'Cipayung', 'Jakarta Timur', 'DKI Jakarta', '081234567891', 'siti.nurhaliza@example.com', 2, 1, 1, 1, '2020-02-01', 'Aktif', NOW(), NOW()),
            ('PKS003', 'Budi Santoso', 'Jakarta', '1988-05-10', 'Laki-laki', 'Jl. Kramat Jati Raya No. 1', '001', '002', 'Kramat Jati', 'Kramat Jati', 'Jakarta Timur', 'DKI Jakarta', '081234567892', 'budi.santoso@example.com', 2, 2, 2, 1, '2020-03-01', 'Aktif', NOW(), NOW()),
            ('PKS004', 'Dewi Sartika', 'Jakarta', '1992-07-25', 'Perempuan', 'Jl. Kramat Jati Raya No. 2', '002', '002', 'Kramat Jati', 'Kramat Jati', 'Jakarta Timur', 'DKI Jakarta', '081234567893', 'dewi.sartika@example.com', 1, 2, 2, 1, '2020-04-01', 'Aktif', NOW(), NOW()),
            ('PKS005', 'Rudi Hartono', 'Jakarta', '1987-09-12', 'Laki-laki', 'Jl. Jatinegara Raya No. 1', '001', '003', 'Jatinegara', 'Jatinegara', 'Jakarta Timur', 'DKI Jakarta', '081234567894', 'rudi.hartono@example.com', 3, 1, 3, 1, '2020-05-01', 'Aktif', NOW(), NOW())");

        $this->command->info('Demo data berhasil diinsert!');
        $this->command->info('Data yang diinsert:');
        $this->command->info('- 1 DPD: DPD PKS Jakarta Timur');
        $this->command->info('- 3 DPC: Cipayung, Kramat Jati, Jatinegara');
        $this->command->info('- 5 UPA: 2 untuk Cipayung, 2 untuk Kramat Jati, 1 untuk Jatinegara');
        $this->command->info('- 5 Anggota: 2 untuk Cipayung, 2 untuk Kramat Jati, 1 untuk Jatinegara');
    }
}
