<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Dpd;

class DpdSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $dpdData = [
            ['nama_dpd' => 'Jakarta Timur', 'kode_dpd' => 'JKT-TIM', 'deskripsi' => 'DPD Jakarta Timur'],
            ['nama_dpd' => 'Jakarta Barat', 'kode_dpd' => 'JKT-BAR', 'deskripsi' => 'DPD Jakarta Barat'],
            ['nama_dpd' => 'Jakarta Selatan', 'kode_dpd' => 'JKT-SEL', 'deskripsi' => 'DPD Jakarta Selatan'],
            ['nama_dpd' => 'Jakarta Utara', 'kode_dpd' => 'JKT-UT', 'deskripsi' => 'DPD Jakarta Utara'],
            ['nama_dpd' => 'Jakarta Pusat', 'kode_dpd' => 'JKT-PUS', 'deskripsi' => 'DPD Jakarta Pusat'],
        ];

        foreach ($dpdData as $dpd) {
            Dpd::create($dpd);
        }
    }
}
