<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Dpc;
use App\Models\Dpd;

class DpcSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Pastikan ada DPD terlebih dahulu
        $dpd = Dpd::first();
        
        if (!$dpd) {
            // Buat DPD contoh jika belum ada
            $dpd = Dpd::create([
                'nama_dpd' => 'DPD Jakarta Timur',
                'kode_dpd' => 'DPD-JKT',
                'deskripsi' => 'Dewan Pimpinan Daerah Jakarta Timur',
                'is_active' => true
            ]);
        }

        // Data DPC contoh
        $dpcs = [
            [
                'nama_dpc' => 'DPC Cipayung',
                'kode_dpc' => 'DPC-CPY',
                'dpd_id' => $dpd->dpd_id,
                'deskripsi' => 'Dewan Pimpinan Cabang Cipayung',
                'is_active' => true
            ],
            [
                'nama_dpc' => 'DPC Kramat Jati',
                'kode_dpc' => 'DPC-KRJ',
                'dpd_id' => $dpd->dpd_id,
                'deskripsi' => 'Dewan Pimpinan Cabang Kramat Jati',
                'is_active' => true
            ],
            [
                'nama_dpc' => 'DPC Makasar',
                'kode_dpc' => 'DPC-MKS',
                'dpd_id' => $dpd->dpd_id,
                'deskripsi' => 'Dewan Pimpinan Cabang Makasar',
                'is_active' => true
            ],
            [
                'nama_dpc' => 'DPC Pasar Rebo',
                'kode_dpc' => 'DPC-PRB',
                'dpd_id' => $dpd->dpd_id,
                'deskripsi' => 'Dewan Pimpinan Cabang Pasar Rebo',
                'is_active' => true
            ],
            [
                'nama_dpc' => 'DPC Cakung',
                'kode_dpc' => 'DPC-CKG',
                'dpd_id' => $dpd->dpd_id,
                'deskripsi' => 'Dewan Pimpinan Cabang Cakung',
                'is_active' => true
            ],
            [
                'nama_dpc' => 'DPC Duren Sawit',
                'kode_dpc' => 'DPC-DRS',
                'dpd_id' => $dpd->dpd_id,
                'deskripsi' => 'Dewan Pimpinan Cabang Duren Sawit',
                'is_active' => true
            ],
            [
                'nama_dpc' => 'DPC Jatinegara',
                'kode_dpc' => 'DPC-JTN',
                'dpd_id' => $dpd->dpd_id,
                'deskripsi' => 'Dewan Pimpinan Cabang Jatinegara',
                'is_active' => true
            ],
            [
                'nama_dpc' => 'DPC Matraman',
                'kode_dpc' => 'DPC-MTR',
                'dpd_id' => $dpd->dpd_id,
                'deskripsi' => 'Dewan Pimpinan Cabang Matraman',
                'is_active' => true
            ],
            [
                'nama_dpc' => 'DPC Pulo Gadung',
                'kode_dpc' => 'DPC-PGD',
                'dpd_id' => $dpd->dpd_id,
                'deskripsi' => 'Dewan Pimpinan Cabang Pulo Gadung',
                'is_active' => true
            ],
            [
                'nama_dpc' => 'DPC Ciracas',
                'kode_dpc' => 'DPC-CRC',
                'dpd_id' => $dpd->dpd_id,
                'deskripsi' => 'Dewan Pimpinan Cabang Ciracas',
                'is_active' => true
            ]
        ];

        foreach ($dpcs as $dpc) {
            // Cek apakah sudah ada berdasarkan kode_dpc
            $exists = Dpc::where('kode_dpc', $dpc['kode_dpc'])->first();
            
            if (!$exists) {
                Dpc::create($dpc);
                $this->command->info("DPC {$dpc['nama_dpc']} berhasil dibuat.");
            } else {
                $this->command->warn("DPC {$dpc['nama_dpc']} sudah ada, dilewati.");
            }
        }

        $this->command->info('Seeder DPC selesai!');
    }
}
