<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Upa;
use App\Models\Dpc;
use App\Models\Dpd;

class DemoUpaSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run()
    {
        // Buat DPD Jakarta Timur dulu jika belum ada
        $dpd = Dpd::firstOrCreate(
            ['dpd_id' => 1],
            [
                'nama_dpd' => 'DPD PKS Jakarta Timur',
                'alamat' => 'Jakarta Timur',
                'is_active' => true
            ]
        );

        // Buat beberapa DPC untuk demo
        $dpcList = [
            [
                'dpc_id' => 1,
                'nama_dpc' => 'DPC Cipayung',
                'dpd_id' => $dpd->dpd_id,
                'is_active' => true
            ],
            [
                'dpc_id' => 2,
                'nama_dpc' => 'DPC Kramat Jati',
                'dpd_id' => $dpd->dpd_id,
                'is_active' => true
            ],
            [
                'dpc_id' => 3,
                'nama_dpc' => 'DPC Jatinegara',
                'dpd_id' => $dpd->dpd_id,
                'is_active' => true
            ],
            [
                'dpc_id' => 4,
                'nama_dpc' => 'DPC Makasar',
                'dpd_id' => $dpd->dpd_id,
                'is_active' => true
            ],
            [
                'dpc_id' => 5,
                'nama_dpc' => 'DPC Pasar Rebo',
                'dpd_id' => $dpd->dpd_id,
                'is_active' => true
            ]
        ];

        foreach ($dpcList as $dpcData) {
            Dpc::firstOrCreate(
                ['dpc_id' => $dpcData['dpc_id']],
                $dpcData
            );
        }

        // Buat data UPA untuk demo
        $upaList = [
            // UPA untuk DPC Cipayung
            [
                'upa_id' => 1,
                'kode_upa' => 'UPA-CIP-001',
                'nama_upa' => 'UPA Cipayung Utara',
                'deskripsi' => 'Unit Pembinaan Anggota Cipayung Utara',
                'alamat' => 'Jl. Raya Cipayung No. 1',
                'dpc_id' => 1,
                'status' => 'Aktif'
            ],
            [
                'upa_id' => 2,
                'kode_upa' => 'UPA-CIP-002',
                'nama_upa' => 'UPA Cipayung Selatan',
                'deskripsi' => 'Unit Pembinaan Anggota Cipayung Selatan',
                'alamat' => 'Jl. Raya Cipayung No. 2',
                'dpc_id' => 1,
                'status' => 'Aktif'
            ],
            // UPA untuk DPC Kramat Jati
            [
                'upa_id' => 3,
                'kode_upa' => 'UPA-KRJ-001',
                'nama_upa' => 'UPA Kramat Jati Pusat',
                'deskripsi' => 'Unit Pembinaan Anggota Kramat Jati Pusat',
                'alamat' => 'Jl. Raya Kramat Jati No. 1',
                'dpc_id' => 2,
                'status' => 'Aktif'
            ],
            [
                'upa_id' => 4,
                'kode_upa' => 'UPA-KRJ-002',
                'nama_upa' => 'UPA Kramat Jati Timur',
                'deskripsi' => 'Unit Pembinaan Anggota Kramat Jati Timur',
                'alamat' => 'Jl. Raya Kramat Jati No. 2',
                'dpc_id' => 2,
                'status' => 'Aktif'
            ],
            // UPA untuk DPC Jatinegara
            [
                'upa_id' => 5,
                'kode_upa' => 'UPA-JTG-001',
                'nama_upa' => 'UPA Jatinegara Utara',
                'deskripsi' => 'Unit Pembinaan Anggota Jatinegara Utara',
                'alamat' => 'Jl. Raya Jatinegara No. 1',
                'dpc_id' => 3,
                'status' => 'Aktif'
            ],
            [
                'upa_id' => 6,
                'kode_upa' => 'UPA-JTG-002',
                'nama_upa' => 'UPA Jatinegara Selatan',
                'deskripsi' => 'Unit Pembinaan Anggota Jatinegara Selatan',
                'alamat' => 'Jl. Raya Jatinegara No. 2',
                'dpc_id' => 3,
                'status' => 'Aktif'
            ],
            // UPA untuk DPC Makasar
            [
                'upa_id' => 7,
                'kode_upa' => 'UPA-MKS-001',
                'nama_upa' => 'UPA Makasar Pusat',
                'deskripsi' => 'Unit Pembinaan Anggota Makasar Pusat',
                'alamat' => 'Jl. Raya Makasar No. 1',
                'dpc_id' => 4,
                'status' => 'Aktif'
            ],
            [
                'upa_id' => 8,
                'kode_upa' => 'UPA-MKS-002',
                'nama_upa' => 'UPA Makasar Barat',
                'deskripsi' => 'Unit Pembinaan Anggota Makasar Barat',
                'alamat' => 'Jl. Raya Makasar No. 2',
                'dpc_id' => 4,
                'status' => 'Aktif'
            ],
            // UPA untuk DPC Pasar Rebo
            [
                'upa_id' => 9,
                'kode_upa' => 'UPA-PRB-001',
                'nama_upa' => 'UPA Pasar Rebo Utara',
                'deskripsi' => 'Unit Pembinaan Anggota Pasar Rebo Utara',
                'alamat' => 'Jl. Raya Pasar Rebo No. 1',
                'dpc_id' => 5,
                'status' => 'Aktif'
            ],
            [
                'upa_id' => 10,
                'kode_upa' => 'UPA-PRB-002',
                'nama_upa' => 'UPA Pasar Rebo Selatan',
                'deskripsi' => 'Unit Pembinaan Anggota Pasar Rebo Selatan',
                'alamat' => 'Jl. Raya Pasar Rebo No. 2',
                'dpc_id' => 5,
                'status' => 'Aktif'
            ]
        ];

        foreach ($upaList as $upaData) {
            Upa::firstOrCreate(
                ['upa_id' => $upaData['upa_id']],
                $upaData
            );
        }

        $this->command->info('Demo UPA data berhasil diinsert!');
        $this->command->info('Total DPC: ' . count($dpcList));
        $this->command->info('Total UPA: ' . count($upaList));
    }
}
