<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Anggota;
use App\Models\RefJenjang;
use App\Models\RefGrupUpa;
use Carbon\Carbon;

class DemoAnggotaSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run()
    {
        // Buat RefJenjang jika belum ada
        $jenjangList = [
            ['jenjang' => 'Kader'],
            ['jenjang' => 'Madya'],
            ['jenjang' => 'Utama'],
            ['jenjang' => 'Pembina']
        ];

        foreach ($jenjangList as $jenjang) {
            RefJenjang::firstOrCreate(
                ['jenjang' => $jenjang['jenjang']],
                $jenjang
            );
        }

        // Buat RefGrupUpa jika belum ada
        $grupUpaList = [
            ['nama_grup_upa' => 'Grup A'],
            ['nama_grup_upa' => 'Grup B'],
            ['nama_grup_upa' => 'Grup C']
        ];

        foreach ($grupUpaList as $grup) {
            RefGrupUpa::firstOrCreate(
                ['nama_grup_upa' => $grup['nama_grup_upa']],
                $grup
            );
        }

        // Data anggota demo
        $anggotaList = [
            // Anggota untuk DPC Cipayung
            [
                'nomor_identitas_anggota' => 'PKS001',
                'nama_lengkap' => 'Ahmad Yani',
                'tempat_lahir' => 'Jakarta',
                'tanggal_lahir' => '1985-01-15',
                'jenis_kelamin' => 'Laki-laki',
                'alamat_jalan' => 'Jl. Cipayung Raya No. 1',
                'rt' => '001',
                'rw' => '001',
                'kota' => 'Jakarta Timur',
                'provinsi' => 'DKI Jakarta',
                'no_telepon' => '081234567890',
                'email' => 'ahmad.yani@example.com',
                'ref_jenjang_id' => 1, // Kader
                'ref_grup_upa_id' => 1,
                'dpc_id' => 1,
                'dpd_id' => 1,
                'tanggal_bergabung' => '2020-01-01',
                'status_keanggotaan' => 'Aktif'
            ],
            [
                'nomor_identitas_anggota' => 'PKS002',
                'nama_lengkap' => 'Siti Nurhaliza',
                'tempat_lahir' => 'Jakarta',
                'tanggal_lahir' => '1990-03-20',
                'jenis_kelamin' => 'Perempuan',
                'alamat_jalan' => 'Jl. Cipayung Raya No. 2',
                'kota' => 'Jakarta Timur',
                'provinsi' => 'DKI Jakarta',
                'no_telepon' => '081234567891',
                'email' => 'siti.nurhaliza@example.com',
                'ref_jenjang_id' => 2, // Madya
                'ref_grup_upa_id' => 1,
                'dpc_id' => 1,
                'dpd_id' => 1,
                'tanggal_bergabung' => '2020-02-01',
                'status_keanggotaan' => 'Aktif'
            ],
            // Anggota untuk DPC Kramat Jati
            [
                'nomor_identitas_anggota' => 'PKS003',
                'nama_lengkap' => 'Budi Santoso',
                'tempat_lahir' => 'Jakarta',
                'tanggal_lahir' => '1988-05-10',
                'jenis_kelamin' => 'Laki-laki',
                'alamat_jalan' => 'Jl. Kramat Jati Raya No. 1',
                'kota' => 'Jakarta Timur',
                'provinsi' => 'DKI Jakarta',
                'no_telepon' => '081234567892',
                'email' => 'budi.santoso@example.com',
                'ref_jenjang_id' => 2, // Madya
                'ref_grup_upa_id' => 2,
                'dpc_id' => 2,
                'dpd_id' => 1,
                'tanggal_bergabung' => '2020-03-01',
                'status_keanggotaan' => 'Aktif'
            ],
            [
                'nomor_identitas_anggota' => 'PKS004',
                'nama_lengkap' => 'Dewi Sartika',
                'tempat_lahir' => 'Jakarta',
                'tanggal_lahir' => '1992-07-25',
                'jenis_kelamin' => 'Perempuan',
                'alamat_jalan' => 'Jl. Kramat Jati Raya No. 2',
                'kota' => 'Jakarta Timur',
                'provinsi' => 'DKI Jakarta',
                'no_telepon' => '081234567893',
                'email' => 'dewi.sartika@example.com',
                'ref_jenjang_id' => 1, // Kader
                'ref_grup_upa_id' => 2,
                'dpc_id' => 2,
                'dpd_id' => 1,
                'tanggal_bergabung' => '2020-04-01',
                'status_keanggotaan' => 'Aktif'
            ],
            // Anggota untuk DPC Jatinegara
            [
                'nomor_identitas_anggota' => 'PKS005',
                'nama_lengkap' => 'Rudi Hartono',
                'tempat_lahir' => 'Jakarta',
                'tanggal_lahir' => '1987-09-12',
                'jenis_kelamin' => 'Laki-laki',
                'alamat_jalan' => 'Jl. Jatinegara Raya No. 1',
                'kota' => 'Jakarta Timur',
                'provinsi' => 'DKI Jakarta',
                'no_telepon' => '081234567894',
                'email' => 'rudi.hartono@example.com',
                'ref_jenjang_id' => 3, // Utama
                'ref_grup_upa_id' => 3,
                'dpc_id' => 3,
                'dpd_id' => 1,
                'tanggal_bergabung' => '2020-05-01',
                'status_keanggotaan' => 'Aktif'
            ],
            [
                'nomor_identitas_anggota' => 'PKS006',
                'nama_lengkap' => 'Maya Sari',
                'tempat_lahir' => 'Jakarta',
                'tanggal_lahir' => '1991-11-08',
                'jenis_kelamin' => 'Perempuan',
                'alamat_jalan' => 'Jl. Jatinegara Raya No. 2',
                'kota' => 'Jakarta Timur',
                'provinsi' => 'DKI Jakarta',
                'no_telepon' => '081234567895',
                'email' => 'maya.sari@example.com',
                'ref_jenjang_id' => 2, // Madya
                'ref_grup_upa_id' => 3,
                'dpc_id' => 3,
                'dpd_id' => 1,
                'tanggal_bergabung' => '2020-06-01',
                'status_keanggotaan' => 'Aktif'
            ],
            // Anggota untuk DPC Makasar
            [
                'nomor_identitas_anggota' => 'PKS007',
                'nama_lengkap' => 'Eko Prasetyo',
                'tempat_lahir' => 'Jakarta',
                'tanggal_lahir' => '1986-04-18',
                'jenis_kelamin' => 'Laki-laki',
                'alamat_jalan' => 'Jl. Makasar Raya No. 1',
                'kota' => 'Jakarta Timur',
                'provinsi' => 'DKI Jakarta',
                'no_telepon' => '081234567896',
                'email' => 'eko.prasetyo@example.com',
                'ref_jenjang_id' => 2, // Madya
                'ref_grup_upa_id' => 1,
                'dpc_id' => 4,
                'dpd_id' => 1,
                'tanggal_bergabung' => '2020-07-01',
                'status_keanggotaan' => 'Aktif'
            ],
            [
                'nomor_identitas_anggota' => 'PKS008',
                'nama_lengkap' => 'Rina Wulandari',
                'tempat_lahir' => 'Jakarta',
                'tanggal_lahir' => '1989-12-03',
                'jenis_kelamin' => 'Perempuan',
                'alamat_jalan' => 'Jl. Makasar Raya No. 2',
                'kota' => 'Jakarta Timur',
                'provinsi' => 'DKI Jakarta',
                'no_telepon' => '081234567897',
                'email' => 'rina.wulandari@example.com',
                'ref_jenjang_id' => 1, // Kader
                'ref_grup_upa_id' => 1,
                'dpc_id' => 4,
                'dpd_id' => 1,
                'tanggal_bergabung' => '2020-08-01',
                'status_keanggotaan' => 'Aktif'
            ],
            // Anggota untuk DPC Pasar Rebo
            [
                'nomor_identitas_anggota' => 'PKS009',
                'nama_lengkap' => 'Agus Supriyanto',
                'tempat_lahir' => 'Jakarta',
                'tanggal_lahir' => '1984-08-22',
                'jenis_kelamin' => 'Laki-laki',
                'alamat_jalan' => 'Jl. Pasar Rebo Raya No. 1',
                'kota' => 'Jakarta Timur',
                'provinsi' => 'DKI Jakarta',
                'no_telepon' => '081234567898',
                'email' => 'agus.supriyanto@example.com',
                'ref_jenjang_id' => 3, // Utama
                'ref_grup_upa_id' => 2,
                'dpc_id' => 5,
                'dpd_id' => 1,
                'tanggal_bergabung' => '2020-09-01',
                'status_keanggotaan' => 'Aktif'
            ],
            [
                'nomor_identitas_anggota' => 'PKS010',
                'nama_lengkap' => 'Lina Marlina',
                'tempat_lahir' => 'Jakarta',
                'tanggal_lahir' => '1993-02-14',
                'jenis_kelamin' => 'Perempuan',
                'alamat_jalan' => 'Jl. Pasar Rebo Raya No. 2',
                'kota' => 'Jakarta Timur',
                'provinsi' => 'DKI Jakarta',
                'no_telepon' => '081234567899',
                'email' => 'lina.marlina@example.com',
                'ref_jenjang_id' => 2, // Madya
                'ref_grup_upa_id' => 2,
                'dpc_id' => 5,
                'dpd_id' => 1,
                'tanggal_bergabung' => '2020-10-01',
                'status_keanggotaan' => 'Aktif'
            ]
        ];

        foreach ($anggotaList as $anggotaData) {
            Anggota::firstOrCreate(
                ['nomor_identitas_anggota' => $anggotaData['nomor_identitas_anggota']],
                $anggotaData
            );
        }

        $this->command->info('Demo Anggota data berhasil diinsert!');
        $this->command->info('Total Anggota: ' . count($anggotaList));
    }
}
