<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\AktivitasLuar;

class AktivitasLuarSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $aktivitasLuars = [
            [
                'nama_aktivitas' => 'Pengurus Masjid',
                'deskripsi' => 'Menjadi pengurus masjid atau takmir masjid',
                'is_active' => true
            ],
            [
                'nama_aktivitas' => 'Ketua Majelis Taklim',
                'deskripsi' => 'Memimpin majelis taklim atau pengajian',
                'is_active' => true
            ],
            [
                'nama_aktivitas' => 'Pengurus Yayasan',
                'deskripsi' => 'Menjadi pengurus yayasan pendidikan atau sosial',
                'is_active' => true
            ],
            [
                'nama_aktivitas' => 'Ketua RT/RW',
                'deskripsi' => 'Menjadi ketua RT atau RW di lingkungan tempat tinggal',
                'is_active' => true
            ],
            [
                'nama_aktivitas' => 'Pengurus Karang Taruna',
                'deskripsi' => 'Menjadi pengurus karang taruna di tingkat kelurahan/desa',
                'is_active' => true
            ],
            [
                'nama_aktivitas' => 'Pengurus PKK',
                'deskripsi' => 'Menjadi pengurus PKK (Pemberdayaan Kesejahteraan Keluarga)',
                'is_active' => true
            ],
            [
                'nama_aktivitas' => 'Pengurus BUMDes',
                'deskripsi' => 'Menjadi pengurus Badan Usaha Milik Desa',
                'is_active' => true
            ],
            [
                'nama_aktivitas' => 'Pengurus Koperasi',
                'deskripsi' => 'Menjadi pengurus koperasi atau unit usaha bersama',
                'is_active' => true
            ],
            [
                'nama_aktivitas' => 'Pengurus Ormas',
                'deskripsi' => 'Menjadi pengurus organisasi masyarakat',
                'is_active' => true
            ],
            [
                'nama_aktivitas' => 'Pengurus LSM',
                'deskripsi' => 'Menjadi pengurus lembaga swadaya masyarakat',
                'is_active' => true
            ],
            [
                'nama_aktivitas' => 'Pengurus Komite Sekolah',
                'deskripsi' => 'Menjadi pengurus komite sekolah atau dewan pendidikan',
                'is_active' => true
            ],
            [
                'nama_aktivitas' => 'Pengurus BPD',
                'deskripsi' => 'Menjadi pengurus Badan Permusyawaratan Desa',
                'is_active' => true
            ],
            [
                'nama_aktivitas' => 'Pengurus LPM',
                'deskripsi' => 'Menjadi pengurus Lembaga Pemberdayaan Masyarakat',
                'is_active' => true
            ],
            [
                'nama_aktivitas' => 'Pengurus Posyandu',
                'deskripsi' => 'Menjadi pengurus posyandu atau kegiatan kesehatan masyarakat',
                'is_active' => true
            ],
            [
                'nama_aktivitas' => 'Pengurus Bank Sampah',
                'deskripsi' => 'Menjadi pengurus bank sampah atau kegiatan lingkungan',
                'is_active' => true
            ],
            [
                'nama_aktivitas' => 'Pengurus Taman Baca',
                'deskripsi' => 'Menjadi pengurus taman baca atau perpustakaan masyarakat',
                'is_active' => true
            ],
            [
                'nama_aktivitas' => 'Pengurus Kelompok Tani',
                'deskripsi' => 'Menjadi pengurus kelompok tani atau kelompok usaha tani',
                'is_active' => true
            ],
            [
                'nama_aktivitas' => 'Pengurus Kelompok Nelayan',
                'deskripsi' => 'Menjadi pengurus kelompok nelayan atau kelompok usaha perikanan',
                'is_active' => true
            ],
            [
                'nama_aktivitas' => 'Pengurus Kelompok UMKM',
                'deskripsi' => 'Menjadi pengurus kelompok usaha mikro, kecil, dan menengah',
                'is_active' => true
            ],
            [
                'nama_aktivitas' => 'Pengurus Kelompok Wanita',
                'deskripsi' => 'Menjadi pengurus kelompok wanita atau organisasi perempuan',
                'is_active' => true
            ],
            [
                'nama_aktivitas' => 'Pengurus Kelompok Pemuda',
                'deskripsi' => 'Menjadi pengurus organisasi pemuda atau kelompok kepemudaan',
                'is_active' => true
            ],
            [
                'nama_aktivitas' => 'Pengurus Kelompok Lansia',
                'deskripsi' => 'Menjadi pengurus kelompok lansia atau organisasi senior',
                'is_active' => true
            ],
            [
                'nama_aktivitas' => 'Pengurus Kelompok Difabel',
                'deskripsi' => 'Menjadi pengurus organisasi difabel atau kelompok penyandang disabilitas',
                'is_active' => true
            ],
            [
                'nama_aktivitas' => 'Pengurus Kelompok Migran',
                'deskripsi' => 'Menjadi pengurus organisasi migran atau kelompok perantau',
                'is_active' => true
            ],
            [
                'nama_aktivitas' => 'Pengurus Kelompok Seni Budaya',
                'deskripsi' => 'Menjadi pengurus kelompok seni budaya atau sanggar seni',
                'is_active' => true
            ],
            [
                'nama_aktivitas' => 'Pengurus Kelompok Olahraga',
                'deskripsi' => 'Menjadi pengurus klub olahraga atau organisasi olahraga',
                'is_active' => true
            ],
            [
                'nama_aktivitas' => 'Pengurus Kelompok Keagamaan',
                'deskripsi' => 'Menjadi pengurus organisasi keagamaan selain masjid',
                'is_active' => true
            ],
            [
                'nama_aktivitas' => 'Pengurus Kelompok Sosial',
                'deskripsi' => 'Menjadi pengurus organisasi sosial atau kegiatan sosial',
                'is_active' => true
            ],
            [
                'nama_aktivitas' => 'Pengurus Kelompok Profesi',
                'deskripsi' => 'Menjadi pengurus organisasi profesi atau asosiasi profesi',
                'is_active' => true
            ],
            [
                'nama_aktivitas' => 'Lainnya',
                'deskripsi' => 'Aktivitas lain di luar pekerjaan yang tidak tercantum dalam daftar',
                'is_active' => true
            ]
        ];

        foreach ($aktivitasLuars as $aktivitas) {
            AktivitasLuar::create($aktivitas);
        }
    }
}