<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('tbl_anggota_jenjang_history', function (Blueprint $table) {
            // Drop the column (foreign key will be dropped automatically)
            $table->dropColumn('ref_grup_upa_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('tbl_anggota_jenjang_history', function (Blueprint $table) {
            // Add the column back
            $table->unsignedBigInteger('ref_grup_upa_id')->nullable()->after('ref_jenjang_id');
            
            // Add foreign key constraint back
            $table->foreign('ref_grup_upa_id')->references('ref_grup_upa_id')->on('tbl_ref_grup_upa')->onDelete('set null');
        });
    }
};