<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('tbl_anggota', function (Blueprint $table) {
            // Drop foreign key constraint first
            $table->dropForeign(['ref_grup_upa_id']);
            
            // Drop the column
            $table->dropColumn('ref_grup_upa_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('tbl_anggota', function (Blueprint $table) {
            // Add the column back
            $table->unsignedBigInteger('ref_grup_upa_id')->nullable()->after('ref_jenjang_id');
            
            // Add foreign key constraint back
            $table->foreign('ref_grup_upa_id')->references('ref_grup_upa_id')->on('tbl_ref_grup_upa')->onDelete('set null');
        });
    }
};