<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        // Pastikan tabel struktur_organisasi ada dan memiliki data dasar
        if (!Schema::hasTable('tbl_struktur_organisasi')) {
            Schema::create('tbl_struktur_organisasi', function (Blueprint $table) {
                $table->id();
                $table->string('kode_struktur')->unique();
                $table->string('nama_struktur');
                $table->text('deskripsi')->nullable();
                $table->enum('status', ['Aktif', 'Tidak Aktif'])->default('Aktif');
                $table->timestamps();
            });
        }

        // Insert data dasar untuk DPD dan DPC yang ada
        $this->insertStrukturOrganisasiData();
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        // Jangan hapus data, hanya rollback jika diperlukan
    }

    /**
     * Insert data struktur organisasi berdasarkan DPD dan DPC yang ada
     */
    private function insertStrukturOrganisasiData(): void
    {
        // Insert DPD data - cek apakah kolom status ada
        $hasStatusColumn = Schema::hasColumn('tbl_dpd', 'status');
        $dpds = $hasStatusColumn 
            ? DB::table('tbl_dpd')->where('status', 'Aktif')->get()
            : DB::table('tbl_dpd')->get();
            
        foreach ($dpds as $dpd) {
            $existing = DB::table('tbl_struktur_organisasi')
                ->where('nama_struktur', 'like', '%' . $dpd->nama_dpd . '%')
                ->first();
            
            if (!$existing) {
                DB::table('tbl_struktur_organisasi')->insert([
                    'kode_struktur' => 'DPD-' . $dpd->dpd_id,
                    'nama_struktur' => $dpd->nama_dpd,
                    'deskripsi' => 'DPD ' . $dpd->nama_dpd,
                    'status' => 'Aktif',
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);
            }
        }

        // Insert DPC data - cek apakah kolom status ada
        $hasDpcStatusColumn = Schema::hasColumn('tbl_dpc', 'status');
        $dpcs = $hasDpcStatusColumn 
            ? DB::table('tbl_dpc')->where('status', 'Aktif')->get()
            : DB::table('tbl_dpc')->get();
            
        foreach ($dpcs as $dpc) {
            $existing = DB::table('tbl_struktur_organisasi')
                ->where('nama_struktur', 'like', '%' . $dpc->nama_dpc . '%')
                ->first();
            
            if (!$existing) {
                DB::table('tbl_struktur_organisasi')->insert([
                    'kode_struktur' => 'DPC-' . $dpc->dpc_id,
                    'nama_struktur' => $dpc->nama_dpc,
                    'deskripsi' => 'DPC ' . $dpc->nama_dpc,
                    'status' => 'Aktif',
                    'created_at' => now(),
                    'updated_at' => now(),
                ]);
            }
        }
    }
};