<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_riwayat_perpindahan_anggota', function (Blueprint $table) {
            $table->id();
            
            // Tipe transaksi perpindahan
            $table->enum('tipe_transaksi', ['mutasi', 'penempatan', 'perpindahan', 'rekomposisi'])
                  ->comment('Jenis perpindahan: mutasi, penempatan, perpindahan, atau rekomposisi');
            
            // Data Anggota yang dipindahkan
            $table->unsignedBigInteger('anggota_id');
            $table->foreign('anggota_id')->references('id')->on('tbl_anggota')->onDelete('cascade');
            
            // UPA Asal dan Tujuan
            $table->unsignedBigInteger('upa_asal_id')->nullable();
            $table->foreign('upa_asal_id')->references('upa_id')->on('tbl_upa')->onDelete('set null');
            
            $table->unsignedBigInteger('upa_tujuan_id')->nullable();
            $table->foreign('upa_tujuan_id')->references('upa_id')->on('tbl_upa')->onDelete('set null');
            
            // DPC Asal dan Tujuan
            $table->unsignedBigInteger('dpc_asal_id')->nullable();
            $table->foreign('dpc_asal_id')->references('dpc_id')->on('tbl_dpc')->onDelete('set null');
            
            $table->unsignedBigInteger('dpc_tujuan_id')->nullable();
            $table->foreign('dpc_tujuan_id')->references('dpc_id')->on('tbl_dpc')->onDelete('set null');
            
            // Pembimbing
            $table->unsignedBigInteger('pembimbing_lama_id')->nullable();
            $table->foreign('pembimbing_lama_id')->references('id')->on('tbl_anggota')->onDelete('set null');
            
            $table->unsignedBigInteger('pembimbing_baru_id')->nullable();
            $table->foreign('pembimbing_baru_id')->references('id')->on('tbl_anggota')->onDelete('set null');
            
            // Informasi Perpindahan
            $table->date('tanggal_efektif')->comment('Tanggal berlakunya perpindahan');
            $table->string('tahun_pelantikan', 10)->nullable()->comment('Khusus untuk penempatan');
            $table->string('nomor_surat', 100)->unique();
            $table->text('alasan')->nullable()->comment('Alasan perpindahan');
            $table->text('catatan')->nullable();
            
            // Metadata tambahan (flexible untuk kebutuhan spesifik per tipe)
            $table->json('metadata_json')->nullable();
            
            // Status dan Approval
            $table->enum('status', ['draft', 'pending', 'approved', 'completed', 'cancelled'])->default('completed');
            
            $table->unsignedBigInteger('created_by')->nullable();
            $table->foreign('created_by')->references('id')->on('users')->onDelete('set null');
            
            $table->unsignedBigInteger('approved_by')->nullable();
            $table->foreign('approved_by')->references('id')->on('users')->onDelete('set null');
            
            $table->timestamp('approved_at')->nullable();
            
            // ID rekomposisi batch (jika bagian dari rekomposisi massal)
            $table->unsignedBigInteger('rekomposisi_batch_id')->nullable()->comment('ID batch rekomposisi jika perpindahan massal');
            
            $table->timestamps();
            
            // Indexes untuk performa query
            $table->index('anggota_id');
            $table->index('tipe_transaksi');
            $table->index('tanggal_efektif');
            $table->index('status');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_riwayat_perpindahan_anggota');
    }
};
