<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('tbl_mutasi', function (Blueprint $table) {
            // Add DPD Asal (origin) and DPD Tujuan (destination)
            $table->string('dpd_dari')->nullable()->after('struktur_dari');
            $table->string('dpd_ke')->nullable()->after('struktur_ke');
            
            // Add index for better query performance
            $table->index('dpd_dari');
            $table->index('dpd_ke');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('tbl_mutasi', function (Blueprint $table) {
            $table->dropIndex(['dpd_dari']);
            $table->dropIndex(['dpd_ke']);
            $table->dropColumn(['dpd_dari', 'dpd_ke']);
        });
    }
};
