<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('perpindahan_anggota', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('anggota_id');
            $table->date('tanggal_perpindahan');
            
            // Data sebelum perpindahan
            $table->unsignedBigInteger('dpd_id_before')->nullable();
            $table->unsignedBigInteger('dpc_id_before')->nullable();
            $table->unsignedBigInteger('upa_id_before')->nullable();
            $table->unsignedBigInteger('ref_jenjang_id_before')->nullable();
            $table->unsignedBigInteger('ref_grup_upa_id_before')->nullable();
            
            // Data setelah perpindahan
            $table->unsignedBigInteger('dpd_id_after')->nullable();
            $table->unsignedBigInteger('dpc_id_after')->nullable();
            $table->unsignedBigInteger('upa_id_after')->nullable();
            $table->unsignedBigInteger('ref_jenjang_id_after')->nullable();
            $table->unsignedBigInteger('ref_grup_upa_id_after')->nullable();
            
            // Keterangan perpindahan
            $table->text('keterangan')->nullable();
            $table->string('status_perpindahan')->default('Diajukan'); // Diajukan, Disetujui, Ditolak
            $table->text('catatan_admin')->nullable();
            $table->unsignedBigInteger('created_by')->nullable(); // User yang membuat perpindahan
            $table->unsignedBigInteger('approved_by')->nullable(); // User yang menyetujui
            
            $table->timestamps();
            
            // Foreign key constraints
            $table->foreign('anggota_id')->references('id')->on('tbl_anggota')->onDelete('cascade');
            $table->foreign('dpd_id_before')->references('dpd_id')->on('tbl_dpd')->onDelete('set null');
            $table->foreign('dpc_id_before')->references('dpc_id')->on('tbl_dpc')->onDelete('set null');
            $table->foreign('upa_id_before')->references('upa_id')->on('tbl_upa')->onDelete('set null');
            $table->foreign('ref_jenjang_id_before')->references('ref_jenjang_id')->on('tbl_ref_jenjang')->onDelete('set null');
            $table->foreign('ref_grup_upa_id_before')->references('ref_grup_upa_id')->on('tbl_ref_grup_upa')->onDelete('set null');
            
            $table->foreign('dpd_id_after')->references('dpd_id')->on('tbl_dpd')->onDelete('set null');
            $table->foreign('dpc_id_after')->references('dpc_id')->on('tbl_dpc')->onDelete('set null');
            $table->foreign('upa_id_after')->references('upa_id')->on('tbl_upa')->onDelete('set null');
            $table->foreign('ref_jenjang_id_after')->references('ref_jenjang_id')->on('tbl_ref_jenjang')->onDelete('set null');
            $table->foreign('ref_grup_upa_id_after')->references('ref_grup_upa_id')->on('tbl_ref_grup_upa')->onDelete('set null');
            
            $table->foreign('created_by')->references('id')->on('users')->onDelete('set null');
            $table->foreign('approved_by')->references('id')->on('users')->onDelete('set null');
            
            // Indexes
            $table->index(['anggota_id', 'tanggal_perpindahan']);
            $table->index('status_perpindahan');
            $table->index('tanggal_perpindahan');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('perpindahan_anggota');
    }
};
