<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('tbl_anggota_jenjang_history', function (Blueprint $table) {
            $table->id();
            
            // Foreign key ke anggota
            $table->unsignedBigInteger('anggota_id');
            $table->foreign('anggota_id')->references('id')->on('tbl_anggota')->onDelete('cascade');
            
            // Data keanggotaan yang akan dihistory
            $table->unsignedBigInteger('ref_jenjang_id')->nullable();
            $table->unsignedBigInteger('ref_grup_upa_id')->nullable();
            $table->unsignedBigInteger('dpc_id')->nullable();
            $table->unsignedBigInteger('dpd_id')->nullable();
            $table->unsignedBigInteger('upa_id')->nullable();
            
            // Tanggal perubahan
            $table->date('tanggal_perubahan');
            
            // Keterangan perubahan
            $table->text('keterangan')->nullable();
            
            // User yang melakukan perubahan
            $table->unsignedBigInteger('user_id')->nullable();
            $table->foreign('user_id')->references('id')->on('users')->onDelete('set null');
            
            // Status perubahan (Aktif, Tidak Aktif, dll)
            $table->enum('status_keanggotaan', ['Aktif', 'Tidak Aktif', 'Diberhentikan', 'Pindah'])->nullable();
            
            $table->timestamps();
            
            // Indexes untuk performance
            $table->index('anggota_id');
            $table->index('tanggal_perubahan');
            $table->index(['anggota_id', 'tanggal_perubahan']);
            $table->index('ref_jenjang_id');
            $table->index('ref_grup_upa_id');
            $table->index('dpc_id');
            $table->index('dpd_id');
            $table->index('upa_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('tbl_anggota_jenjang_history');
    }
};
