<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('yaumiyah_records', function (Blueprint $table) {
            $table->enum('created_by', ['admin', 'member'])->default('admin')->after('notes');
            $table->string('created_by_name')->nullable()->after('created_by');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('yaumiyah_records', function (Blueprint $table) {
            $table->dropColumn(['created_by', 'created_by_name']);
        });
    }
};
