<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('yaumiyah_records', function (Blueprint $table) {
            $table->id();
            $table->foreignId('yaumiyah_activity_id')->constrained()->onDelete('cascade');
            $table->foreignId('anggota_id')->constrained('tbl_anggota')->onDelete('cascade');
            $table->integer('week_number');
            $table->integer('year');
            $table->integer('value')->default(0);
            $table->text('notes')->nullable();
            $table->timestamps();
            
            $table->unique(['yaumiyah_activity_id', 'anggota_id', 'week_number', 'year'], 'yaumiyah_records_unique');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('yaumiyah_records');
    }
};
