<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('upa_group_attendances', function (Blueprint $table) {
            $table->id('attendance_id');
            $table->unsignedBigInteger('activity_id');
            $table->unsignedBigInteger('anggota_id');
            $table->enum('status_kehadiran', ['Hadir', 'Tidak Hadir'])->default('Tidak Hadir');
            $table->text('catatan')->nullable();
            $table->timestamps();
            
            $table->foreign('activity_id')->references('activity_id')->on('upa_group_activities')->onDelete('cascade');
            $table->foreign('anggota_id')->references('id')->on('tbl_anggota')->onDelete('cascade');
            $table->unique(['activity_id', 'anggota_id']);
            $table->index(['activity_id', 'status_kehadiran']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('upa_group_attendances');
    }
};
