<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('upa_group_activities', function (Blueprint $table) {
            $table->id('activity_id');
            $table->string('kode_upa');
            $table->string('nama_pembimbing');
            $table->date('tanggal_upa');
            $table->time('waktu_upa');
            $table->boolean('kehadiran_pembimbing')->default(false);
            $table->text('agenda_upa')->nullable();
            $table->enum('status_terlaksana', ['Terlaksana', 'Tidak Terlaksana'])->default('Tidak Terlaksana');
            $table->text('catatan')->nullable();
            $table->timestamps();
            
            $table->index(['kode_upa', 'tanggal_upa']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('upa_group_activities');
    }
};
