<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('tbl_anggota', function (Blueprint $table) {
            // Index untuk query yang sering digunakan
            $table->index(['status_keanggotaan', 'ref_jenjang_id'], 'idx_status_jenjang');
            $table->index(['status_keanggotaan', 'dpc_id'], 'idx_status_dpc');
            $table->index(['status_keanggotaan', 'dpd_id'], 'idx_status_dpd');
            $table->index(['status_keanggotaan', 'ref_grup_upa_id'], 'idx_status_grup_upa');
            $table->index(['tanggal_bergabung'], 'idx_tanggal_bergabung');
            $table->index(['created_at'], 'idx_created_at');
            $table->index(['nama_lengkap'], 'idx_nama_lengkap');
            $table->index(['nomor_identitas_anggota'], 'idx_nomor_identitas');
            
            // Composite index untuk dashboard queries
            $table->index(['status_keanggotaan', 'ref_jenjang_id', 'dpc_id'], 'idx_dashboard_dpc');
            $table->index(['status_keanggotaan', 'ref_jenjang_id', 'dpd_id'], 'idx_dashboard_dpd');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('tbl_anggota', function (Blueprint $table) {
            $table->dropIndex('idx_status_jenjang');
            $table->dropIndex('idx_status_dpc');
            $table->dropIndex('idx_status_dpd');
            $table->dropIndex('idx_status_grup_upa');
            $table->dropIndex('idx_tanggal_bergabung');
            $table->dropIndex('idx_created_at');
            $table->dropIndex('idx_nama_lengkap');
            $table->dropIndex('idx_nomor_identitas');
            $table->dropIndex('idx_dashboard_dpc');
            $table->dropIndex('idx_dashboard_dpd');
        });
    }
};